/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration parameters for ELB load balancer logging, including output format and field delimiter settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ELBLoadBalancerLoggingParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<ELBLoadBalancerLoggingParameters.Builder, ELBLoadBalancerLoggingParameters> {
    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputFormat").getter(getter(ELBLoadBalancerLoggingParameters::outputFormatAsString))
            .setter(setter(Builder::outputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()).build();

    private static final SdkField<String> FIELD_DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldDelimiter").getter(getter(ELBLoadBalancerLoggingParameters::fieldDelimiter))
            .setter(setter(Builder::fieldDelimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldDelimiter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_FORMAT_FIELD,
            FIELD_DELIMITER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String outputFormat;

    private final String fieldDelimiter;

    private ELBLoadBalancerLoggingParameters(BuilderImpl builder) {
        this.outputFormat = builder.outputFormat;
        this.fieldDelimiter = builder.fieldDelimiter;
    }

    /**
     * <p>
     * The format for ELB access log entries (plain text or JSON format).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The format for ELB access log entries (plain text or JSON format).
     * @see OutputFormat
     */
    public final OutputFormat outputFormat() {
        return OutputFormat.fromValue(outputFormat);
    }

    /**
     * <p>
     * The format for ELB access log entries (plain text or JSON format).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The format for ELB access log entries (plain text or JSON format).
     * @see OutputFormat
     */
    public final String outputFormatAsString() {
        return outputFormat;
    }

    /**
     * <p>
     * The delimiter character used to separate fields in ELB access log entries when using plain text format.
     * </p>
     * 
     * @return The delimiter character used to separate fields in ELB access log entries when using plain text format.
     */
    public final String fieldDelimiter() {
        return fieldDelimiter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fieldDelimiter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ELBLoadBalancerLoggingParameters)) {
            return false;
        }
        ELBLoadBalancerLoggingParameters other = (ELBLoadBalancerLoggingParameters) obj;
        return Objects.equals(outputFormatAsString(), other.outputFormatAsString())
                && Objects.equals(fieldDelimiter(), other.fieldDelimiter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ELBLoadBalancerLoggingParameters").add("OutputFormat", outputFormatAsString())
                .add("FieldDelimiter", fieldDelimiter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputFormat":
            return Optional.ofNullable(clazz.cast(outputFormatAsString()));
        case "FieldDelimiter":
            return Optional.ofNullable(clazz.cast(fieldDelimiter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OutputFormat", OUTPUT_FORMAT_FIELD);
        map.put("FieldDelimiter", FIELD_DELIMITER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ELBLoadBalancerLoggingParameters, T> g) {
        return obj -> g.apply((ELBLoadBalancerLoggingParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ELBLoadBalancerLoggingParameters> {
        /**
         * <p>
         * The format for ELB access log entries (plain text or JSON format).
         * </p>
         * 
         * @param outputFormat
         *        The format for ELB access log entries (plain text or JSON format).
         * @see OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputFormat
         */
        Builder outputFormat(String outputFormat);

        /**
         * <p>
         * The format for ELB access log entries (plain text or JSON format).
         * </p>
         * 
         * @param outputFormat
         *        The format for ELB access log entries (plain text or JSON format).
         * @see OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputFormat
         */
        Builder outputFormat(OutputFormat outputFormat);

        /**
         * <p>
         * The delimiter character used to separate fields in ELB access log entries when using plain text format.
         * </p>
         * 
         * @param fieldDelimiter
         *        The delimiter character used to separate fields in ELB access log entries when using plain text
         *        format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldDelimiter(String fieldDelimiter);
    }

    static final class BuilderImpl implements Builder {
        private String outputFormat;

        private String fieldDelimiter;

        private BuilderImpl() {
        }

        private BuilderImpl(ELBLoadBalancerLoggingParameters model) {
            outputFormat(model.outputFormat);
            fieldDelimiter(model.fieldDelimiter);
        }

        public final String getOutputFormat() {
            return outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final String getFieldDelimiter() {
            return fieldDelimiter;
        }

        public final void setFieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
        }

        @Override
        public final Builder fieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        @Override
        public ELBLoadBalancerLoggingParameters build() {
            return new ELBLoadBalancerLoggingParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
