/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.observabilityadmin.internal.ObservabilityAdminServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.observabilityadmin.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.observabilityadmin.model.AccessDeniedException;
import software.amazon.awssdk.services.observabilityadmin.model.ConflictException;
import software.amazon.awssdk.services.observabilityadmin.model.CreateCentralizationRuleForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.CreateCentralizationRuleForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.CreateS3TableIntegrationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.CreateS3TableIntegrationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.CreateTelemetryPipelineRequest;
import software.amazon.awssdk.services.observabilityadmin.model.CreateTelemetryPipelineResponse;
import software.amazon.awssdk.services.observabilityadmin.model.CreateTelemetryRuleForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.CreateTelemetryRuleForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.CreateTelemetryRuleRequest;
import software.amazon.awssdk.services.observabilityadmin.model.CreateTelemetryRuleResponse;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteCentralizationRuleForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteCentralizationRuleForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteS3TableIntegrationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteS3TableIntegrationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteTelemetryPipelineRequest;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteTelemetryPipelineResponse;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteTelemetryRuleForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteTelemetryRuleForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteTelemetryRuleRequest;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteTelemetryRuleResponse;
import software.amazon.awssdk.services.observabilityadmin.model.GetCentralizationRuleForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.GetCentralizationRuleForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.GetS3TableIntegrationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.GetS3TableIntegrationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEnrichmentStatusRequest;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEnrichmentStatusResponse;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEvaluationStatusForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEvaluationStatusForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEvaluationStatusRequest;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEvaluationStatusResponse;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryPipelineRequest;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryPipelineResponse;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryRuleForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryRuleForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryRuleRequest;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryRuleResponse;
import software.amazon.awssdk.services.observabilityadmin.model.InternalServerException;
import software.amazon.awssdk.services.observabilityadmin.model.InvalidStateException;
import software.amazon.awssdk.services.observabilityadmin.model.ListCentralizationRulesForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListCentralizationRulesForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ListS3TableIntegrationsRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListS3TableIntegrationsResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryPipelinesRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryPipelinesResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ObservabilityAdminException;
import software.amazon.awssdk.services.observabilityadmin.model.ResourceNotFoundException;
import software.amazon.awssdk.services.observabilityadmin.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEnrichmentRequest;
import software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEnrichmentResponse;
import software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEvaluationForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEvaluationForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEvaluationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEvaluationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEnrichmentRequest;
import software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEnrichmentResponse;
import software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEvaluationForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEvaluationForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEvaluationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEvaluationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TagResourceRequest;
import software.amazon.awssdk.services.observabilityadmin.model.TagResourceResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TestTelemetryPipelineRequest;
import software.amazon.awssdk.services.observabilityadmin.model.TestTelemetryPipelineResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TooManyRequestsException;
import software.amazon.awssdk.services.observabilityadmin.model.UntagResourceRequest;
import software.amazon.awssdk.services.observabilityadmin.model.UntagResourceResponse;
import software.amazon.awssdk.services.observabilityadmin.model.UpdateCentralizationRuleForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.UpdateCentralizationRuleForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.UpdateTelemetryPipelineRequest;
import software.amazon.awssdk.services.observabilityadmin.model.UpdateTelemetryPipelineResponse;
import software.amazon.awssdk.services.observabilityadmin.model.UpdateTelemetryRuleForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.UpdateTelemetryRuleForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.UpdateTelemetryRuleRequest;
import software.amazon.awssdk.services.observabilityadmin.model.UpdateTelemetryRuleResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ValidateTelemetryPipelineConfigurationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ValidateTelemetryPipelineConfigurationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ValidationException;
import software.amazon.awssdk.services.observabilityadmin.transform.CreateCentralizationRuleForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.CreateS3TableIntegrationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.CreateTelemetryPipelineRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.CreateTelemetryRuleForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.CreateTelemetryRuleRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.DeleteCentralizationRuleForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.DeleteS3TableIntegrationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.DeleteTelemetryPipelineRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.DeleteTelemetryRuleForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.DeleteTelemetryRuleRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.GetCentralizationRuleForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.GetS3TableIntegrationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.GetTelemetryEnrichmentStatusRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.GetTelemetryEvaluationStatusForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.GetTelemetryEvaluationStatusRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.GetTelemetryPipelineRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.GetTelemetryRuleForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.GetTelemetryRuleRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.ListCentralizationRulesForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.ListResourceTelemetryForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.ListResourceTelemetryRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.ListS3TableIntegrationsRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.ListTelemetryPipelinesRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.ListTelemetryRulesForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.ListTelemetryRulesRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.StartTelemetryEnrichmentRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.StartTelemetryEvaluationForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.StartTelemetryEvaluationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.StopTelemetryEnrichmentRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.StopTelemetryEvaluationForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.StopTelemetryEvaluationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.TestTelemetryPipelineRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.UpdateCentralizationRuleForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.UpdateTelemetryPipelineRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.UpdateTelemetryRuleForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.UpdateTelemetryRuleRequestMarshaller;
import software.amazon.awssdk.services.observabilityadmin.transform.ValidateTelemetryPipelineConfigurationRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ObservabilityAdminAsyncClient}.
 *
 * @see ObservabilityAdminAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultObservabilityAdminAsyncClient implements ObservabilityAdminAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultObservabilityAdminAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultObservabilityAdminAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "ObservabilityAdmin" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates a centralization rule that applies across an Amazon Web Services Organization. This operation can only be
     * called by the organization's management account or a delegated administrator account.
     * </p>
     *
     * @param createCentralizationRuleForOrganizationRequest
     * @return A Java Future containing the result of the CreateCentralizationRuleForOrganization operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The requested operation would exceed the allowed quota for the
     *         specified resource type.</li>
     *         <li>ConflictException The requested operation conflicts with the current state of the specified resource
     *         or with another request.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.CreateCentralizationRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/CreateCentralizationRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCentralizationRuleForOrganizationResponse> createCentralizationRuleForOrganization(
            CreateCentralizationRuleForOrganizationRequest createCentralizationRuleForOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCentralizationRuleForOrganizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCentralizationRuleForOrganizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCentralizationRuleForOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCentralizationRuleForOrganizationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateCentralizationRuleForOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateCentralizationRuleForOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCentralizationRuleForOrganizationRequest, CreateCentralizationRuleForOrganizationResponse>()
                            .withOperationName("CreateCentralizationRuleForOrganization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCentralizationRuleForOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCentralizationRuleForOrganizationRequest));
            CompletableFuture<CreateCentralizationRuleForOrganizationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an integration between CloudWatch and S3 Tables for analytics. This integration enables querying
     * CloudWatch telemetry data using analytics engines like Amazon Athena, Amazon Redshift, and Apache Spark.
     * </p>
     *
     * @param createS3TableIntegrationRequest
     * @return A Java Future containing the result of the CreateS3TableIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The requested operation would exceed the allowed quota for the
     *         specified resource type.</li>
     *         <li>ConflictException The requested operation conflicts with the current state of the specified resource
     *         or with another request.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.CreateS3TableIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/CreateS3TableIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateS3TableIntegrationResponse> createS3TableIntegration(
            CreateS3TableIntegrationRequest createS3TableIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createS3TableIntegrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createS3TableIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateS3TableIntegration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateS3TableIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateS3TableIntegrationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateS3TableIntegrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateS3TableIntegrationRequest, CreateS3TableIntegrationResponse>()
                            .withOperationName("CreateS3TableIntegration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateS3TableIntegrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createS3TableIntegrationRequest));
            CompletableFuture<CreateS3TableIntegrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a telemetry pipeline for processing and transforming telemetry data. The pipeline defines how data flows
     * from sources through processors to destinations, enabling data transformation and delivering capabilities.
     * </p>
     *
     * @param createTelemetryPipelineRequest
     * @return A Java Future containing the result of the CreateTelemetryPipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The requested operation would exceed the allowed quota for the
     *         specified resource type.</li>
     *         <li>ConflictException The requested operation conflicts with the current state of the specified resource
     *         or with another request.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.CreateTelemetryPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/CreateTelemetryPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTelemetryPipelineResponse> createTelemetryPipeline(
            CreateTelemetryPipelineRequest createTelemetryPipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTelemetryPipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTelemetryPipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTelemetryPipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTelemetryPipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTelemetryPipelineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateTelemetryPipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTelemetryPipelineRequest, CreateTelemetryPipelineResponse>()
                            .withOperationName("CreateTelemetryPipeline").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTelemetryPipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTelemetryPipelineRequest));
            CompletableFuture<CreateTelemetryPipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a telemetry rule that defines how telemetry should be configured for Amazon Web Services resources in
     * your account. The rule specifies which resources should have telemetry enabled and how that telemetry data should
     * be collected based on resource type, telemetry type, and selection criteria.
     * </p>
     *
     * @param createTelemetryRuleRequest
     * @return A Java Future containing the result of the CreateTelemetryRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The requested operation would exceed the allowed quota for the
     *         specified resource type.</li>
     *         <li>ConflictException The requested operation conflicts with the current state of the specified resource
     *         or with another request.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.CreateTelemetryRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/CreateTelemetryRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTelemetryRuleResponse> createTelemetryRule(
            CreateTelemetryRuleRequest createTelemetryRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTelemetryRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTelemetryRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTelemetryRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTelemetryRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTelemetryRuleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateTelemetryRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTelemetryRuleRequest, CreateTelemetryRuleResponse>()
                            .withOperationName("CreateTelemetryRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTelemetryRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTelemetryRuleRequest));
            CompletableFuture<CreateTelemetryRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a telemetry rule that applies across an Amazon Web Services Organization. This operation can only be
     * called by the organization's management account or a delegated administrator account.
     * </p>
     *
     * @param createTelemetryRuleForOrganizationRequest
     * @return A Java Future containing the result of the CreateTelemetryRuleForOrganization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The requested operation would exceed the allowed quota for the
     *         specified resource type.</li>
     *         <li>ConflictException The requested operation conflicts with the current state of the specified resource
     *         or with another request.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.CreateTelemetryRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/CreateTelemetryRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTelemetryRuleForOrganizationResponse> createTelemetryRuleForOrganization(
            CreateTelemetryRuleForOrganizationRequest createTelemetryRuleForOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTelemetryRuleForOrganizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTelemetryRuleForOrganizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTelemetryRuleForOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTelemetryRuleForOrganizationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateTelemetryRuleForOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateTelemetryRuleForOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTelemetryRuleForOrganizationRequest, CreateTelemetryRuleForOrganizationResponse>()
                            .withOperationName("CreateTelemetryRuleForOrganization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTelemetryRuleForOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTelemetryRuleForOrganizationRequest));
            CompletableFuture<CreateTelemetryRuleForOrganizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an organization-wide centralization rule. This operation can only be called by the organization's
     * management account or a delegated administrator account.
     * </p>
     *
     * @param deleteCentralizationRuleForOrganizationRequest
     * @return A Java Future containing the result of the DeleteCentralizationRuleForOrganization operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource (such as a telemetry rule) could not be found.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.DeleteCentralizationRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/DeleteCentralizationRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCentralizationRuleForOrganizationResponse> deleteCentralizationRuleForOrganization(
            DeleteCentralizationRuleForOrganizationRequest deleteCentralizationRuleForOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCentralizationRuleForOrganizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCentralizationRuleForOrganizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCentralizationRuleForOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCentralizationRuleForOrganizationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteCentralizationRuleForOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteCentralizationRuleForOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCentralizationRuleForOrganizationRequest, DeleteCentralizationRuleForOrganizationResponse>()
                            .withOperationName("DeleteCentralizationRuleForOrganization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCentralizationRuleForOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCentralizationRuleForOrganizationRequest));
            CompletableFuture<DeleteCentralizationRuleForOrganizationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an S3 Table integration and its associated data. This operation removes the connection between CloudWatch
     * Observability Admin and S3 Tables.
     * </p>
     *
     * @param deleteS3TableIntegrationRequest
     * @return A Java Future containing the result of the DeleteS3TableIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The requested operation would exceed the allowed quota for the
     *         specified resource type.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>InvalidStateException The requested operation cannot be completed on the specified resource in the
     *         current state.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.DeleteS3TableIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/DeleteS3TableIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteS3TableIntegrationResponse> deleteS3TableIntegration(
            DeleteS3TableIntegrationRequest deleteS3TableIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteS3TableIntegrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteS3TableIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteS3TableIntegration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteS3TableIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteS3TableIntegrationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteS3TableIntegrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteS3TableIntegrationRequest, DeleteS3TableIntegrationResponse>()
                            .withOperationName("DeleteS3TableIntegration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteS3TableIntegrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteS3TableIntegrationRequest));
            CompletableFuture<DeleteS3TableIntegrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a telemetry pipeline and its associated resources. This operation stops data processing and removes the
     * pipeline configuration.
     * </p>
     *
     * @param deleteTelemetryPipelineRequest
     * @return A Java Future containing the result of the DeleteTelemetryPipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource (such as a telemetry rule) could not be found.</li>
     *         <li>ConflictException The requested operation conflicts with the current state of the specified resource
     *         or with another request.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.DeleteTelemetryPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/DeleteTelemetryPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTelemetryPipelineResponse> deleteTelemetryPipeline(
            DeleteTelemetryPipelineRequest deleteTelemetryPipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTelemetryPipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTelemetryPipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTelemetryPipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTelemetryPipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTelemetryPipelineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteTelemetryPipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTelemetryPipelineRequest, DeleteTelemetryPipelineResponse>()
                            .withOperationName("DeleteTelemetryPipeline").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTelemetryPipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTelemetryPipelineRequest));
            CompletableFuture<DeleteTelemetryPipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a telemetry rule from your account. Any telemetry configurations previously created by the rule will
     * remain but no new resources will be configured by this rule.
     * </p>
     *
     * @param deleteTelemetryRuleRequest
     * @return A Java Future containing the result of the DeleteTelemetryRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource (such as a telemetry rule) could not be found.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.DeleteTelemetryRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/DeleteTelemetryRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTelemetryRuleResponse> deleteTelemetryRule(
            DeleteTelemetryRuleRequest deleteTelemetryRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTelemetryRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTelemetryRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTelemetryRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTelemetryRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTelemetryRuleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteTelemetryRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTelemetryRuleRequest, DeleteTelemetryRuleResponse>()
                            .withOperationName("DeleteTelemetryRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTelemetryRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTelemetryRuleRequest));
            CompletableFuture<DeleteTelemetryRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an organization-wide telemetry rule. This operation can only be called by the organization's management
     * account or a delegated administrator account.
     * </p>
     *
     * @param deleteTelemetryRuleForOrganizationRequest
     * @return A Java Future containing the result of the DeleteTelemetryRuleForOrganization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource (such as a telemetry rule) could not be found.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.DeleteTelemetryRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/DeleteTelemetryRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTelemetryRuleForOrganizationResponse> deleteTelemetryRuleForOrganization(
            DeleteTelemetryRuleForOrganizationRequest deleteTelemetryRuleForOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTelemetryRuleForOrganizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTelemetryRuleForOrganizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTelemetryRuleForOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTelemetryRuleForOrganizationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteTelemetryRuleForOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteTelemetryRuleForOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTelemetryRuleForOrganizationRequest, DeleteTelemetryRuleForOrganizationResponse>()
                            .withOperationName("DeleteTelemetryRuleForOrganization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTelemetryRuleForOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTelemetryRuleForOrganizationRequest));
            CompletableFuture<DeleteTelemetryRuleForOrganizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the details of a specific organization centralization rule. This operation can only be called by the
     * organization's management account or a delegated administrator account.
     * </p>
     *
     * @param getCentralizationRuleForOrganizationRequest
     * @return A Java Future containing the result of the GetCentralizationRuleForOrganization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource (such as a telemetry rule) could not be found.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.GetCentralizationRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetCentralizationRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCentralizationRuleForOrganizationResponse> getCentralizationRuleForOrganization(
            GetCentralizationRuleForOrganizationRequest getCentralizationRuleForOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCentralizationRuleForOrganizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCentralizationRuleForOrganizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCentralizationRuleForOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCentralizationRuleForOrganizationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetCentralizationRuleForOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetCentralizationRuleForOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCentralizationRuleForOrganizationRequest, GetCentralizationRuleForOrganizationResponse>()
                            .withOperationName("GetCentralizationRuleForOrganization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCentralizationRuleForOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCentralizationRuleForOrganizationRequest));
            CompletableFuture<GetCentralizationRuleForOrganizationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a specific S3 Table integration, including its configuration, status, and metadata.
     * </p>
     *
     * @param getS3TableIntegrationRequest
     * @return A Java Future containing the result of the GetS3TableIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource (such as a telemetry rule) could not be found.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.GetS3TableIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetS3TableIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetS3TableIntegrationResponse> getS3TableIntegration(
            GetS3TableIntegrationRequest getS3TableIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getS3TableIntegrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getS3TableIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetS3TableIntegration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetS3TableIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetS3TableIntegrationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetS3TableIntegrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetS3TableIntegrationRequest, GetS3TableIntegrationResponse>()
                            .withOperationName("GetS3TableIntegration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetS3TableIntegrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getS3TableIntegrationRequest));
            CompletableFuture<GetS3TableIntegrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the current status of the resource tags for telemetry feature, which enhances telemetry data with
     * additional resource metadata from Resource Explorer.
     * </p>
     *
     * @param getTelemetryEnrichmentStatusRequest
     * @return A Java Future containing the result of the GetTelemetryEnrichmentStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource (such as a telemetry rule) could not be found.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.GetTelemetryEnrichmentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetTelemetryEnrichmentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTelemetryEnrichmentStatusResponse> getTelemetryEnrichmentStatus(
            GetTelemetryEnrichmentStatusRequest getTelemetryEnrichmentStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTelemetryEnrichmentStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTelemetryEnrichmentStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTelemetryEnrichmentStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTelemetryEnrichmentStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetTelemetryEnrichmentStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetTelemetryEnrichmentStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTelemetryEnrichmentStatusRequest, GetTelemetryEnrichmentStatusResponse>()
                            .withOperationName("GetTelemetryEnrichmentStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTelemetryEnrichmentStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTelemetryEnrichmentStatusRequest));
            CompletableFuture<GetTelemetryEnrichmentStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the current onboarding status of the telemetry config feature, including the status of the feature and
     * reason the feature failed to start or stop.
     * </p>
     *
     * @param getTelemetryEvaluationStatusRequest
     * @return A Java Future containing the result of the GetTelemetryEvaluationStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.GetTelemetryEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetTelemetryEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTelemetryEvaluationStatusResponse> getTelemetryEvaluationStatus(
            GetTelemetryEvaluationStatusRequest getTelemetryEvaluationStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTelemetryEvaluationStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTelemetryEvaluationStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTelemetryEvaluationStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTelemetryEvaluationStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetTelemetryEvaluationStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetTelemetryEvaluationStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTelemetryEvaluationStatusRequest, GetTelemetryEvaluationStatusResponse>()
                            .withOperationName("GetTelemetryEvaluationStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTelemetryEvaluationStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTelemetryEvaluationStatusRequest));
            CompletableFuture<GetTelemetryEvaluationStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This returns the onboarding status of the telemetry configuration feature for the organization. It can only be
     * called by a Management Account of an Amazon Web Services Organization or an assigned Delegated Admin Account of
     * Amazon CloudWatch telemetry config.
     * </p>
     *
     * @param getTelemetryEvaluationStatusForOrganizationRequest
     * @return A Java Future containing the result of the GetTelemetryEvaluationStatusForOrganization operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.GetTelemetryEvaluationStatusForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetTelemetryEvaluationStatusForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTelemetryEvaluationStatusForOrganizationResponse> getTelemetryEvaluationStatusForOrganization(
            GetTelemetryEvaluationStatusForOrganizationRequest getTelemetryEvaluationStatusForOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                getTelemetryEvaluationStatusForOrganizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getTelemetryEvaluationStatusForOrganizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTelemetryEvaluationStatusForOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTelemetryEvaluationStatusForOrganizationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetTelemetryEvaluationStatusForOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetTelemetryEvaluationStatusForOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTelemetryEvaluationStatusForOrganizationRequest, GetTelemetryEvaluationStatusForOrganizationResponse>()
                            .withOperationName("GetTelemetryEvaluationStatusForOrganization")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTelemetryEvaluationStatusForOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTelemetryEvaluationStatusForOrganizationRequest));
            CompletableFuture<GetTelemetryEvaluationStatusForOrganizationResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a specific telemetry pipeline, including its configuration, status, and metadata.
     * </p>
     *
     * @param getTelemetryPipelineRequest
     * @return A Java Future containing the result of the GetTelemetryPipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource (such as a telemetry rule) could not be found.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.GetTelemetryPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetTelemetryPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTelemetryPipelineResponse> getTelemetryPipeline(
            GetTelemetryPipelineRequest getTelemetryPipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTelemetryPipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTelemetryPipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTelemetryPipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTelemetryPipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetTelemetryPipelineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetTelemetryPipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTelemetryPipelineRequest, GetTelemetryPipelineResponse>()
                            .withOperationName("GetTelemetryPipeline").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTelemetryPipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTelemetryPipelineRequest));
            CompletableFuture<GetTelemetryPipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the details of a specific telemetry rule in your account.
     * </p>
     *
     * @param getTelemetryRuleRequest
     * @return A Java Future containing the result of the GetTelemetryRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource (such as a telemetry rule) could not be found.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.GetTelemetryRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetTelemetryRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTelemetryRuleResponse> getTelemetryRule(GetTelemetryRuleRequest getTelemetryRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTelemetryRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTelemetryRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTelemetryRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTelemetryRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetTelemetryRuleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetTelemetryRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTelemetryRuleRequest, GetTelemetryRuleResponse>()
                            .withOperationName("GetTelemetryRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTelemetryRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTelemetryRuleRequest));
            CompletableFuture<GetTelemetryRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the details of a specific organization telemetry rule. This operation can only be called by the
     * organization's management account or a delegated administrator account.
     * </p>
     *
     * @param getTelemetryRuleForOrganizationRequest
     * @return A Java Future containing the result of the GetTelemetryRuleForOrganization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource (such as a telemetry rule) could not be found.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.GetTelemetryRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetTelemetryRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTelemetryRuleForOrganizationResponse> getTelemetryRuleForOrganization(
            GetTelemetryRuleForOrganizationRequest getTelemetryRuleForOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTelemetryRuleForOrganizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getTelemetryRuleForOrganizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTelemetryRuleForOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTelemetryRuleForOrganizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetTelemetryRuleForOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetTelemetryRuleForOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTelemetryRuleForOrganizationRequest, GetTelemetryRuleForOrganizationResponse>()
                            .withOperationName("GetTelemetryRuleForOrganization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTelemetryRuleForOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTelemetryRuleForOrganizationRequest));
            CompletableFuture<GetTelemetryRuleForOrganizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all centralization rules in your organization. This operation can only be called by the organization's
     * management account or a delegated administrator account.
     * </p>
     *
     * @param listCentralizationRulesForOrganizationRequest
     * @return A Java Future containing the result of the ListCentralizationRulesForOrganization operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.ListCentralizationRulesForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListCentralizationRulesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCentralizationRulesForOrganizationResponse> listCentralizationRulesForOrganization(
            ListCentralizationRulesForOrganizationRequest listCentralizationRulesForOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCentralizationRulesForOrganizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCentralizationRulesForOrganizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCentralizationRulesForOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCentralizationRulesForOrganizationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListCentralizationRulesForOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListCentralizationRulesForOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCentralizationRulesForOrganizationRequest, ListCentralizationRulesForOrganizationResponse>()
                            .withOperationName("ListCentralizationRulesForOrganization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCentralizationRulesForOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCentralizationRulesForOrganizationRequest));
            CompletableFuture<ListCentralizationRulesForOrganizationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of telemetry configurations for Amazon Web Services resources supported by telemetry config. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/telemetry-config-cloudwatch.html">Auditing
     * CloudWatch telemetry configurations</a>.
     * </p>
     *
     * @param listResourceTelemetryRequest
     * @return A Java Future containing the result of the ListResourceTelemetry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.ListResourceTelemetry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListResourceTelemetry"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceTelemetryResponse> listResourceTelemetry(
            ListResourceTelemetryRequest listResourceTelemetryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResourceTelemetryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourceTelemetryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceTelemetry");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceTelemetryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResourceTelemetryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListResourceTelemetryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourceTelemetryRequest, ListResourceTelemetryResponse>()
                            .withOperationName("ListResourceTelemetry").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListResourceTelemetryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResourceTelemetryRequest));
            CompletableFuture<ListResourceTelemetryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of telemetry configurations for Amazon Web Services resources supported by telemetry config in the
     * organization.
     * </p>
     *
     * @param listResourceTelemetryForOrganizationRequest
     * @return A Java Future containing the result of the ListResourceTelemetryForOrganization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.ListResourceTelemetryForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListResourceTelemetryForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceTelemetryForOrganizationResponse> listResourceTelemetryForOrganization(
            ListResourceTelemetryForOrganizationRequest listResourceTelemetryForOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResourceTelemetryForOrganizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listResourceTelemetryForOrganizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceTelemetryForOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceTelemetryForOrganizationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListResourceTelemetryForOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListResourceTelemetryForOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourceTelemetryForOrganizationRequest, ListResourceTelemetryForOrganizationResponse>()
                            .withOperationName("ListResourceTelemetryForOrganization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListResourceTelemetryForOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResourceTelemetryForOrganizationRequest));
            CompletableFuture<ListResourceTelemetryForOrganizationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all S3 Table integrations in your account. We recommend using pagination to ensure that the operation
     * returns quickly and successfully.
     * </p>
     *
     * @param listS3TableIntegrationsRequest
     * @return A Java Future containing the result of the ListS3TableIntegrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.ListS3TableIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListS3TableIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListS3TableIntegrationsResponse> listS3TableIntegrations(
            ListS3TableIntegrationsRequest listS3TableIntegrationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listS3TableIntegrationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listS3TableIntegrationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListS3TableIntegrations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListS3TableIntegrationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListS3TableIntegrationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListS3TableIntegrationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListS3TableIntegrationsRequest, ListS3TableIntegrationsResponse>()
                            .withOperationName("ListS3TableIntegrations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListS3TableIntegrationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listS3TableIntegrationsRequest));
            CompletableFuture<ListS3TableIntegrationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all tags attached to the specified resource. Supports telemetry rule resources and telemetry pipeline
     * resources.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource (such as a telemetry rule) could not be found.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of telemetry pipelines in your account. Returns up to 100 results. If more than 100 telemetry
     * pipelines exist, include the <code>NextToken</code> value from the response to retrieve the next set of results.
     * </p>
     *
     * @param listTelemetryPipelinesRequest
     * @return A Java Future containing the result of the ListTelemetryPipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.ListTelemetryPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListTelemetryPipelines"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTelemetryPipelinesResponse> listTelemetryPipelines(
            ListTelemetryPipelinesRequest listTelemetryPipelinesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTelemetryPipelinesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTelemetryPipelinesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTelemetryPipelines");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTelemetryPipelinesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTelemetryPipelinesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListTelemetryPipelinesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTelemetryPipelinesRequest, ListTelemetryPipelinesResponse>()
                            .withOperationName("ListTelemetryPipelines").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTelemetryPipelinesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTelemetryPipelinesRequest));
            CompletableFuture<ListTelemetryPipelinesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all telemetry rules in your account. You can filter the results by specifying a rule name prefix.
     * </p>
     *
     * @param listTelemetryRulesRequest
     * @return A Java Future containing the result of the ListTelemetryRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.ListTelemetryRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListTelemetryRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTelemetryRulesResponse> listTelemetryRules(ListTelemetryRulesRequest listTelemetryRulesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTelemetryRulesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTelemetryRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTelemetryRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTelemetryRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTelemetryRulesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListTelemetryRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTelemetryRulesRequest, ListTelemetryRulesResponse>()
                            .withOperationName("ListTelemetryRules").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTelemetryRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTelemetryRulesRequest));
            CompletableFuture<ListTelemetryRulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all telemetry rules in your organization. This operation can only be called by the organization's
     * management account or a delegated administrator account.
     * </p>
     *
     * @param listTelemetryRulesForOrganizationRequest
     * @return A Java Future containing the result of the ListTelemetryRulesForOrganization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.ListTelemetryRulesForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListTelemetryRulesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTelemetryRulesForOrganizationResponse> listTelemetryRulesForOrganization(
            ListTelemetryRulesForOrganizationRequest listTelemetryRulesForOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTelemetryRulesForOrganizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listTelemetryRulesForOrganizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTelemetryRulesForOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTelemetryRulesForOrganizationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListTelemetryRulesForOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListTelemetryRulesForOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTelemetryRulesForOrganizationRequest, ListTelemetryRulesForOrganizationResponse>()
                            .withOperationName("ListTelemetryRulesForOrganization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTelemetryRulesForOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTelemetryRulesForOrganizationRequest));
            CompletableFuture<ListTelemetryRulesForOrganizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the resource tags for telemetry feature for your account, which enhances telemetry data with additional
     * resource metadata from Resource Explorer to provide richer context for monitoring and observability.
     * </p>
     *
     * @param startTelemetryEnrichmentRequest
     * @return A Java Future containing the result of the StartTelemetryEnrichment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The requested operation conflicts with the current state of the specified resource
     *         or with another request.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.StartTelemetryEnrichment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/StartTelemetryEnrichment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartTelemetryEnrichmentResponse> startTelemetryEnrichment(
            StartTelemetryEnrichmentRequest startTelemetryEnrichmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startTelemetryEnrichmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startTelemetryEnrichmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartTelemetryEnrichment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartTelemetryEnrichmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartTelemetryEnrichmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartTelemetryEnrichmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartTelemetryEnrichmentRequest, StartTelemetryEnrichmentResponse>()
                            .withOperationName("StartTelemetryEnrichment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartTelemetryEnrichmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startTelemetryEnrichmentRequest));
            CompletableFuture<StartTelemetryEnrichmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This action begins onboarding the caller Amazon Web Services account to the telemetry config feature.
     * </p>
     *
     * @param startTelemetryEvaluationRequest
     * @return A Java Future containing the result of the StartTelemetryEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.StartTelemetryEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/StartTelemetryEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartTelemetryEvaluationResponse> startTelemetryEvaluation(
            StartTelemetryEvaluationRequest startTelemetryEvaluationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startTelemetryEvaluationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startTelemetryEvaluationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartTelemetryEvaluation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartTelemetryEvaluationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartTelemetryEvaluationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartTelemetryEvaluationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartTelemetryEvaluationRequest, StartTelemetryEvaluationResponse>()
                            .withOperationName("StartTelemetryEvaluation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartTelemetryEvaluationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startTelemetryEvaluationRequest));
            CompletableFuture<StartTelemetryEvaluationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This actions begins onboarding the organization and all member accounts to the telemetry config feature.
     * </p>
     *
     * @param startTelemetryEvaluationForOrganizationRequest
     * @return A Java Future containing the result of the StartTelemetryEvaluationForOrganization operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.StartTelemetryEvaluationForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/StartTelemetryEvaluationForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartTelemetryEvaluationForOrganizationResponse> startTelemetryEvaluationForOrganization(
            StartTelemetryEvaluationForOrganizationRequest startTelemetryEvaluationForOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startTelemetryEvaluationForOrganizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startTelemetryEvaluationForOrganizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartTelemetryEvaluationForOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartTelemetryEvaluationForOrganizationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StartTelemetryEvaluationForOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartTelemetryEvaluationForOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartTelemetryEvaluationForOrganizationRequest, StartTelemetryEvaluationForOrganizationResponse>()
                            .withOperationName("StartTelemetryEvaluationForOrganization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartTelemetryEvaluationForOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startTelemetryEvaluationForOrganizationRequest));
            CompletableFuture<StartTelemetryEvaluationForOrganizationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the resource tags for telemetry feature for your account, stopping the enhancement of telemetry data
     * with additional resource metadata.
     * </p>
     *
     * @param stopTelemetryEnrichmentRequest
     * @return A Java Future containing the result of the StopTelemetryEnrichment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The requested operation conflicts with the current state of the specified resource
     *         or with another request.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.StopTelemetryEnrichment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/StopTelemetryEnrichment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopTelemetryEnrichmentResponse> stopTelemetryEnrichment(
            StopTelemetryEnrichmentRequest stopTelemetryEnrichmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopTelemetryEnrichmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopTelemetryEnrichmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopTelemetryEnrichment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopTelemetryEnrichmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopTelemetryEnrichmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopTelemetryEnrichmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopTelemetryEnrichmentRequest, StopTelemetryEnrichmentResponse>()
                            .withOperationName("StopTelemetryEnrichment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopTelemetryEnrichmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopTelemetryEnrichmentRequest));
            CompletableFuture<StopTelemetryEnrichmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This action begins offboarding the caller Amazon Web Services account from the telemetry config feature.
     * </p>
     *
     * @param stopTelemetryEvaluationRequest
     * @return A Java Future containing the result of the StopTelemetryEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.StopTelemetryEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/StopTelemetryEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopTelemetryEvaluationResponse> stopTelemetryEvaluation(
            StopTelemetryEvaluationRequest stopTelemetryEvaluationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopTelemetryEvaluationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopTelemetryEvaluationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopTelemetryEvaluation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopTelemetryEvaluationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopTelemetryEvaluationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopTelemetryEvaluationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopTelemetryEvaluationRequest, StopTelemetryEvaluationResponse>()
                            .withOperationName("StopTelemetryEvaluation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopTelemetryEvaluationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopTelemetryEvaluationRequest));
            CompletableFuture<StopTelemetryEvaluationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This action offboards the Organization of the caller Amazon Web Services account from the telemetry config
     * feature.
     * </p>
     *
     * @param stopTelemetryEvaluationForOrganizationRequest
     * @return A Java Future containing the result of the StopTelemetryEvaluationForOrganization operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.StopTelemetryEvaluationForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/StopTelemetryEvaluationForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopTelemetryEvaluationForOrganizationResponse> stopTelemetryEvaluationForOrganization(
            StopTelemetryEvaluationForOrganizationRequest stopTelemetryEvaluationForOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopTelemetryEvaluationForOrganizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                stopTelemetryEvaluationForOrganizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopTelemetryEvaluationForOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopTelemetryEvaluationForOrganizationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StopTelemetryEvaluationForOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopTelemetryEvaluationForOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopTelemetryEvaluationForOrganizationRequest, StopTelemetryEvaluationForOrganizationResponse>()
                            .withOperationName("StopTelemetryEvaluationForOrganization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopTelemetryEvaluationForOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopTelemetryEvaluationForOrganizationRequest));
            CompletableFuture<StopTelemetryEvaluationForOrganizationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or updates tags for a resource. Supports telemetry rule resources and telemetry pipeline resources.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The requested operation would exceed the allowed quota for the
     *         specified resource type.</li>
     *         <li>ResourceNotFoundException The specified resource (such as a telemetry rule) could not be found.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Tests a pipeline configuration with sample records to validate data processing before deployment. This operation
     * helps ensure your pipeline configuration works as expected.
     * </p>
     *
     * @param testTelemetryPipelineRequest
     * @return A Java Future containing the result of the TestTelemetryPipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.TestTelemetryPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/TestTelemetryPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<TestTelemetryPipelineResponse> testTelemetryPipeline(
            TestTelemetryPipelineRequest testTelemetryPipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(testTelemetryPipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testTelemetryPipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestTelemetryPipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TestTelemetryPipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TestTelemetryPipelineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<TestTelemetryPipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TestTelemetryPipelineRequest, TestTelemetryPipelineResponse>()
                            .withOperationName("TestTelemetryPipeline").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TestTelemetryPipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(testTelemetryPipelineRequest));
            CompletableFuture<TestTelemetryPipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes tags from a resource. Supports telemetry rule resources and telemetry pipeline resources.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource (such as a telemetry rule) could not be found.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing centralization rule that applies across an Amazon Web Services Organization. This operation
     * can only be called by the organization's management account or a delegated administrator account.
     * </p>
     *
     * @param updateCentralizationRuleForOrganizationRequest
     * @return A Java Future containing the result of the UpdateCentralizationRuleForOrganization operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The requested operation would exceed the allowed quota for the
     *         specified resource type.</li>
     *         <li>ResourceNotFoundException The specified resource (such as a telemetry rule) could not be found.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.UpdateCentralizationRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/UpdateCentralizationRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCentralizationRuleForOrganizationResponse> updateCentralizationRuleForOrganization(
            UpdateCentralizationRuleForOrganizationRequest updateCentralizationRuleForOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCentralizationRuleForOrganizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCentralizationRuleForOrganizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCentralizationRuleForOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCentralizationRuleForOrganizationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateCentralizationRuleForOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateCentralizationRuleForOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCentralizationRuleForOrganizationRequest, UpdateCentralizationRuleForOrganizationResponse>()
                            .withOperationName("UpdateCentralizationRuleForOrganization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCentralizationRuleForOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCentralizationRuleForOrganizationRequest));
            CompletableFuture<UpdateCentralizationRuleForOrganizationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing telemetry pipeline.
     * </p>
     * <note>
     * <p>
     * The following attributes cannot be updated after pipeline creation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Pipeline name</b> - The pipeline name is immutable
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Pipeline ARN</b> - The ARN is automatically generated and cannot be changed
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Source type</b> - Once a pipeline is created with a specific source type (such as S3, CloudWatch Logs, GitHub,
     * or third-party sources), it cannot be changed to a different source type
     * </p>
     * </li>
     * </ul>
     * <p>
     * Processors can be added, removed, or modified. However, some processors are not supported for third-party
     * pipelines and cannot be added through updates.
     * </p>
     * </note>
     * <p>
     * <b>Source-Specific Update Rules</b>
     * </p>
     * <dl>
     * <dt>CloudWatch Logs Sources (Vended and Custom)</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> <code>sts_role_arn</code>
     * </p>
     * <p>
     * <b>Fixed:</b> <code>data_source_name</code>, <code>data_source_type</code>, sink (must remain
     * <code>@original</code>)
     * </p>
     * </dd>
     * <dt>S3 Sources (Crowdstrike, Zscaler, SentinelOne, Custom)</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All SQS configuration parameters, <code>sts_role_arn</code>, codec settings, compression type,
     * bucket ownership settings, sink log group
     * </p>
     * <p>
     * <b>Fixed:</b> <code>notification_type</code>, <code>aws.region</code>
     * </p>
     * </dd>
     * <dt>GitHub Audit Logs</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All Amazon Web Services Secrets Manager attributes, <code>scope</code> (can switch between
     * ORGANIZATION/ENTERPRISE), <code>organization</code> or <code>enterprise</code> name, <code>range</code>,
     * authentication credentials (PAT or GitHub App)
     * </p>
     * </dd>
     * <dt>Microsoft Sources (Entra ID, Office365, Windows)</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All Amazon Web Services Secrets Manager attributes, <code>tenant_id</code>,
     * <code>workspace_id</code> (Windows only), OAuth2 credentials (<code>client_id</code>, <code>client_secret</code>)
     * </p>
     * </dd>
     * <dt>Okta Sources (SSO, Auth0)</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All Amazon Web Services Secrets Manager attributes, <code>domain</code>, <code>range</code>
     * (SSO only), OAuth2 credentials (<code>client_id</code>, <code>client_secret</code>)
     * </p>
     * </dd>
     * <dt>Palo Alto Networks</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All Amazon Web Services Secrets Manager attributes, <code>hostname</code>, basic authentication
     * credentials (<code>username</code>, <code>password</code>)
     * </p>
     * </dd>
     * <dt>ServiceNow CMDB</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All Amazon Web Services Secrets Manager attributes, <code>instance_url</code>,
     * <code>range</code>, OAuth2 credentials (<code>client_id</code>, <code>client_secret</code>)
     * </p>
     * </dd>
     * <dt>Wiz CNAPP</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All Amazon Web Services Secrets Manager attributes, <code>region</code>, <code>range</code>,
     * OAuth2 credentials (<code>client_id</code>, <code>client_secret</code>)
     * </p>
     * </dd>
     * </dl>
     *
     * @param updateTelemetryPipelineRequest
     * @return A Java Future containing the result of the UpdateTelemetryPipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource (such as a telemetry rule) could not be found.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.UpdateTelemetryPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/UpdateTelemetryPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTelemetryPipelineResponse> updateTelemetryPipeline(
            UpdateTelemetryPipelineRequest updateTelemetryPipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateTelemetryPipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTelemetryPipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTelemetryPipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateTelemetryPipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateTelemetryPipelineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateTelemetryPipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateTelemetryPipelineRequest, UpdateTelemetryPipelineResponse>()
                            .withOperationName("UpdateTelemetryPipeline").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateTelemetryPipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateTelemetryPipelineRequest));
            CompletableFuture<UpdateTelemetryPipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing telemetry rule in your account. If multiple users attempt to modify the same telemetry rule
     * simultaneously, a ConflictException is returned to provide specific error information for concurrent modification
     * scenarios.
     * </p>
     *
     * @param updateTelemetryRuleRequest
     * @return A Java Future containing the result of the UpdateTelemetryRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The requested operation would exceed the allowed quota for the
     *         specified resource type.</li>
     *         <li>ResourceNotFoundException The specified resource (such as a telemetry rule) could not be found.</li>
     *         <li>ConflictException The requested operation conflicts with the current state of the specified resource
     *         or with another request.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.UpdateTelemetryRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/UpdateTelemetryRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTelemetryRuleResponse> updateTelemetryRule(
            UpdateTelemetryRuleRequest updateTelemetryRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateTelemetryRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTelemetryRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTelemetryRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateTelemetryRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateTelemetryRuleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateTelemetryRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateTelemetryRuleRequest, UpdateTelemetryRuleResponse>()
                            .withOperationName("UpdateTelemetryRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateTelemetryRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateTelemetryRuleRequest));
            CompletableFuture<UpdateTelemetryRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing telemetry rule that applies across an Amazon Web Services Organization. This operation can
     * only be called by the organization's management account or a delegated administrator account.
     * </p>
     *
     * @param updateTelemetryRuleForOrganizationRequest
     * @return A Java Future containing the result of the UpdateTelemetryRuleForOrganization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The requested operation would exceed the allowed quota for the
     *         specified resource type.</li>
     *         <li>ResourceNotFoundException The specified resource (such as a telemetry rule) could not be found.</li>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.UpdateTelemetryRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/UpdateTelemetryRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTelemetryRuleForOrganizationResponse> updateTelemetryRuleForOrganization(
            UpdateTelemetryRuleForOrganizationRequest updateTelemetryRuleForOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateTelemetryRuleForOrganizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateTelemetryRuleForOrganizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTelemetryRuleForOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateTelemetryRuleForOrganizationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateTelemetryRuleForOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateTelemetryRuleForOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateTelemetryRuleForOrganizationRequest, UpdateTelemetryRuleForOrganizationResponse>()
                            .withOperationName("UpdateTelemetryRuleForOrganization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateTelemetryRuleForOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateTelemetryRuleForOrganizationRequest));
            CompletableFuture<UpdateTelemetryRuleForOrganizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Validates a pipeline configuration without creating the pipeline. This operation checks the configuration for
     * syntax errors and compatibility issues.
     * </p>
     *
     * @param validateTelemetryPipelineConfigurationRequest
     * @return A Java Future containing the result of the ValidateTelemetryPipelineConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Indicates you don't have permissions to perform the requested operation. The
     *         user or role that is making the request must have at least one IAM permissions policy attached that
     *         grants the required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management for Amazon Web
     *         Services resources</a> in the IAM user guide.</li>
     *         <li>InternalServerException Indicates the request has failed to process because of an unknown server
     *         error, exception, or failure.</li>
     *         <li>ValidationException Indicates input validation failed. Check your request parameters and retry the
     *         request.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ObservabilityAdminException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ObservabilityAdminAsyncClient.ValidateTelemetryPipelineConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ValidateTelemetryPipelineConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ValidateTelemetryPipelineConfigurationResponse> validateTelemetryPipelineConfiguration(
            ValidateTelemetryPipelineConfigurationRequest validateTelemetryPipelineConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(validateTelemetryPipelineConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                validateTelemetryPipelineConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ObservabilityAdmin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ValidateTelemetryPipelineConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ValidateTelemetryPipelineConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ValidateTelemetryPipelineConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidStateException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ValidateTelemetryPipelineConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ValidateTelemetryPipelineConfigurationRequest, ValidateTelemetryPipelineConfigurationResponse>()
                            .withOperationName("ValidateTelemetryPipelineConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ValidateTelemetryPipelineConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(validateTelemetryPipelineConfigurationRequest));
            CompletableFuture<ValidateTelemetryPipelineConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final ObservabilityAdminServiceClientConfiguration serviceClientConfiguration() {
        return new ObservabilityAdminServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ObservabilityAdminException::builder).protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        ObservabilityAdminServiceClientConfigurationBuilder serviceConfigBuilder = new ObservabilityAdminServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
