/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RuleHealth {
    HEALTHY("Healthy"),
    UNHEALTHY("Unhealthy"),
    PROVISIONING("Provisioning"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RuleHealth> VALUE_MAP;
    private final String value;

    private RuleHealth(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RuleHealth fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RuleHealth> knownValues() {
        EnumSet<RuleHealth> knownValues = EnumSet.allOf(RuleHealth.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RuleHealth.class, RuleHealth::toString);
    }
}

