/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.oam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.oam.OamAsyncClient;
import software.amazon.awssdk.services.oam.internal.UserAgentUtils;
import software.amazon.awssdk.services.oam.model.ListSinksItem;
import software.amazon.awssdk.services.oam.model.ListSinksRequest;
import software.amazon.awssdk.services.oam.model.ListSinksResponse;

public class ListSinksPublisher
implements SdkPublisher<ListSinksResponse> {
    private final OamAsyncClient client;
    private final ListSinksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSinksPublisher(OamAsyncClient client, ListSinksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSinksPublisher(OamAsyncClient client, ListSinksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSinksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSinksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListSinksItem> items() {
        Function<ListSinksResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSinksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSinksResponseFetcher
    implements AsyncPageFetcher<ListSinksResponse> {
        private ListSinksResponseFetcher() {
        }

        public boolean hasNextPage(ListSinksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSinksResponse> nextPage(ListSinksResponse previousPage) {
            if (previousPage == null) {
                return ListSinksPublisher.this.client.listSinks(ListSinksPublisher.this.firstRequest);
            }
            return ListSinksPublisher.this.client.listSinks((ListSinksRequest)((Object)ListSinksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

