/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.oam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.oam.model.LinkConfiguration;
import software.amazon.awssdk.services.oam.model.OamRequest;
import software.amazon.awssdk.services.oam.model.ResourceType;
import software.amazon.awssdk.services.oam.model.ResourceTypesInputCopier;
import software.amazon.awssdk.services.oam.model.TagMapInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLinkRequest
extends OamRequest
implements ToCopyableBuilder<Builder, CreateLinkRequest> {
    private static final SdkField<String> LABEL_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelTemplate").getter(CreateLinkRequest.getter(CreateLinkRequest::labelTemplate)).setter(CreateLinkRequest.setter(Builder::labelTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelTemplate").build()}).build();
    private static final SdkField<LinkConfiguration> LINK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LinkConfiguration").getter(CreateLinkRequest.getter(CreateLinkRequest::linkConfiguration)).setter(CreateLinkRequest.setter(Builder::linkConfiguration)).constructor(LinkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkConfiguration").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypes").getter(CreateLinkRequest.getter(CreateLinkRequest::resourceTypesAsStrings)).setter(CreateLinkRequest.setter(Builder::resourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SINK_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SinkIdentifier").getter(CreateLinkRequest.getter(CreateLinkRequest::sinkIdentifier)).setter(CreateLinkRequest.setter(Builder::sinkIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkIdentifier").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateLinkRequest.getter(CreateLinkRequest::tags)).setter(CreateLinkRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_TEMPLATE_FIELD, LINK_CONFIGURATION_FIELD, RESOURCE_TYPES_FIELD, SINK_IDENTIFIER_FIELD, TAGS_FIELD));
    private final String labelTemplate;
    private final LinkConfiguration linkConfiguration;
    private final List<String> resourceTypes;
    private final String sinkIdentifier;
    private final Map<String, String> tags;

    private CreateLinkRequest(BuilderImpl builder) {
        super(builder);
        this.labelTemplate = builder.labelTemplate;
        this.linkConfiguration = builder.linkConfiguration;
        this.resourceTypes = builder.resourceTypes;
        this.sinkIdentifier = builder.sinkIdentifier;
        this.tags = builder.tags;
    }

    public final String labelTemplate() {
        return this.labelTemplate;
    }

    public final LinkConfiguration linkConfiguration() {
        return this.linkConfiguration;
    }

    public final List<ResourceType> resourceTypes() {
        return ResourceTypesInputCopier.copyStringToEnum(this.resourceTypes);
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypesAsStrings() {
        return this.resourceTypes;
    }

    public final String sinkIdentifier() {
        return this.sinkIdentifier;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.labelTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sinkIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLinkRequest)) {
            return false;
        }
        CreateLinkRequest other = (CreateLinkRequest)((Object)obj);
        return Objects.equals(this.labelTemplate(), other.labelTemplate()) && Objects.equals(this.linkConfiguration(), other.linkConfiguration()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypesAsStrings(), other.resourceTypesAsStrings()) && Objects.equals(this.sinkIdentifier(), other.sinkIdentifier()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLinkRequest").add("LabelTemplate", (Object)this.labelTemplate()).add("LinkConfiguration", (Object)this.linkConfiguration()).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypesAsStrings() : null).add("SinkIdentifier", (Object)this.sinkIdentifier()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LabelTemplate": {
                return Optional.ofNullable(clazz.cast(this.labelTemplate()));
            }
            case "LinkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.linkConfiguration()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypesAsStrings()));
            }
            case "SinkIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sinkIdentifier()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLinkRequest, T> g) {
        return obj -> g.apply((CreateLinkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OamRequest.BuilderImpl
    implements Builder {
        private String labelTemplate;
        private LinkConfiguration linkConfiguration;
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private String sinkIdentifier;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLinkRequest model) {
            super(model);
            this.labelTemplate(model.labelTemplate);
            this.linkConfiguration(model.linkConfiguration);
            this.resourceTypesWithStrings(model.resourceTypes);
            this.sinkIdentifier(model.sinkIdentifier);
            this.tags(model.tags);
        }

        public final String getLabelTemplate() {
            return this.labelTemplate;
        }

        public final void setLabelTemplate(String labelTemplate) {
            this.labelTemplate = labelTemplate;
        }

        @Override
        public final Builder labelTemplate(String labelTemplate) {
            this.labelTemplate = labelTemplate;
            return this;
        }

        public final LinkConfiguration.Builder getLinkConfiguration() {
            return this.linkConfiguration != null ? this.linkConfiguration.toBuilder() : null;
        }

        public final void setLinkConfiguration(LinkConfiguration.BuilderImpl linkConfiguration) {
            this.linkConfiguration = linkConfiguration != null ? linkConfiguration.build() : null;
        }

        @Override
        public final Builder linkConfiguration(LinkConfiguration linkConfiguration) {
            this.linkConfiguration = linkConfiguration;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesInputCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesInputCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String ... resourceTypes) {
            this.resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceType> resourceTypes) {
            this.resourceTypes = ResourceTypesInputCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceType ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final String getSinkIdentifier() {
            return this.sinkIdentifier;
        }

        public final void setSinkIdentifier(String sinkIdentifier) {
            this.sinkIdentifier = sinkIdentifier;
        }

        @Override
        public final Builder sinkIdentifier(String sinkIdentifier) {
            this.sinkIdentifier = sinkIdentifier;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapInputCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapInputCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLinkRequest build() {
            return new CreateLinkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLinkRequest> {
        public Builder labelTemplate(String var1);

        public Builder linkConfiguration(LinkConfiguration var1);

        default public Builder linkConfiguration(Consumer<LinkConfiguration.Builder> linkConfiguration) {
            return this.linkConfiguration((LinkConfiguration)((LinkConfiguration.Builder)LinkConfiguration.builder().applyMutation(linkConfiguration)).build());
        }

        public Builder resourceTypesWithStrings(Collection<String> var1);

        public Builder resourceTypesWithStrings(String ... var1);

        public Builder resourceTypes(Collection<ResourceType> var1);

        public Builder resourceTypes(ResourceType ... var1);

        public Builder sinkIdentifier(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

