/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.oam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.oam.OamClient;
import software.amazon.awssdk.services.oam.model.ListLinksItem;
import software.amazon.awssdk.services.oam.model.ListLinksRequest;
import software.amazon.awssdk.services.oam.model.ListLinksResponse;

public class ListLinksIterable
implements SdkIterable<ListLinksResponse> {
    private final OamClient client;
    private final ListLinksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLinksIterable(OamClient client, ListLinksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLinksResponseFetcher();
    }

    public Iterator<ListLinksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListLinksItem> items() {
        Function<ListLinksResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLinksResponseFetcher
    implements SyncPageFetcher<ListLinksResponse> {
        private ListLinksResponseFetcher() {
        }

        public boolean hasNextPage(ListLinksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLinksResponse nextPage(ListLinksResponse previousPage) {
            if (previousPage == null) {
                return ListLinksIterable.this.client.listLinks(ListLinksIterable.this.firstRequest);
            }
            return ListLinksIterable.this.client.listLinks((ListLinksRequest)((Object)ListLinksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

