/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.oam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.oam.model.ResourceTypesOutputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLinksItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListLinksItem> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ListLinksItem.getter(ListLinksItem::arn)).setter(ListLinksItem.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ListLinksItem.getter(ListLinksItem::id)).setter(ListLinksItem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Label").getter(ListLinksItem.getter(ListLinksItem::label)).setter(ListLinksItem.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypes").getter(ListLinksItem.getter(ListLinksItem::resourceTypes)).setter(ListLinksItem.setter(Builder::resourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SINK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SinkArn").getter(ListLinksItem.getter(ListLinksItem::sinkArn)).setter(ListLinksItem.setter(Builder::sinkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, LABEL_FIELD, RESOURCE_TYPES_FIELD, SINK_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final String label;
    private final List<String> resourceTypes;
    private final String sinkArn;

    private ListLinksItem(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.label = builder.label;
        this.resourceTypes = builder.resourceTypes;
        this.sinkArn = builder.sinkArn;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String label() {
        return this.label;
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public final String sinkArn() {
        return this.sinkArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sinkArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLinksItem)) {
            return false;
        }
        ListLinksItem other = (ListLinksItem)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.label(), other.label()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypes(), other.resourceTypes()) && Objects.equals(this.sinkArn(), other.sinkArn());
    }

    public final String toString() {
        return ToString.builder((String)"ListLinksItem").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Label", (Object)this.label()).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypes() : null).add("SinkArn", (Object)this.sinkArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypes()));
            }
            case "SinkArn": {
                return Optional.ofNullable(clazz.cast(this.sinkArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLinksItem, T> g) {
        return obj -> g.apply((ListLinksItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String label;
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private String sinkArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLinksItem model) {
            this.arn(model.arn);
            this.id(model.id);
            this.label(model.label);
            this.resourceTypes(model.resourceTypes);
            this.sinkArn(model.sinkArn);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesOutputCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesOutputCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final String getSinkArn() {
            return this.sinkArn;
        }

        public final void setSinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
        }

        @Override
        public final Builder sinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
            return this;
        }

        public ListLinksItem build() {
            return new ListLinksItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListLinksItem> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder label(String var1);

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);

        public Builder sinkArn(String var1);
    }
}

