/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Call
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Call> {
    private static final SdkField<String> CALL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("callId").getter(Call.getter(Call::callId)).setter(Call.setter(Builder::callId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("callId").build()}).build();
    private static final SdkField<Document> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("input").getter(Call.getter(Call::input)).setter(Call.setter(Builder::input)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Call.getter(Call::name)).setter(Call.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALL_ID_FIELD, INPUT_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Call.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String callId;
    private final Document input;
    private final String name;

    private Call(BuilderImpl builder) {
        this.callId = builder.callId;
        this.input = builder.input;
        this.name = builder.name;
    }

    public final String callId() {
        return this.callId;
    }

    public final Document input() {
        return this.input;
    }

    public final String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.callId());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Call)) {
            return false;
        }
        Call other = (Call)obj;
        return Objects.equals(this.callId(), other.callId()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"Call").add("CallId", (Object)this.callId()).add("Input", (Object)(this.input() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "callId": {
                return Optional.ofNullable(clazz.cast(this.callId()));
            }
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("callId", CALL_ID_FIELD);
        map.put("input", INPUT_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Call, T> g) {
        return obj -> g.apply((Call)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String callId;
        private Document input;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(Call model) {
            this.callId(model.callId);
            this.input(model.input);
            this.name(model.name);
        }

        public final String getCallId() {
            return this.callId;
        }

        public final void setCallId(String callId) {
            this.callId = callId;
        }

        @Override
        public final Builder callId(String callId) {
            this.callId = callId;
            return this;
        }

        public final Document getInput() {
            return this.input;
        }

        public final void setInput(Document input) {
            this.input = input;
        }

        @Override
        public final Builder input(Document input) {
            this.input = input;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public Call build() {
            return new Call(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Call> {
        public Builder callId(String var1);

        public Builder input(Document var1);

        public Builder name(String var1);
    }
}

