/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.novaact.model.Call;
import software.amazon.awssdk.services.novaact.model.CallsCopier;
import software.amazon.awssdk.services.novaact.model.NovaActResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeActStepResponse
extends NovaActResponse
implements ToCopyableBuilder<Builder, InvokeActStepResponse> {
    private static final SdkField<List<Call>> CALLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("calls").getter(InvokeActStepResponse.getter(InvokeActStepResponse::calls)).setter(InvokeActStepResponse.setter(Builder::calls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("calls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Call::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STEP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepId").getter(InvokeActStepResponse.getter(InvokeActStepResponse::stepId)).setter(InvokeActStepResponse.setter(Builder::stepId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLS_FIELD, STEP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeActStepResponse.memberNameToFieldInitializer();
    private final List<Call> calls;
    private final String stepId;

    private InvokeActStepResponse(BuilderImpl builder) {
        super(builder);
        this.calls = builder.calls;
        this.stepId = builder.stepId;
    }

    public final boolean hasCalls() {
        return this.calls != null && !(this.calls instanceof SdkAutoConstructList);
    }

    public final List<Call> calls() {
        return this.calls;
    }

    public final String stepId() {
        return this.stepId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCalls() ? this.calls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stepId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeActStepResponse)) {
            return false;
        }
        InvokeActStepResponse other = (InvokeActStepResponse)((Object)obj);
        return this.hasCalls() == other.hasCalls() && Objects.equals(this.calls(), other.calls()) && Objects.equals(this.stepId(), other.stepId());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeActStepResponse").add("Calls", this.hasCalls() ? this.calls() : null).add("StepId", (Object)this.stepId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "calls": {
                return Optional.ofNullable(clazz.cast(this.calls()));
            }
            case "stepId": {
                return Optional.ofNullable(clazz.cast(this.stepId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("calls", CALLS_FIELD);
        map.put("stepId", STEP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeActStepResponse, T> g) {
        return obj -> g.apply((InvokeActStepResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NovaActResponse.BuilderImpl
    implements Builder {
        private List<Call> calls = DefaultSdkAutoConstructList.getInstance();
        private String stepId;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeActStepResponse model) {
            super(model);
            this.calls(model.calls);
            this.stepId(model.stepId);
        }

        public final List<Call.Builder> getCalls() {
            List<Call.Builder> result = CallsCopier.copyToBuilder(this.calls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCalls(Collection<Call.BuilderImpl> calls) {
            this.calls = CallsCopier.copyFromBuilder(calls);
        }

        @Override
        public final Builder calls(Collection<Call> calls) {
            this.calls = CallsCopier.copy(calls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calls(Call ... calls) {
            this.calls(Arrays.asList(calls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calls(Consumer<Call.Builder> ... calls) {
            this.calls(Stream.of(calls).map(c -> (Call)((Call.Builder)Call.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStepId() {
            return this.stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        @Override
        public InvokeActStepResponse build() {
            return new InvokeActStepResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NovaActResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeActStepResponse> {
        public Builder calls(Collection<Call> var1);

        public Builder calls(Call ... var1);

        public Builder calls(Consumer<Call.Builder> ... var1);

        public Builder stepId(String var1);
    }
}

