/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notificationscontacts;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.notificationscontacts.model.AccessDeniedException;
import software.amazon.awssdk.services.notificationscontacts.model.ActivateEmailContactRequest;
import software.amazon.awssdk.services.notificationscontacts.model.ActivateEmailContactResponse;
import software.amazon.awssdk.services.notificationscontacts.model.ConflictException;
import software.amazon.awssdk.services.notificationscontacts.model.CreateEmailContactRequest;
import software.amazon.awssdk.services.notificationscontacts.model.CreateEmailContactResponse;
import software.amazon.awssdk.services.notificationscontacts.model.DeleteEmailContactRequest;
import software.amazon.awssdk.services.notificationscontacts.model.DeleteEmailContactResponse;
import software.amazon.awssdk.services.notificationscontacts.model.GetEmailContactRequest;
import software.amazon.awssdk.services.notificationscontacts.model.GetEmailContactResponse;
import software.amazon.awssdk.services.notificationscontacts.model.InternalServerException;
import software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsRequest;
import software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsResponse;
import software.amazon.awssdk.services.notificationscontacts.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.notificationscontacts.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.notificationscontacts.model.NotificationsContactsException;
import software.amazon.awssdk.services.notificationscontacts.model.ResourceNotFoundException;
import software.amazon.awssdk.services.notificationscontacts.model.SendActivationCodeRequest;
import software.amazon.awssdk.services.notificationscontacts.model.SendActivationCodeResponse;
import software.amazon.awssdk.services.notificationscontacts.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.notificationscontacts.model.TagResourceRequest;
import software.amazon.awssdk.services.notificationscontacts.model.TagResourceResponse;
import software.amazon.awssdk.services.notificationscontacts.model.ThrottlingException;
import software.amazon.awssdk.services.notificationscontacts.model.UntagResourceRequest;
import software.amazon.awssdk.services.notificationscontacts.model.UntagResourceResponse;
import software.amazon.awssdk.services.notificationscontacts.model.ValidationException;
import software.amazon.awssdk.services.notificationscontacts.paginators.ListEmailContactsIterable;

/**
 * Service client for accessing AWS User Notifications Contacts. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * AWS User Notifications Contacts is a service that allows you to create and manage email contacts for AWS User
 * Notifications. The AWS User Notifications Contacts API Reference provides descriptions, API request parameters, and
 * the JSON response for all email contact related API actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface NotificationsContactsClient extends AwsClient {
    String SERVICE_NAME = "notifications-contacts";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "notifications-contacts";

    /**
     * <p>
     * Activates an email contact using an activation code. This code is in the activation email sent to the email
     * address associated with this email contact.
     * </p>
     *
     * @param activateEmailContactRequest
     * @return Result of the ActivateEmailContact operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ResourceNotFoundException
     *         Your request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.ActivateEmailContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/ActivateEmailContact"
     *      target="_top">AWS API Documentation</a>
     */
    default ActivateEmailContactResponse activateEmailContact(ActivateEmailContactRequest activateEmailContactRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, NotificationsContactsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates an email contact using an activation code. This code is in the activation email sent to the email
     * address associated with this email contact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateEmailContactRequest.Builder} avoiding the
     * need to create one manually via {@link ActivateEmailContactRequest#builder()}
     * </p>
     *
     * @param activateEmailContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.ActivateEmailContactRequest.Builder} to
     *        create a request.
     * @return Result of the ActivateEmailContact operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ResourceNotFoundException
     *         Your request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.ActivateEmailContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/ActivateEmailContact"
     *      target="_top">AWS API Documentation</a>
     */
    default ActivateEmailContactResponse activateEmailContact(
            Consumer<ActivateEmailContactRequest.Builder> activateEmailContactRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, NotificationsContactsException {
        return activateEmailContact(ActivateEmailContactRequest.builder().applyMutation(activateEmailContactRequest).build());
    }

    /**
     * <p>
     * Creates an email contact for the provided email address.
     * </p>
     *
     * @param createEmailContactRequest
     * @return Result of the CreateEmailContact operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.CreateEmailContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/CreateEmailContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEmailContactResponse createEmailContact(CreateEmailContactRequest createEmailContactRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException,
            NotificationsContactsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an email contact for the provided email address.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEmailContactRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEmailContactRequest#builder()}
     * </p>
     *
     * @param createEmailContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.CreateEmailContactRequest.Builder} to
     *        create a request.
     * @return Result of the CreateEmailContact operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.CreateEmailContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/CreateEmailContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEmailContactResponse createEmailContact(Consumer<CreateEmailContactRequest.Builder> createEmailContactRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException,
            NotificationsContactsException {
        return createEmailContact(CreateEmailContactRequest.builder().applyMutation(createEmailContactRequest).build());
    }

    /**
     * <p>
     * Deletes an email contact.
     * </p>
     * <note>
     * <p>
     * Deleting an email contact removes it from all associated notification configurations.
     * </p>
     * </note>
     *
     * @param deleteEmailContactRequest
     * @return Result of the DeleteEmailContact operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ResourceNotFoundException
     *         Your request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.DeleteEmailContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/DeleteEmailContact"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEmailContactResponse deleteEmailContact(DeleteEmailContactRequest deleteEmailContactRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, NotificationsContactsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an email contact.
     * </p>
     * <note>
     * <p>
     * Deleting an email contact removes it from all associated notification configurations.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEmailContactRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEmailContactRequest#builder()}
     * </p>
     *
     * @param deleteEmailContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.DeleteEmailContactRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteEmailContact operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ResourceNotFoundException
     *         Your request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.DeleteEmailContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/DeleteEmailContact"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEmailContactResponse deleteEmailContact(Consumer<DeleteEmailContactRequest.Builder> deleteEmailContactRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, NotificationsContactsException {
        return deleteEmailContact(DeleteEmailContactRequest.builder().applyMutation(deleteEmailContactRequest).build());
    }

    /**
     * <p>
     * Returns an email contact.
     * </p>
     *
     * @param getEmailContactRequest
     * @return Result of the GetEmailContact operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ResourceNotFoundException
     *         Your request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.GetEmailContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/GetEmailContact"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEmailContactResponse getEmailContact(GetEmailContactRequest getEmailContactRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, NotificationsContactsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an email contact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEmailContactRequest.Builder} avoiding the need
     * to create one manually via {@link GetEmailContactRequest#builder()}
     * </p>
     *
     * @param getEmailContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.GetEmailContactRequest.Builder} to
     *        create a request.
     * @return Result of the GetEmailContact operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ResourceNotFoundException
     *         Your request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.GetEmailContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/GetEmailContact"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEmailContactResponse getEmailContact(Consumer<GetEmailContactRequest.Builder> getEmailContactRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, NotificationsContactsException {
        return getEmailContact(GetEmailContactRequest.builder().applyMutation(getEmailContactRequest).build());
    }

    /**
     * <p>
     * Lists all email contacts created under the Account.
     * </p>
     *
     * @param listEmailContactsRequest
     * @return Result of the ListEmailContacts operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.ListEmailContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/ListEmailContacts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEmailContactsResponse listEmailContacts(ListEmailContactsRequest listEmailContactsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, NotificationsContactsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all email contacts created under the Account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEmailContactsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEmailContactsRequest#builder()}
     * </p>
     *
     * @param listEmailContactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsRequest.Builder} to
     *        create a request.
     * @return Result of the ListEmailContacts operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.ListEmailContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/ListEmailContacts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEmailContactsResponse listEmailContacts(Consumer<ListEmailContactsRequest.Builder> listEmailContactsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, NotificationsContactsException {
        return listEmailContacts(ListEmailContactsRequest.builder().applyMutation(listEmailContactsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEmailContacts(software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notificationscontacts.paginators.ListEmailContactsIterable responses = client.listEmailContactsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notificationscontacts.paginators.ListEmailContactsIterable responses = client
     *             .listEmailContactsPaginator(request);
     *     for (software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notificationscontacts.paginators.ListEmailContactsIterable responses = client.listEmailContactsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEmailContacts(software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEmailContactsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.ListEmailContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/ListEmailContacts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEmailContactsIterable listEmailContactsPaginator(ListEmailContactsRequest listEmailContactsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, NotificationsContactsException {
        return new ListEmailContactsIterable(this, listEmailContactsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEmailContacts(software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notificationscontacts.paginators.ListEmailContactsIterable responses = client.listEmailContactsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notificationscontacts.paginators.ListEmailContactsIterable responses = client
     *             .listEmailContactsPaginator(request);
     *     for (software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notificationscontacts.paginators.ListEmailContactsIterable responses = client.listEmailContactsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEmailContacts(software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEmailContactsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEmailContactsRequest#builder()}
     * </p>
     *
     * @param listEmailContactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.ListEmailContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/ListEmailContacts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEmailContactsIterable listEmailContactsPaginator(
            Consumer<ListEmailContactsRequest.Builder> listEmailContactsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            NotificationsContactsException {
        return listEmailContactsPaginator(ListEmailContactsRequest.builder().applyMutation(listEmailContactsRequest).build());
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * user, server, or role.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ResourceNotFoundException
     *         Your request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, NotificationsContactsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * user, server, or role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ResourceNotFoundException
     *         Your request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, NotificationsContactsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Sends an activation email to the email address associated with the specified email contact.
     * </p>
     * <note>
     * <p>
     * It might take a few minutes for the activation email to arrive. If it doesn't arrive, check in your spam folder
     * or try sending another activation email.
     * </p>
     * </note>
     *
     * @param sendActivationCodeRequest
     * @return Result of the SendActivationCode operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ResourceNotFoundException
     *         Your request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.SendActivationCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/SendActivationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default SendActivationCodeResponse sendActivationCode(SendActivationCodeRequest sendActivationCodeRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, NotificationsContactsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends an activation email to the email address associated with the specified email contact.
     * </p>
     * <note>
     * <p>
     * It might take a few minutes for the activation email to arrive. If it doesn't arrive, check in your spam folder
     * or try sending another activation email.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendActivationCodeRequest.Builder} avoiding the
     * need to create one manually via {@link SendActivationCodeRequest#builder()}
     * </p>
     *
     * @param sendActivationCodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.SendActivationCodeRequest.Builder} to
     *        create a request.
     * @return Result of the SendActivationCode operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ResourceNotFoundException
     *         Your request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.SendActivationCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/SendActivationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default SendActivationCodeResponse sendActivationCode(Consumer<SendActivationCodeRequest.Builder> sendActivationCodeRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, NotificationsContactsException {
        return sendActivationCode(SendActivationCodeRequest.builder().applyMutation(sendActivationCodeRequest).build());
    }

    /**
     * <p>
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Taggable resources in
     * AWS User Notifications Contacts include email contacts.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ResourceNotFoundException
     *         Your request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, NotificationsContactsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Taggable resources in
     * AWS User Notifications Contacts include email contacts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ResourceNotFoundException
     *         Your request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, NotificationsContactsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Taggable resources in
     * AWS User Notifications Contacts include email contacts..
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ResourceNotFoundException
     *         Your request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, NotificationsContactsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Taggable resources in
     * AWS User Notifications Contacts include email contacts..
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.UntagResourceRequest.Builder} to create
     *        a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ResourceNotFoundException
     *         Your request references a resource which does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsContactsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsContactsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, NotificationsContactsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Create a {@link NotificationsContactsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static NotificationsContactsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link NotificationsContactsClient}.
     */
    static NotificationsContactsClientBuilder builder() {
        return new DefaultNotificationsContactsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default NotificationsContactsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
