/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notificationscontacts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.notificationscontacts.model.EmailContact;
import software.amazon.awssdk.services.notificationscontacts.model.EmailContactsCopier;
import software.amazon.awssdk.services.notificationscontacts.model.NotificationsContactsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEmailContactsResponse
extends NotificationsContactsResponse
implements ToCopyableBuilder<Builder, ListEmailContactsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEmailContactsResponse.getter(ListEmailContactsResponse::nextToken)).setter(ListEmailContactsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<EmailContact>> EMAIL_CONTACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("emailContacts").getter(ListEmailContactsResponse.getter(ListEmailContactsResponse::emailContacts)).setter(ListEmailContactsResponse.setter(Builder::emailContacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailContacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EmailContact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, EMAIL_CONTACTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEmailContactsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<EmailContact> emailContacts;

    private ListEmailContactsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.emailContacts = builder.emailContacts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasEmailContacts() {
        return this.emailContacts != null && !(this.emailContacts instanceof SdkAutoConstructList);
    }

    public final List<EmailContact> emailContacts() {
        return this.emailContacts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmailContacts() ? this.emailContacts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEmailContactsResponse)) {
            return false;
        }
        ListEmailContactsResponse other = (ListEmailContactsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasEmailContacts() == other.hasEmailContacts() && Objects.equals(this.emailContacts(), other.emailContacts());
    }

    public final String toString() {
        return ToString.builder((String)"ListEmailContactsResponse").add("NextToken", (Object)this.nextToken()).add("EmailContacts", this.hasEmailContacts() ? this.emailContacts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "emailContacts": {
                return Optional.ofNullable(clazz.cast(this.emailContacts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("emailContacts", EMAIL_CONTACTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEmailContactsResponse, T> g) {
        return obj -> g.apply((ListEmailContactsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NotificationsContactsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<EmailContact> emailContacts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEmailContactsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.emailContacts(model.emailContacts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<EmailContact.Builder> getEmailContacts() {
            List<EmailContact.Builder> result = EmailContactsCopier.copyToBuilder(this.emailContacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmailContacts(Collection<EmailContact.BuilderImpl> emailContacts) {
            this.emailContacts = EmailContactsCopier.copyFromBuilder(emailContacts);
        }

        @Override
        public final Builder emailContacts(Collection<EmailContact> emailContacts) {
            this.emailContacts = EmailContactsCopier.copy(emailContacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailContacts(EmailContact ... emailContacts) {
            this.emailContacts(Arrays.asList(emailContacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailContacts(Consumer<EmailContact.Builder> ... emailContacts) {
            this.emailContacts(Stream.of(emailContacts).map(c -> (EmailContact)((EmailContact.Builder)EmailContact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEmailContactsResponse build() {
            return new ListEmailContactsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NotificationsContactsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEmailContactsResponse> {
        public Builder nextToken(String var1);

        public Builder emailContacts(Collection<EmailContact> var1);

        public Builder emailContacts(EmailContact ... var1);

        public Builder emailContacts(Consumer<EmailContact.Builder> ... var1);
    }
}

