/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notificationscontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notificationscontacts.NotificationsContactsAsyncClient;
import software.amazon.awssdk.services.notificationscontacts.internal.UserAgentUtils;
import software.amazon.awssdk.services.notificationscontacts.model.EmailContact;
import software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsRequest;
import software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsResponse;

public class ListEmailContactsPublisher
implements SdkPublisher<ListEmailContactsResponse> {
    private final NotificationsContactsAsyncClient client;
    private final ListEmailContactsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEmailContactsPublisher(NotificationsContactsAsyncClient client, ListEmailContactsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEmailContactsPublisher(NotificationsContactsAsyncClient client, ListEmailContactsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEmailContactsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEmailContactsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EmailContact> emailContacts() {
        Function<ListEmailContactsResponse, Iterator> getIterator = response -> {
            if (response != null && response.emailContacts() != null) {
                return response.emailContacts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEmailContactsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEmailContactsResponseFetcher
    implements AsyncPageFetcher<ListEmailContactsResponse> {
        private ListEmailContactsResponseFetcher() {
        }

        public boolean hasNextPage(ListEmailContactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEmailContactsResponse> nextPage(ListEmailContactsResponse previousPage) {
            if (previousPage == null) {
                return ListEmailContactsPublisher.this.client.listEmailContacts(ListEmailContactsPublisher.this.firstRequest);
            }
            return ListEmailContactsPublisher.this.client.listEmailContacts((ListEmailContactsRequest)((Object)ListEmailContactsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

