/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccountContactType {
    ACCOUNT_PRIMARY("ACCOUNT_PRIMARY"),
    ACCOUNT_ALTERNATE_BILLING("ACCOUNT_ALTERNATE_BILLING"),
    ACCOUNT_ALTERNATE_OPERATIONS("ACCOUNT_ALTERNATE_OPERATIONS"),
    ACCOUNT_ALTERNATE_SECURITY("ACCOUNT_ALTERNATE_SECURITY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccountContactType> VALUE_MAP;
    private final String value;

    private AccountContactType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccountContactType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccountContactType> knownValues() {
        EnumSet<AccountContactType> knownValues = EnumSet.allOf(AccountContactType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccountContactType.class, AccountContactType::toString);
    }
}

