/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Custom volume configuration for the root volumes that are attached to streaming sessions.
 * </p>
 * <p>
 * This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VolumeConfiguration.Builder, VolumeConfiguration> {
    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("iops")
            .getter(getter(VolumeConfiguration::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iops").build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("size")
            .getter(getter(VolumeConfiguration::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()).build();

    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("throughput").getter(getter(VolumeConfiguration::throughput)).setter(setter(Builder::throughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throughput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IOPS_FIELD, SIZE_FIELD,
            THROUGHPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer iops;

    private final Integer size;

    private final Integer throughput;

    private VolumeConfiguration(BuilderImpl builder) {
        this.iops = builder.iops;
        this.size = builder.size;
        this.throughput = builder.throughput;
    }

    /**
     * <p>
     * The number of I/O operations per second for the root volume that is attached to streaming session.
     * </p>
     * 
     * @return The number of I/O operations per second for the root volume that is attached to streaming session.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The size of the root volume that is attached to the streaming session. The root volume size is measured in GiBs.
     * </p>
     * 
     * @return The size of the root volume that is attached to the streaming session. The root volume size is measured
     *         in GiBs.
     */
    public final Integer size() {
        return size;
    }

    /**
     * <p>
     * The throughput to provision for the root volume that is attached to the streaming session. The throughput is
     * measured in MiB/s.
     * </p>
     * 
     * @return The throughput to provision for the root volume that is attached to the streaming session. The throughput
     *         is measured in MiB/s.
     */
    public final Integer throughput() {
        return throughput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(throughput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeConfiguration)) {
            return false;
        }
        VolumeConfiguration other = (VolumeConfiguration) obj;
        return Objects.equals(iops(), other.iops()) && Objects.equals(size(), other.size())
                && Objects.equals(throughput(), other.throughput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VolumeConfiguration").add("Iops", iops()).add("Size", size()).add("Throughput", throughput())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "size":
            return Optional.ofNullable(clazz.cast(size()));
        case "throughput":
            return Optional.ofNullable(clazz.cast(throughput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeConfiguration, T> g) {
        return obj -> g.apply((VolumeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeConfiguration> {
        /**
         * <p>
         * The number of I/O operations per second for the root volume that is attached to streaming session.
         * </p>
         * 
         * @param iops
         *        The number of I/O operations per second for the root volume that is attached to streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The size of the root volume that is attached to the streaming session. The root volume size is measured in
         * GiBs.
         * </p>
         * 
         * @param size
         *        The size of the root volume that is attached to the streaming session. The root volume size is
         *        measured in GiBs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The throughput to provision for the root volume that is attached to the streaming session. The throughput is
         * measured in MiB/s.
         * </p>
         * 
         * @param throughput
         *        The throughput to provision for the root volume that is attached to the streaming session. The
         *        throughput is measured in MiB/s.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughput(Integer throughput);
    }

    static final class BuilderImpl implements Builder {
        private Integer iops;

        private Integer size;

        private Integer throughput;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeConfiguration model) {
            iops(model.iops);
            size(model.size);
            throughput(model.throughput);
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Integer getSize() {
            return size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final Integer getThroughput() {
            return throughput;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        @Override
        public VolumeConfiguration build() {
            return new VolumeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
