/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutStudioMembersRequest extends NimbleRequest implements
        ToCopyableBuilder<PutStudioMembersRequest.Builder, PutStudioMembersRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(PutStudioMembersRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityStoreId").getter(getter(PutStudioMembersRequest::identityStoreId))
            .setter(setter(Builder::identityStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityStoreId").build()).build();

    private static final SdkField<List<NewStudioMember>> MEMBERS_FIELD = SdkField
            .<List<NewStudioMember>> builder(MarshallingType.LIST)
            .memberName("members")
            .getter(getter(PutStudioMembersRequest::members))
            .setter(setter(Builder::members))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("members").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NewStudioMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(NewStudioMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("studioId").getter(getter(PutStudioMembersRequest::studioId)).setter(setter(Builder::studioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            IDENTITY_STORE_ID_FIELD, MEMBERS_FIELD, STUDIO_ID_FIELD));

    private final String clientToken;

    private final String identityStoreId;

    private final List<NewStudioMember> members;

    private final String studioId;

    private PutStudioMembersRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.identityStoreId = builder.identityStoreId;
        this.members = builder.members;
        this.studioId = builder.studioId;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify
     * a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to
     * ensure idempotency.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t
     *         specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it
     *         for the request to ensure idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID of the identity store.
     * </p>
     * 
     * @return The ID of the identity store.
     */
    public final String identityStoreId() {
        return identityStoreId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Members property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMembers() {
        return members != null && !(members instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of members.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMembers} method.
     * </p>
     * 
     * @return A list of members.
     */
    public final List<NewStudioMember> members() {
        return members;
    }

    /**
     * <p>
     * The studio ID.
     * </p>
     * 
     * @return The studio ID.
     */
    public final String studioId() {
        return studioId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(hasMembers() ? members() : null);
        hashCode = 31 * hashCode + Objects.hashCode(studioId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutStudioMembersRequest)) {
            return false;
        }
        PutStudioMembersRequest other = (PutStudioMembersRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(identityStoreId(), other.identityStoreId())
                && hasMembers() == other.hasMembers() && Objects.equals(members(), other.members())
                && Objects.equals(studioId(), other.studioId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutStudioMembersRequest").add("ClientToken", clientToken())
                .add("IdentityStoreId", identityStoreId()).add("Members", hasMembers() ? members() : null)
                .add("StudioId", studioId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "identityStoreId":
            return Optional.ofNullable(clazz.cast(identityStoreId()));
        case "members":
            return Optional.ofNullable(clazz.cast(members()));
        case "studioId":
            return Optional.ofNullable(clazz.cast(studioId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutStudioMembersRequest, T> g) {
        return obj -> g.apply((PutStudioMembersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutStudioMembersRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t
         * specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for
         * the request to ensure idempotency.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
         *        don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and
         *        uses it for the request to ensure idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID of the identity store.
         * </p>
         * 
         * @param identityStoreId
         *        The ID of the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityStoreId(String identityStoreId);

        /**
         * <p>
         * A list of members.
         * </p>
         * 
         * @param members
         *        A list of members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(Collection<NewStudioMember> members);

        /**
         * <p>
         * A list of members.
         * </p>
         * 
         * @param members
         *        A list of members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(NewStudioMember... members);

        /**
         * <p>
         * A list of members.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.nimble.model.NewStudioMember.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.nimble.model.NewStudioMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.nimble.model.NewStudioMember.Builder#build()} is called immediately
         * and its result is passed to {@link #members(List<NewStudioMember>)}.
         * 
         * @param members
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.nimble.model.NewStudioMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #members(java.util.Collection<NewStudioMember>)
         */
        Builder members(Consumer<NewStudioMember.Builder>... members);

        /**
         * <p>
         * The studio ID.
         * </p>
         * 
         * @param studioId
         *        The studio ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioId(String studioId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NimbleRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String identityStoreId;

        private List<NewStudioMember> members = DefaultSdkAutoConstructList.getInstance();

        private String studioId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutStudioMembersRequest model) {
            super(model);
            clientToken(model.clientToken);
            identityStoreId(model.identityStoreId);
            members(model.members);
            studioId(model.studioId);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getIdentityStoreId() {
            return identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final List<NewStudioMember.Builder> getMembers() {
            List<NewStudioMember.Builder> result = NewStudioMemberListCopier.copyToBuilder(this.members);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembers(Collection<NewStudioMember.BuilderImpl> members) {
            this.members = NewStudioMemberListCopier.copyFromBuilder(members);
        }

        @Override
        public final Builder members(Collection<NewStudioMember> members) {
            this.members = NewStudioMemberListCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(NewStudioMember... members) {
            members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<NewStudioMember.Builder>... members) {
            members(Stream.of(members).map(c -> NewStudioMember.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStudioId() {
            return studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutStudioMembersRequest build() {
            return new PutStudioMembersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
