/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleAsyncClient;
import software.amazon.awssdk.services.nimble.model.ListStreamingSessionBackupsRequest;
import software.amazon.awssdk.services.nimble.model.ListStreamingSessionBackupsResponse;
import software.amazon.awssdk.services.nimble.model.StreamingSessionBackup;

public class ListStreamingSessionBackupsPublisher
implements SdkPublisher<ListStreamingSessionBackupsResponse> {
    private final NimbleAsyncClient client;
    private final ListStreamingSessionBackupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStreamingSessionBackupsPublisher(NimbleAsyncClient client, ListStreamingSessionBackupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStreamingSessionBackupsPublisher(NimbleAsyncClient client, ListStreamingSessionBackupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStreamingSessionBackupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStreamingSessionBackupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StreamingSessionBackup> streamingSessionBackups() {
        Function<ListStreamingSessionBackupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.streamingSessionBackups() != null) {
                return response.streamingSessionBackups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStreamingSessionBackupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStreamingSessionBackupsResponseFetcher
    implements AsyncPageFetcher<ListStreamingSessionBackupsResponse> {
        private ListStreamingSessionBackupsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamingSessionBackupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStreamingSessionBackupsResponse> nextPage(ListStreamingSessionBackupsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamingSessionBackupsPublisher.this.client.listStreamingSessionBackups(ListStreamingSessionBackupsPublisher.this.firstRequest);
            }
            return ListStreamingSessionBackupsPublisher.this.client.listStreamingSessionBackups((ListStreamingSessionBackupsRequest)((Object)ListStreamingSessionBackupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

