/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmonitor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkmonitor.model.AddressFamily;
import software.amazon.awssdk.services.networkmonitor.model.NetworkMonitorResponse;
import software.amazon.awssdk.services.networkmonitor.model.ProbeState;
import software.amazon.awssdk.services.networkmonitor.model.Protocol;
import software.amazon.awssdk.services.networkmonitor.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProbeResponse
extends NetworkMonitorResponse
implements ToCopyableBuilder<Builder, GetProbeResponse> {
    private static final SdkField<String> PROBE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("probeId").getter(GetProbeResponse.getter(GetProbeResponse::probeId)).setter(GetProbeResponse.setter(Builder::probeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("probeId").build()}).build();
    private static final SdkField<String> PROBE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("probeArn").getter(GetProbeResponse.getter(GetProbeResponse::probeArn)).setter(GetProbeResponse.setter(Builder::probeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("probeArn").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceArn").getter(GetProbeResponse.getter(GetProbeResponse::sourceArn)).setter(GetProbeResponse.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArn").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destination").getter(GetProbeResponse.getter(GetProbeResponse::destination)).setter(GetProbeResponse.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<Integer> DESTINATION_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("destinationPort").getter(GetProbeResponse.getter(GetProbeResponse::destinationPort)).setter(GetProbeResponse.setter(Builder::destinationPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPort").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(GetProbeResponse.getter(GetProbeResponse::protocolAsString)).setter(GetProbeResponse.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<Integer> PACKET_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("packetSize").getter(GetProbeResponse.getter(GetProbeResponse::packetSize)).setter(GetProbeResponse.setter(Builder::packetSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packetSize").build()}).build();
    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addressFamily").getter(GetProbeResponse.getter(GetProbeResponse::addressFamilyAsString)).setter(GetProbeResponse.setter(Builder::addressFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressFamily").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcId").getter(GetProbeResponse.getter(GetProbeResponse::vpcId)).setter(GetProbeResponse.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(GetProbeResponse.getter(GetProbeResponse::stateAsString)).setter(GetProbeResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetProbeResponse.getter(GetProbeResponse::createdAt)).setter(GetProbeResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(GetProbeResponse.getter(GetProbeResponse::modifiedAt)).setter(GetProbeResponse.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetProbeResponse.getter(GetProbeResponse::tags)).setter(GetProbeResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROBE_ID_FIELD, PROBE_ARN_FIELD, SOURCE_ARN_FIELD, DESTINATION_FIELD, DESTINATION_PORT_FIELD, PROTOCOL_FIELD, PACKET_SIZE_FIELD, ADDRESS_FAMILY_FIELD, VPC_ID_FIELD, STATE_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetProbeResponse.memberNameToFieldInitializer();
    private final String probeId;
    private final String probeArn;
    private final String sourceArn;
    private final String destination;
    private final Integer destinationPort;
    private final String protocol;
    private final Integer packetSize;
    private final String addressFamily;
    private final String vpcId;
    private final String state;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final Map<String, String> tags;

    private GetProbeResponse(BuilderImpl builder) {
        super(builder);
        this.probeId = builder.probeId;
        this.probeArn = builder.probeArn;
        this.sourceArn = builder.sourceArn;
        this.destination = builder.destination;
        this.destinationPort = builder.destinationPort;
        this.protocol = builder.protocol;
        this.packetSize = builder.packetSize;
        this.addressFamily = builder.addressFamily;
        this.vpcId = builder.vpcId;
        this.state = builder.state;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.tags = builder.tags;
    }

    public final String probeId() {
        return this.probeId;
    }

    public final String probeArn() {
        return this.probeArn;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final String destination() {
        return this.destination;
    }

    public final Integer destinationPort() {
        return this.destinationPort;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final Integer packetSize() {
        return this.packetSize;
    }

    public final AddressFamily addressFamily() {
        return AddressFamily.fromValue(this.addressFamily);
    }

    public final String addressFamilyAsString() {
        return this.addressFamily;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final ProbeState state() {
        return ProbeState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.probeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.probeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.packetSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProbeResponse)) {
            return false;
        }
        GetProbeResponse other = (GetProbeResponse)((Object)obj);
        return Objects.equals(this.probeId(), other.probeId()) && Objects.equals(this.probeArn(), other.probeArn()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.destinationPort(), other.destinationPort()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.packetSize(), other.packetSize()) && Objects.equals(this.addressFamilyAsString(), other.addressFamilyAsString()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetProbeResponse").add("ProbeId", (Object)this.probeId()).add("ProbeArn", (Object)this.probeArn()).add("SourceArn", (Object)this.sourceArn()).add("Destination", (Object)this.destination()).add("DestinationPort", (Object)this.destinationPort()).add("Protocol", (Object)this.protocolAsString()).add("PacketSize", (Object)this.packetSize()).add("AddressFamily", (Object)this.addressFamilyAsString()).add("VpcId", (Object)this.vpcId()).add("State", (Object)this.stateAsString()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "probeId": {
                return Optional.ofNullable(clazz.cast(this.probeId()));
            }
            case "probeArn": {
                return Optional.ofNullable(clazz.cast(this.probeArn()));
            }
            case "sourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "destinationPort": {
                return Optional.ofNullable(clazz.cast(this.destinationPort()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "packetSize": {
                return Optional.ofNullable(clazz.cast(this.packetSize()));
            }
            case "addressFamily": {
                return Optional.ofNullable(clazz.cast(this.addressFamilyAsString()));
            }
            case "vpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("probeId", PROBE_ID_FIELD);
        map.put("probeArn", PROBE_ARN_FIELD);
        map.put("sourceArn", SOURCE_ARN_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("destinationPort", DESTINATION_PORT_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("packetSize", PACKET_SIZE_FIELD);
        map.put("addressFamily", ADDRESS_FAMILY_FIELD);
        map.put("vpcId", VPC_ID_FIELD);
        map.put("state", STATE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetProbeResponse, T> g) {
        return obj -> g.apply((GetProbeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkMonitorResponse.BuilderImpl
    implements Builder {
        private String probeId;
        private String probeArn;
        private String sourceArn;
        private String destination;
        private Integer destinationPort;
        private String protocol;
        private Integer packetSize;
        private String addressFamily;
        private String vpcId;
        private String state;
        private Instant createdAt;
        private Instant modifiedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetProbeResponse model) {
            super(model);
            this.probeId(model.probeId);
            this.probeArn(model.probeArn);
            this.sourceArn(model.sourceArn);
            this.destination(model.destination);
            this.destinationPort(model.destinationPort);
            this.protocol(model.protocol);
            this.packetSize(model.packetSize);
            this.addressFamily(model.addressFamily);
            this.vpcId(model.vpcId);
            this.state(model.state);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.tags(model.tags);
        }

        public final String getProbeId() {
            return this.probeId;
        }

        public final void setProbeId(String probeId) {
            this.probeId = probeId;
        }

        @Override
        public final Builder probeId(String probeId) {
            this.probeId = probeId;
            return this;
        }

        public final String getProbeArn() {
            return this.probeArn;
        }

        public final void setProbeArn(String probeArn) {
            this.probeArn = probeArn;
        }

        @Override
        public final Builder probeArn(String probeArn) {
            this.probeArn = probeArn;
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final Integer getDestinationPort() {
            return this.destinationPort;
        }

        public final void setDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getPacketSize() {
            return this.packetSize;
        }

        public final void setPacketSize(Integer packetSize) {
            this.packetSize = packetSize;
        }

        @Override
        public final Builder packetSize(Integer packetSize) {
            this.packetSize = packetSize;
            return this;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily == null ? null : addressFamily.toString());
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ProbeState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetProbeResponse build() {
            return new GetProbeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkMonitorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProbeResponse> {
        public Builder probeId(String var1);

        public Builder probeArn(String var1);

        public Builder sourceArn(String var1);

        public Builder destination(String var1);

        public Builder destinationPort(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder packetSize(Integer var1);

        public Builder addressFamily(String var1);

        public Builder addressFamily(AddressFamily var1);

        public Builder vpcId(String var1);

        public Builder state(String var1);

        public Builder state(ProbeState var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

