/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmonitor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmonitor.model.NetworkMonitorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMonitorRequest
extends NetworkMonitorRequest
implements ToCopyableBuilder<Builder, UpdateMonitorRequest> {
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitorName").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::monitorName)).setter(UpdateMonitorRequest.setter(Builder::monitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("monitorName").build()}).build();
    private static final SdkField<Long> AGGREGATION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("aggregationPeriod").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::aggregationPeriod)).setter(UpdateMonitorRequest.setter(Builder::aggregationPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_NAME_FIELD, AGGREGATION_PERIOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMonitorRequest.memberNameToFieldInitializer();
    private final String monitorName;
    private final Long aggregationPeriod;

    private UpdateMonitorRequest(BuilderImpl builder) {
        super(builder);
        this.monitorName = builder.monitorName;
        this.aggregationPeriod = builder.aggregationPeriod;
    }

    public final String monitorName() {
        return this.monitorName;
    }

    public final Long aggregationPeriod() {
        return this.aggregationPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationPeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMonitorRequest)) {
            return false;
        }
        UpdateMonitorRequest other = (UpdateMonitorRequest)((Object)obj);
        return Objects.equals(this.monitorName(), other.monitorName()) && Objects.equals(this.aggregationPeriod(), other.aggregationPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMonitorRequest").add("MonitorName", (Object)this.monitorName()).add("AggregationPeriod", (Object)this.aggregationPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "monitorName": {
                return Optional.ofNullable(clazz.cast(this.monitorName()));
            }
            case "aggregationPeriod": {
                return Optional.ofNullable(clazz.cast(this.aggregationPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("monitorName", MONITOR_NAME_FIELD);
        map.put("aggregationPeriod", AGGREGATION_PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMonitorRequest, T> g) {
        return obj -> g.apply((UpdateMonitorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkMonitorRequest.BuilderImpl
    implements Builder {
        private String monitorName;
        private Long aggregationPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMonitorRequest model) {
            super(model);
            this.monitorName(model.monitorName);
            this.aggregationPeriod(model.aggregationPeriod);
        }

        public final String getMonitorName() {
            return this.monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final Long getAggregationPeriod() {
            return this.aggregationPeriod;
        }

        public final void setAggregationPeriod(Long aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
        }

        @Override
        public final Builder aggregationPeriod(Long aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMonitorRequest build() {
            return new UpdateMonitorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkMonitorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMonitorRequest> {
        public Builder monitorName(String var1);

        public Builder aggregationPeriod(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

