/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.PathComponent;
import software.amazon.awssdk.services.networkmanager.model.PathComponentListCopier;
import software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteAnalysisPath
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteAnalysisPath> {
    private static final SdkField<RouteAnalysisCompletion> COMPLETION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CompletionStatus").getter(RouteAnalysisPath.getter(RouteAnalysisPath::completionStatus)).setter(RouteAnalysisPath.setter(Builder::completionStatus)).constructor(RouteAnalysisCompletion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionStatus").build()}).build();
    private static final SdkField<List<PathComponent>> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Path").getter(RouteAnalysisPath.getter(RouteAnalysisPath::path)).setter(RouteAnalysisPath.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PathComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_STATUS_FIELD, PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteAnalysisPath.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RouteAnalysisCompletion completionStatus;
    private final List<PathComponent> path;

    private RouteAnalysisPath(BuilderImpl builder) {
        this.completionStatus = builder.completionStatus;
        this.path = builder.path;
    }

    public final RouteAnalysisCompletion completionStatus() {
        return this.completionStatus;
    }

    public final boolean hasPath() {
        return this.path != null && !(this.path instanceof SdkAutoConstructList);
    }

    public final List<PathComponent> path() {
        return this.path;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.completionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPath() ? this.path() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteAnalysisPath)) {
            return false;
        }
        RouteAnalysisPath other = (RouteAnalysisPath)obj;
        return Objects.equals(this.completionStatus(), other.completionStatus()) && this.hasPath() == other.hasPath() && Objects.equals(this.path(), other.path());
    }

    public final String toString() {
        return ToString.builder((String)"RouteAnalysisPath").add("CompletionStatus", (Object)this.completionStatus()).add("Path", this.hasPath() ? this.path() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompletionStatus": {
                return Optional.ofNullable(clazz.cast(this.completionStatus()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CompletionStatus", COMPLETION_STATUS_FIELD);
        map.put("Path", PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteAnalysisPath, T> g) {
        return obj -> g.apply((RouteAnalysisPath)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RouteAnalysisCompletion completionStatus;
        private List<PathComponent> path = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteAnalysisPath model) {
            this.completionStatus(model.completionStatus);
            this.path(model.path);
        }

        public final RouteAnalysisCompletion.Builder getCompletionStatus() {
            return this.completionStatus != null ? this.completionStatus.toBuilder() : null;
        }

        public final void setCompletionStatus(RouteAnalysisCompletion.BuilderImpl completionStatus) {
            this.completionStatus = completionStatus != null ? completionStatus.build() : null;
        }

        @Override
        public final Builder completionStatus(RouteAnalysisCompletion completionStatus) {
            this.completionStatus = completionStatus;
            return this;
        }

        public final List<PathComponent.Builder> getPath() {
            List<PathComponent.Builder> result = PathComponentListCopier.copyToBuilder(this.path);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPath(Collection<PathComponent.BuilderImpl> path) {
            this.path = PathComponentListCopier.copyFromBuilder(path);
        }

        @Override
        public final Builder path(Collection<PathComponent> path) {
            this.path = PathComponentListCopier.copy(path);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(PathComponent ... path) {
            this.path(Arrays.asList(path));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(Consumer<PathComponent.Builder> ... path) {
            this.path(Stream.of(path).map(c -> (PathComponent)((PathComponent.Builder)PathComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RouteAnalysisPath build() {
            return new RouteAnalysisPath(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteAnalysisPath> {
        public Builder completionStatus(RouteAnalysisCompletion var1);

        default public Builder completionStatus(Consumer<RouteAnalysisCompletion.Builder> completionStatus) {
            return this.completionStatus((RouteAnalysisCompletion)((RouteAnalysisCompletion.Builder)RouteAnalysisCompletion.builder().applyMutation(completionStatus)).build());
        }

        public Builder path(Collection<PathComponent> var1);

        public Builder path(PathComponent ... var1);

        public Builder path(Consumer<PathComponent.Builder> ... var1);
    }
}

