/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.LinkAssociationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LinkAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LinkAssociation> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalNetworkId").getter(LinkAssociation.getter(LinkAssociation::globalNetworkId)).setter(LinkAssociation.setter(Builder::globalNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNetworkId").build()}).build();
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(LinkAssociation.getter(LinkAssociation::deviceId)).setter(LinkAssociation.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<String> LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinkId").getter(LinkAssociation.getter(LinkAssociation::linkId)).setter(LinkAssociation.setter(Builder::linkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkId").build()}).build();
    private static final SdkField<String> LINK_ASSOCIATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinkAssociationState").getter(LinkAssociation.getter(LinkAssociation::linkAssociationStateAsString)).setter(LinkAssociation.setter(Builder::linkAssociationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkAssociationState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD, DEVICE_ID_FIELD, LINK_ID_FIELD, LINK_ASSOCIATION_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LinkAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String globalNetworkId;
    private final String deviceId;
    private final String linkId;
    private final String linkAssociationState;

    private LinkAssociation(BuilderImpl builder) {
        this.globalNetworkId = builder.globalNetworkId;
        this.deviceId = builder.deviceId;
        this.linkId = builder.linkId;
        this.linkAssociationState = builder.linkAssociationState;
    }

    public final String globalNetworkId() {
        return this.globalNetworkId;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final String linkId() {
        return this.linkId;
    }

    public final LinkAssociationState linkAssociationState() {
        return LinkAssociationState.fromValue(this.linkAssociationState);
    }

    public final String linkAssociationStateAsString() {
        return this.linkAssociationState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkAssociationStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkAssociation)) {
            return false;
        }
        LinkAssociation other = (LinkAssociation)obj;
        return Objects.equals(this.globalNetworkId(), other.globalNetworkId()) && Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.linkId(), other.linkId()) && Objects.equals(this.linkAssociationStateAsString(), other.linkAssociationStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LinkAssociation").add("GlobalNetworkId", (Object)this.globalNetworkId()).add("DeviceId", (Object)this.deviceId()).add("LinkId", (Object)this.linkId()).add("LinkAssociationState", (Object)this.linkAssociationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalNetworkId": {
                return Optional.ofNullable(clazz.cast(this.globalNetworkId()));
            }
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "LinkId": {
                return Optional.ofNullable(clazz.cast(this.linkId()));
            }
            case "LinkAssociationState": {
                return Optional.ofNullable(clazz.cast(this.linkAssociationStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("GlobalNetworkId", GLOBAL_NETWORK_ID_FIELD);
        map.put("DeviceId", DEVICE_ID_FIELD);
        map.put("LinkId", LINK_ID_FIELD);
        map.put("LinkAssociationState", LINK_ASSOCIATION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LinkAssociation, T> g) {
        return obj -> g.apply((LinkAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String globalNetworkId;
        private String deviceId;
        private String linkId;
        private String linkAssociationState;

        private BuilderImpl() {
        }

        private BuilderImpl(LinkAssociation model) {
            this.globalNetworkId(model.globalNetworkId);
            this.deviceId(model.deviceId);
            this.linkId(model.linkId);
            this.linkAssociationState(model.linkAssociationState);
        }

        public final String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getLinkId() {
            return this.linkId;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @Override
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public final String getLinkAssociationState() {
            return this.linkAssociationState;
        }

        public final void setLinkAssociationState(String linkAssociationState) {
            this.linkAssociationState = linkAssociationState;
        }

        @Override
        public final Builder linkAssociationState(String linkAssociationState) {
            this.linkAssociationState = linkAssociationState;
            return this;
        }

        @Override
        public final Builder linkAssociationState(LinkAssociationState linkAssociationState) {
            this.linkAssociationState(linkAssociationState == null ? null : linkAssociationState.toString());
            return this;
        }

        public LinkAssociation build() {
            return new LinkAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LinkAssociation> {
        public Builder globalNetworkId(String var1);

        public Builder deviceId(String var1);

        public Builder linkId(String var1);

        public Builder linkAssociationState(String var1);

        public Builder linkAssociationState(LinkAssociationState var1);
    }
}

