/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.AttachmentError;
import software.amazon.awssdk.services.networkmanager.model.AttachmentErrorListCopier;
import software.amazon.awssdk.services.networkmanager.model.AttachmentState;
import software.amazon.awssdk.services.networkmanager.model.AttachmentType;
import software.amazon.awssdk.services.networkmanager.model.ExternalRegionCodeListCopier;
import software.amazon.awssdk.services.networkmanager.model.ProposedNetworkFunctionGroupChange;
import software.amazon.awssdk.services.networkmanager.model.ProposedSegmentChange;
import software.amazon.awssdk.services.networkmanager.model.Tag;
import software.amazon.awssdk.services.networkmanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Attachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Attachment> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkId").getter(Attachment.getter(Attachment::coreNetworkId)).setter(Attachment.setter(Builder::coreNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()}).build();
    private static final SdkField<String> CORE_NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkArn").getter(Attachment.getter(Attachment::coreNetworkArn)).setter(Attachment.setter(Builder::coreNetworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkArn").build()}).build();
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentId").getter(Attachment.getter(Attachment::attachmentId)).setter(Attachment.setter(Builder::attachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccountId").getter(Attachment.getter(Attachment::ownerAccountId)).setter(Attachment.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final SdkField<String> ATTACHMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentType").getter(Attachment.getter(Attachment::attachmentTypeAsString)).setter(Attachment.setter(Builder::attachmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentType").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Attachment.getter(Attachment::stateAsString)).setter(Attachment.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> EDGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgeLocation").getter(Attachment.getter(Attachment::edgeLocation)).setter(Attachment.setter(Builder::edgeLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocation").build()}).build();
    private static final SdkField<List<String>> EDGE_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EdgeLocations").getter(Attachment.getter(Attachment::edgeLocations)).setter(Attachment.setter(Builder::edgeLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(Attachment.getter(Attachment::resourceArn)).setter(Attachment.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<Integer> ATTACHMENT_POLICY_RULE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AttachmentPolicyRuleNumber").getter(Attachment.getter(Attachment::attachmentPolicyRuleNumber)).setter(Attachment.setter(Builder::attachmentPolicyRuleNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentPolicyRuleNumber").build()}).build();
    private static final SdkField<String> SEGMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentName").getter(Attachment.getter(Attachment::segmentName)).setter(Attachment.setter(Builder::segmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentName").build()}).build();
    private static final SdkField<String> NETWORK_FUNCTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkFunctionGroupName").getter(Attachment.getter(Attachment::networkFunctionGroupName)).setter(Attachment.setter(Builder::networkFunctionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFunctionGroupName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Attachment.getter(Attachment::tags)).setter(Attachment.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProposedSegmentChange> PROPOSED_SEGMENT_CHANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProposedSegmentChange").getter(Attachment.getter(Attachment::proposedSegmentChange)).setter(Attachment.setter(Builder::proposedSegmentChange)).constructor(ProposedSegmentChange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProposedSegmentChange").build()}).build();
    private static final SdkField<ProposedNetworkFunctionGroupChange> PROPOSED_NETWORK_FUNCTION_GROUP_CHANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProposedNetworkFunctionGroupChange").getter(Attachment.getter(Attachment::proposedNetworkFunctionGroupChange)).setter(Attachment.setter(Builder::proposedNetworkFunctionGroupChange)).constructor(ProposedNetworkFunctionGroupChange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProposedNetworkFunctionGroupChange").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(Attachment.getter(Attachment::createdAt)).setter(Attachment.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(Attachment.getter(Attachment::updatedAt)).setter(Attachment.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<List<AttachmentError>> LAST_MODIFICATION_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LastModificationErrors").getter(Attachment.getter(Attachment::lastModificationErrors)).setter(Attachment.setter(Builder::lastModificationErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttachmentError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD, CORE_NETWORK_ARN_FIELD, ATTACHMENT_ID_FIELD, OWNER_ACCOUNT_ID_FIELD, ATTACHMENT_TYPE_FIELD, STATE_FIELD, EDGE_LOCATION_FIELD, EDGE_LOCATIONS_FIELD, RESOURCE_ARN_FIELD, ATTACHMENT_POLICY_RULE_NUMBER_FIELD, SEGMENT_NAME_FIELD, NETWORK_FUNCTION_GROUP_NAME_FIELD, TAGS_FIELD, PROPOSED_SEGMENT_CHANGE_FIELD, PROPOSED_NETWORK_FUNCTION_GROUP_CHANGE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, LAST_MODIFICATION_ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CoreNetworkId", CORE_NETWORK_ID_FIELD);
            this.put("CoreNetworkArn", CORE_NETWORK_ARN_FIELD);
            this.put("AttachmentId", ATTACHMENT_ID_FIELD);
            this.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
            this.put("AttachmentType", ATTACHMENT_TYPE_FIELD);
            this.put("State", STATE_FIELD);
            this.put("EdgeLocation", EDGE_LOCATION_FIELD);
            this.put("EdgeLocations", EDGE_LOCATIONS_FIELD);
            this.put("ResourceArn", RESOURCE_ARN_FIELD);
            this.put("AttachmentPolicyRuleNumber", ATTACHMENT_POLICY_RULE_NUMBER_FIELD);
            this.put("SegmentName", SEGMENT_NAME_FIELD);
            this.put("NetworkFunctionGroupName", NETWORK_FUNCTION_GROUP_NAME_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("ProposedSegmentChange", PROPOSED_SEGMENT_CHANGE_FIELD);
            this.put("ProposedNetworkFunctionGroupChange", PROPOSED_NETWORK_FUNCTION_GROUP_CHANGE_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("UpdatedAt", UPDATED_AT_FIELD);
            this.put("LastModificationErrors", LAST_MODIFICATION_ERRORS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String coreNetworkId;
    private final String coreNetworkArn;
    private final String attachmentId;
    private final String ownerAccountId;
    private final String attachmentType;
    private final String state;
    private final String edgeLocation;
    private final List<String> edgeLocations;
    private final String resourceArn;
    private final Integer attachmentPolicyRuleNumber;
    private final String segmentName;
    private final String networkFunctionGroupName;
    private final List<Tag> tags;
    private final ProposedSegmentChange proposedSegmentChange;
    private final ProposedNetworkFunctionGroupChange proposedNetworkFunctionGroupChange;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final List<AttachmentError> lastModificationErrors;

    private Attachment(BuilderImpl builder) {
        this.coreNetworkId = builder.coreNetworkId;
        this.coreNetworkArn = builder.coreNetworkArn;
        this.attachmentId = builder.attachmentId;
        this.ownerAccountId = builder.ownerAccountId;
        this.attachmentType = builder.attachmentType;
        this.state = builder.state;
        this.edgeLocation = builder.edgeLocation;
        this.edgeLocations = builder.edgeLocations;
        this.resourceArn = builder.resourceArn;
        this.attachmentPolicyRuleNumber = builder.attachmentPolicyRuleNumber;
        this.segmentName = builder.segmentName;
        this.networkFunctionGroupName = builder.networkFunctionGroupName;
        this.tags = builder.tags;
        this.proposedSegmentChange = builder.proposedSegmentChange;
        this.proposedNetworkFunctionGroupChange = builder.proposedNetworkFunctionGroupChange;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.lastModificationErrors = builder.lastModificationErrors;
    }

    public final String coreNetworkId() {
        return this.coreNetworkId;
    }

    public final String coreNetworkArn() {
        return this.coreNetworkArn;
    }

    public final String attachmentId() {
        return this.attachmentId;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final AttachmentType attachmentType() {
        return AttachmentType.fromValue(this.attachmentType);
    }

    public final String attachmentTypeAsString() {
        return this.attachmentType;
    }

    public final AttachmentState state() {
        return AttachmentState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String edgeLocation() {
        return this.edgeLocation;
    }

    public final boolean hasEdgeLocations() {
        return this.edgeLocations != null && !(this.edgeLocations instanceof SdkAutoConstructList);
    }

    public final List<String> edgeLocations() {
        return this.edgeLocations;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final Integer attachmentPolicyRuleNumber() {
        return this.attachmentPolicyRuleNumber;
    }

    public final String segmentName() {
        return this.segmentName;
    }

    public final String networkFunctionGroupName() {
        return this.networkFunctionGroupName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ProposedSegmentChange proposedSegmentChange() {
        return this.proposedSegmentChange;
    }

    public final ProposedNetworkFunctionGroupChange proposedNetworkFunctionGroupChange() {
        return this.proposedNetworkFunctionGroupChange;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasLastModificationErrors() {
        return this.lastModificationErrors != null && !(this.lastModificationErrors instanceof SdkAutoConstructList);
    }

    public final List<AttachmentError> lastModificationErrors() {
        return this.lastModificationErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEdgeLocations() ? this.edgeLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentPolicyRuleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFunctionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.proposedSegmentChange());
        hashCode = 31 * hashCode + Objects.hashCode(this.proposedNetworkFunctionGroupChange());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLastModificationErrors() ? this.lastModificationErrors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)obj;
        return Objects.equals(this.coreNetworkId(), other.coreNetworkId()) && Objects.equals(this.coreNetworkArn(), other.coreNetworkArn()) && Objects.equals(this.attachmentId(), other.attachmentId()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.attachmentTypeAsString(), other.attachmentTypeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.edgeLocation(), other.edgeLocation()) && this.hasEdgeLocations() == other.hasEdgeLocations() && Objects.equals(this.edgeLocations(), other.edgeLocations()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.attachmentPolicyRuleNumber(), other.attachmentPolicyRuleNumber()) && Objects.equals(this.segmentName(), other.segmentName()) && Objects.equals(this.networkFunctionGroupName(), other.networkFunctionGroupName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.proposedSegmentChange(), other.proposedSegmentChange()) && Objects.equals(this.proposedNetworkFunctionGroupChange(), other.proposedNetworkFunctionGroupChange()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasLastModificationErrors() == other.hasLastModificationErrors() && Objects.equals(this.lastModificationErrors(), other.lastModificationErrors());
    }

    public final String toString() {
        return ToString.builder((String)"Attachment").add("CoreNetworkId", (Object)this.coreNetworkId()).add("CoreNetworkArn", (Object)this.coreNetworkArn()).add("AttachmentId", (Object)this.attachmentId()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("AttachmentType", (Object)this.attachmentTypeAsString()).add("State", (Object)this.stateAsString()).add("EdgeLocation", (Object)this.edgeLocation()).add("EdgeLocations", this.hasEdgeLocations() ? this.edgeLocations() : null).add("ResourceArn", (Object)this.resourceArn()).add("AttachmentPolicyRuleNumber", (Object)this.attachmentPolicyRuleNumber()).add("SegmentName", (Object)this.segmentName()).add("NetworkFunctionGroupName", (Object)this.networkFunctionGroupName()).add("Tags", this.hasTags() ? this.tags() : null).add("ProposedSegmentChange", (Object)this.proposedSegmentChange()).add("ProposedNetworkFunctionGroupChange", (Object)this.proposedNetworkFunctionGroupChange()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("LastModificationErrors", this.hasLastModificationErrors() ? this.lastModificationErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoreNetworkId": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkId()));
            }
            case "CoreNetworkArn": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkArn()));
            }
            case "AttachmentId": {
                return Optional.ofNullable(clazz.cast(this.attachmentId()));
            }
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "AttachmentType": {
                return Optional.ofNullable(clazz.cast(this.attachmentTypeAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "EdgeLocation": {
                return Optional.ofNullable(clazz.cast(this.edgeLocation()));
            }
            case "EdgeLocations": {
                return Optional.ofNullable(clazz.cast(this.edgeLocations()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "AttachmentPolicyRuleNumber": {
                return Optional.ofNullable(clazz.cast(this.attachmentPolicyRuleNumber()));
            }
            case "SegmentName": {
                return Optional.ofNullable(clazz.cast(this.segmentName()));
            }
            case "NetworkFunctionGroupName": {
                return Optional.ofNullable(clazz.cast(this.networkFunctionGroupName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ProposedSegmentChange": {
                return Optional.ofNullable(clazz.cast(this.proposedSegmentChange()));
            }
            case "ProposedNetworkFunctionGroupChange": {
                return Optional.ofNullable(clazz.cast(this.proposedNetworkFunctionGroupChange()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "LastModificationErrors": {
                return Optional.ofNullable(clazz.cast(this.lastModificationErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Attachment, T> g) {
        return obj -> g.apply((Attachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String coreNetworkId;
        private String coreNetworkArn;
        private String attachmentId;
        private String ownerAccountId;
        private String attachmentType;
        private String state;
        private String edgeLocation;
        private List<String> edgeLocations = DefaultSdkAutoConstructList.getInstance();
        private String resourceArn;
        private Integer attachmentPolicyRuleNumber;
        private String segmentName;
        private String networkFunctionGroupName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private ProposedSegmentChange proposedSegmentChange;
        private ProposedNetworkFunctionGroupChange proposedNetworkFunctionGroupChange;
        private Instant createdAt;
        private Instant updatedAt;
        private List<AttachmentError> lastModificationErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Attachment model) {
            this.coreNetworkId(model.coreNetworkId);
            this.coreNetworkArn(model.coreNetworkArn);
            this.attachmentId(model.attachmentId);
            this.ownerAccountId(model.ownerAccountId);
            this.attachmentType(model.attachmentType);
            this.state(model.state);
            this.edgeLocation(model.edgeLocation);
            this.edgeLocations(model.edgeLocations);
            this.resourceArn(model.resourceArn);
            this.attachmentPolicyRuleNumber(model.attachmentPolicyRuleNumber);
            this.segmentName(model.segmentName);
            this.networkFunctionGroupName(model.networkFunctionGroupName);
            this.tags(model.tags);
            this.proposedSegmentChange(model.proposedSegmentChange);
            this.proposedNetworkFunctionGroupChange(model.proposedNetworkFunctionGroupChange);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.lastModificationErrors(model.lastModificationErrors);
        }

        public final String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getCoreNetworkArn() {
            return this.coreNetworkArn;
        }

        public final void setCoreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
        }

        @Override
        public final Builder coreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
            return this;
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getAttachmentType() {
            return this.attachmentType;
        }

        public final void setAttachmentType(String attachmentType) {
            this.attachmentType = attachmentType;
        }

        @Override
        public final Builder attachmentType(String attachmentType) {
            this.attachmentType = attachmentType;
            return this;
        }

        @Override
        public final Builder attachmentType(AttachmentType attachmentType) {
            this.attachmentType(attachmentType == null ? null : attachmentType.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AttachmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getEdgeLocation() {
            return this.edgeLocation;
        }

        public final void setEdgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
        }

        @Override
        public final Builder edgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
            return this;
        }

        public final Collection<String> getEdgeLocations() {
            if (this.edgeLocations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.edgeLocations;
        }

        public final void setEdgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
        }

        @Override
        public final Builder edgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeLocations(String ... edgeLocations) {
            this.edgeLocations(Arrays.asList(edgeLocations));
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Integer getAttachmentPolicyRuleNumber() {
            return this.attachmentPolicyRuleNumber;
        }

        public final void setAttachmentPolicyRuleNumber(Integer attachmentPolicyRuleNumber) {
            this.attachmentPolicyRuleNumber = attachmentPolicyRuleNumber;
        }

        @Override
        public final Builder attachmentPolicyRuleNumber(Integer attachmentPolicyRuleNumber) {
            this.attachmentPolicyRuleNumber = attachmentPolicyRuleNumber;
            return this;
        }

        public final String getSegmentName() {
            return this.segmentName;
        }

        public final void setSegmentName(String segmentName) {
            this.segmentName = segmentName;
        }

        @Override
        public final Builder segmentName(String segmentName) {
            this.segmentName = segmentName;
            return this;
        }

        public final String getNetworkFunctionGroupName() {
            return this.networkFunctionGroupName;
        }

        public final void setNetworkFunctionGroupName(String networkFunctionGroupName) {
            this.networkFunctionGroupName = networkFunctionGroupName;
        }

        @Override
        public final Builder networkFunctionGroupName(String networkFunctionGroupName) {
            this.networkFunctionGroupName = networkFunctionGroupName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProposedSegmentChange.Builder getProposedSegmentChange() {
            return this.proposedSegmentChange != null ? this.proposedSegmentChange.toBuilder() : null;
        }

        public final void setProposedSegmentChange(ProposedSegmentChange.BuilderImpl proposedSegmentChange) {
            this.proposedSegmentChange = proposedSegmentChange != null ? proposedSegmentChange.build() : null;
        }

        @Override
        public final Builder proposedSegmentChange(ProposedSegmentChange proposedSegmentChange) {
            this.proposedSegmentChange = proposedSegmentChange;
            return this;
        }

        public final ProposedNetworkFunctionGroupChange.Builder getProposedNetworkFunctionGroupChange() {
            return this.proposedNetworkFunctionGroupChange != null ? this.proposedNetworkFunctionGroupChange.toBuilder() : null;
        }

        public final void setProposedNetworkFunctionGroupChange(ProposedNetworkFunctionGroupChange.BuilderImpl proposedNetworkFunctionGroupChange) {
            this.proposedNetworkFunctionGroupChange = proposedNetworkFunctionGroupChange != null ? proposedNetworkFunctionGroupChange.build() : null;
        }

        @Override
        public final Builder proposedNetworkFunctionGroupChange(ProposedNetworkFunctionGroupChange proposedNetworkFunctionGroupChange) {
            this.proposedNetworkFunctionGroupChange = proposedNetworkFunctionGroupChange;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<AttachmentError.Builder> getLastModificationErrors() {
            List<AttachmentError.Builder> result = AttachmentErrorListCopier.copyToBuilder(this.lastModificationErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLastModificationErrors(Collection<AttachmentError.BuilderImpl> lastModificationErrors) {
            this.lastModificationErrors = AttachmentErrorListCopier.copyFromBuilder(lastModificationErrors);
        }

        @Override
        public final Builder lastModificationErrors(Collection<AttachmentError> lastModificationErrors) {
            this.lastModificationErrors = AttachmentErrorListCopier.copy(lastModificationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastModificationErrors(AttachmentError ... lastModificationErrors) {
            this.lastModificationErrors(Arrays.asList(lastModificationErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastModificationErrors(Consumer<AttachmentError.Builder> ... lastModificationErrors) {
            this.lastModificationErrors(Stream.of(lastModificationErrors).map(c -> (AttachmentError)((AttachmentError.Builder)AttachmentError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Attachment build() {
            return new Attachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Attachment> {
        public Builder coreNetworkId(String var1);

        public Builder coreNetworkArn(String var1);

        public Builder attachmentId(String var1);

        public Builder ownerAccountId(String var1);

        public Builder attachmentType(String var1);

        public Builder attachmentType(AttachmentType var1);

        public Builder state(String var1);

        public Builder state(AttachmentState var1);

        public Builder edgeLocation(String var1);

        public Builder edgeLocations(Collection<String> var1);

        public Builder edgeLocations(String ... var1);

        public Builder resourceArn(String var1);

        public Builder attachmentPolicyRuleNumber(Integer var1);

        public Builder segmentName(String var1);

        public Builder networkFunctionGroupName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder proposedSegmentChange(ProposedSegmentChange var1);

        default public Builder proposedSegmentChange(Consumer<ProposedSegmentChange.Builder> proposedSegmentChange) {
            return this.proposedSegmentChange((ProposedSegmentChange)((ProposedSegmentChange.Builder)ProposedSegmentChange.builder().applyMutation(proposedSegmentChange)).build());
        }

        public Builder proposedNetworkFunctionGroupChange(ProposedNetworkFunctionGroupChange var1);

        default public Builder proposedNetworkFunctionGroupChange(Consumer<ProposedNetworkFunctionGroupChange.Builder> proposedNetworkFunctionGroupChange) {
            return this.proposedNetworkFunctionGroupChange((ProposedNetworkFunctionGroupChange)((ProposedNetworkFunctionGroupChange.Builder)ProposedNetworkFunctionGroupChange.builder().applyMutation(proposedNetworkFunctionGroupChange)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder lastModificationErrors(Collection<AttachmentError> var1);

        public Builder lastModificationErrors(AttachmentError ... var1);

        public Builder lastModificationErrors(Consumer<AttachmentError.Builder> ... var1);
    }
}

