/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyVersion;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsResponse;

public class ListCoreNetworkPolicyVersionsPublisher
implements SdkPublisher<ListCoreNetworkPolicyVersionsResponse> {
    private final NetworkManagerAsyncClient client;
    private final ListCoreNetworkPolicyVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCoreNetworkPolicyVersionsPublisher(NetworkManagerAsyncClient client, ListCoreNetworkPolicyVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCoreNetworkPolicyVersionsPublisher(NetworkManagerAsyncClient client, ListCoreNetworkPolicyVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCoreNetworkPolicyVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCoreNetworkPolicyVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CoreNetworkPolicyVersion> coreNetworkPolicyVersions() {
        Function<ListCoreNetworkPolicyVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.coreNetworkPolicyVersions() != null) {
                return response.coreNetworkPolicyVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCoreNetworkPolicyVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCoreNetworkPolicyVersionsResponseFetcher
    implements AsyncPageFetcher<ListCoreNetworkPolicyVersionsResponse> {
        private ListCoreNetworkPolicyVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCoreNetworkPolicyVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCoreNetworkPolicyVersionsResponse> nextPage(ListCoreNetworkPolicyVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListCoreNetworkPolicyVersionsPublisher.this.client.listCoreNetworkPolicyVersions(ListCoreNetworkPolicyVersionsPublisher.this.firstRequest);
            }
            return ListCoreNetworkPolicyVersionsPublisher.this.client.listCoreNetworkPolicyVersions((ListCoreNetworkPolicyVersionsRequest)((Object)ListCoreNetworkPolicyVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

