/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsResponse;
import software.amazon.awssdk.services.networkmanager.model.Relationship;

public class GetNetworkResourceRelationshipsPublisher
implements SdkPublisher<GetNetworkResourceRelationshipsResponse> {
    private final NetworkManagerAsyncClient client;
    private final GetNetworkResourceRelationshipsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetNetworkResourceRelationshipsPublisher(NetworkManagerAsyncClient client, GetNetworkResourceRelationshipsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetNetworkResourceRelationshipsPublisher(NetworkManagerAsyncClient client, GetNetworkResourceRelationshipsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetNetworkResourceRelationshipsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetNetworkResourceRelationshipsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Relationship> relationships() {
        Function<GetNetworkResourceRelationshipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.relationships() != null) {
                return response.relationships().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetNetworkResourceRelationshipsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetNetworkResourceRelationshipsResponseFetcher
    implements AsyncPageFetcher<GetNetworkResourceRelationshipsResponse> {
        private GetNetworkResourceRelationshipsResponseFetcher() {
        }

        public boolean hasNextPage(GetNetworkResourceRelationshipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetNetworkResourceRelationshipsResponse> nextPage(GetNetworkResourceRelationshipsResponse previousPage) {
            if (previousPage == null) {
                return GetNetworkResourceRelationshipsPublisher.this.client.getNetworkResourceRelationships(GetNetworkResourceRelationshipsPublisher.this.firstRequest);
            }
            return GetNetworkResourceRelationshipsPublisher.this.client.getNetworkResourceRelationships((GetNetworkResourceRelationshipsRequest)((Object)GetNetworkResourceRelationshipsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

