/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.model.Connection;
import software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetConnectionsResponse;

public class GetConnectionsIterable
implements SdkIterable<GetConnectionsResponse> {
    private final NetworkManagerClient client;
    private final GetConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetConnectionsIterable(NetworkManagerClient client, GetConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetConnectionsResponseFetcher();
    }

    public Iterator<GetConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Connection> connections() {
        Function<GetConnectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connections() != null) {
                return response.connections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetConnectionsResponseFetcher
    implements SyncPageFetcher<GetConnectionsResponse> {
        private GetConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(GetConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetConnectionsResponse nextPage(GetConnectionsResponse previousPage) {
            if (previousPage == null) {
                return GetConnectionsIterable.this.client.getConnections(GetConnectionsIterable.this.firstRequest);
            }
            return GetConnectionsIterable.this.client.getConnections((GetConnectionsRequest)((Object)GetConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

