/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociation;
import software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsResponse;

public class GetConnectPeerAssociationsPublisher
implements SdkPublisher<GetConnectPeerAssociationsResponse> {
    private final NetworkManagerAsyncClient client;
    private final GetConnectPeerAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetConnectPeerAssociationsPublisher(NetworkManagerAsyncClient client, GetConnectPeerAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetConnectPeerAssociationsPublisher(NetworkManagerAsyncClient client, GetConnectPeerAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetConnectPeerAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetConnectPeerAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConnectPeerAssociation> connectPeerAssociations() {
        Function<GetConnectPeerAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectPeerAssociations() != null) {
                return response.connectPeerAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetConnectPeerAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetConnectPeerAssociationsResponseFetcher
    implements AsyncPageFetcher<GetConnectPeerAssociationsResponse> {
        private GetConnectPeerAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(GetConnectPeerAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetConnectPeerAssociationsResponse> nextPage(GetConnectPeerAssociationsResponse previousPage) {
            if (previousPage == null) {
                return GetConnectPeerAssociationsPublisher.this.client.getConnectPeerAssociations(GetConnectPeerAssociationsPublisher.this.firstRequest);
            }
            return GetConnectPeerAssociationsPublisher.this.client.getConnectPeerAssociations((GetConnectPeerAssociationsRequest)((Object)GetConnectPeerAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

