/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.CustomerGatewayAssociationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomerGatewayAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomerGatewayAssociation> {
    private static final SdkField<String> CUSTOMER_GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerGatewayArn").getter(CustomerGatewayAssociation.getter(CustomerGatewayAssociation::customerGatewayArn)).setter(CustomerGatewayAssociation.setter(Builder::customerGatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayArn").build()}).build();
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalNetworkId").getter(CustomerGatewayAssociation.getter(CustomerGatewayAssociation::globalNetworkId)).setter(CustomerGatewayAssociation.setter(Builder::globalNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNetworkId").build()}).build();
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(CustomerGatewayAssociation.getter(CustomerGatewayAssociation::deviceId)).setter(CustomerGatewayAssociation.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<String> LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinkId").getter(CustomerGatewayAssociation.getter(CustomerGatewayAssociation::linkId)).setter(CustomerGatewayAssociation.setter(Builder::linkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CustomerGatewayAssociation.getter(CustomerGatewayAssociation::stateAsString)).setter(CustomerGatewayAssociation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_GATEWAY_ARN_FIELD, GLOBAL_NETWORK_ID_FIELD, DEVICE_ID_FIELD, LINK_ID_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String customerGatewayArn;
    private final String globalNetworkId;
    private final String deviceId;
    private final String linkId;
    private final String state;

    private CustomerGatewayAssociation(BuilderImpl builder) {
        this.customerGatewayArn = builder.customerGatewayArn;
        this.globalNetworkId = builder.globalNetworkId;
        this.deviceId = builder.deviceId;
        this.linkId = builder.linkId;
        this.state = builder.state;
    }

    public final String customerGatewayArn() {
        return this.customerGatewayArn;
    }

    public final String globalNetworkId() {
        return this.globalNetworkId;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final String linkId() {
        return this.linkId;
    }

    public final CustomerGatewayAssociationState state() {
        return CustomerGatewayAssociationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customerGatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerGatewayAssociation)) {
            return false;
        }
        CustomerGatewayAssociation other = (CustomerGatewayAssociation)obj;
        return Objects.equals(this.customerGatewayArn(), other.customerGatewayArn()) && Objects.equals(this.globalNetworkId(), other.globalNetworkId()) && Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.linkId(), other.linkId()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CustomerGatewayAssociation").add("CustomerGatewayArn", (Object)this.customerGatewayArn()).add("GlobalNetworkId", (Object)this.globalNetworkId()).add("DeviceId", (Object)this.deviceId()).add("LinkId", (Object)this.linkId()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerGatewayArn": {
                return Optional.ofNullable(clazz.cast(this.customerGatewayArn()));
            }
            case "GlobalNetworkId": {
                return Optional.ofNullable(clazz.cast(this.globalNetworkId()));
            }
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "LinkId": {
                return Optional.ofNullable(clazz.cast(this.linkId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomerGatewayAssociation, T> g) {
        return obj -> g.apply((CustomerGatewayAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customerGatewayArn;
        private String globalNetworkId;
        private String deviceId;
        private String linkId;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerGatewayAssociation model) {
            this.customerGatewayArn(model.customerGatewayArn);
            this.globalNetworkId(model.globalNetworkId);
            this.deviceId(model.deviceId);
            this.linkId(model.linkId);
            this.state(model.state);
        }

        public final String getCustomerGatewayArn() {
            return this.customerGatewayArn;
        }

        public final void setCustomerGatewayArn(String customerGatewayArn) {
            this.customerGatewayArn = customerGatewayArn;
        }

        @Override
        @Transient
        public final Builder customerGatewayArn(String customerGatewayArn) {
            this.customerGatewayArn = customerGatewayArn;
            return this;
        }

        public final String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        @Transient
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        @Transient
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getLinkId() {
            return this.linkId;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @Override
        @Transient
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(CustomerGatewayAssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public CustomerGatewayAssociation build() {
            return new CustomerGatewayAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomerGatewayAssociation> {
        public Builder customerGatewayArn(String var1);

        public Builder globalNetworkId(String var1);

        public Builder deviceId(String var1);

        public Builder linkId(String var1);

        public Builder state(String var1);

        public Builder state(CustomerGatewayAssociationState var1);
    }
}

