/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.model.AccessDeniedException;
import software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayRequest;
import software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayResponse;
import software.amazon.awssdk.services.networkmanager.model.AssociateLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.AssociateLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.ConflictException;
import software.amazon.awssdk.services.networkmanager.model.CreateDeviceRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateDeviceResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateSiteRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateSiteResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteDeviceRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteDeviceResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteSiteRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteSiteResponse;
import software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayRequest;
import software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayResponse;
import software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest;
import software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse;
import software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayRequest;
import software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayResponse;
import software.amazon.awssdk.services.networkmanager.model.DisassociateLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.DisassociateLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest;
import software.amazon.awssdk.services.networkmanager.model.GetDevicesResponse;
import software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetLinksRequest;
import software.amazon.awssdk.services.networkmanager.model.GetLinksResponse;
import software.amazon.awssdk.services.networkmanager.model.GetSitesRequest;
import software.amazon.awssdk.services.networkmanager.model.GetSitesResponse;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsResponse;
import software.amazon.awssdk.services.networkmanager.model.InternalServerException;
import software.amazon.awssdk.services.networkmanager.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.networkmanager.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerException;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerRequest;
import software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayRequest;
import software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayResponse;
import software.amazon.awssdk.services.networkmanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.networkmanager.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.networkmanager.model.TagResourceRequest;
import software.amazon.awssdk.services.networkmanager.model.TagResourceResponse;
import software.amazon.awssdk.services.networkmanager.model.ThrottlingException;
import software.amazon.awssdk.services.networkmanager.model.UntagResourceRequest;
import software.amazon.awssdk.services.networkmanager.model.UntagResourceResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateDeviceRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateDeviceResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateSiteRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateSiteResponse;
import software.amazon.awssdk.services.networkmanager.model.ValidationException;
import software.amazon.awssdk.services.networkmanager.paginators.DescribeGlobalNetworksIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetCustomerGatewayAssociationsIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetDevicesIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetLinkAssociationsIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetLinksIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetSitesIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayRegistrationsIterable;
import software.amazon.awssdk.services.networkmanager.transform.AssociateCustomerGatewayRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.AssociateLinkRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.CreateDeviceRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.CreateGlobalNetworkRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.CreateLinkRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.CreateSiteRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.DeleteDeviceRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.DeleteGlobalNetworkRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.DeleteLinkRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.DeleteSiteRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.DeregisterTransitGatewayRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.DescribeGlobalNetworksRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.DisassociateCustomerGatewayRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.DisassociateLinkRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.GetCustomerGatewayAssociationsRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.GetDevicesRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.GetLinkAssociationsRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.GetLinksRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.GetSitesRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.GetTransitGatewayRegistrationsRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.RegisterTransitGatewayRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.UpdateDeviceRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.UpdateGlobalNetworkRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.UpdateLinkRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.UpdateSiteRequestMarshaller;

@SdkInternalApi
final class DefaultNetworkManagerClient
implements NetworkManagerClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultNetworkManagerClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "networkmanager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateCustomerGatewayResponse associateCustomerGateway(AssociateCustomerGatewayRequest associateCustomerGatewayRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateCustomerGatewayResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateCustomerGateway");
            AssociateCustomerGatewayResponse associateCustomerGatewayResponse = (AssociateCustomerGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateCustomerGateway").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateCustomerGatewayRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new AssociateCustomerGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateCustomerGatewayResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, associateCustomerGatewayRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateLinkResponse associateLink(AssociateLinkRequest associateLinkRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateLinkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateLink");
            AssociateLinkResponse associateLinkResponse = (AssociateLinkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateLink").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateLinkRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new AssociateLinkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateLinkResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, associateLinkRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDeviceResponse createDevice(CreateDeviceRequest createDeviceRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDeviceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDevice");
            CreateDeviceResponse createDeviceResponse = (CreateDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDevice").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDeviceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDeviceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, createDeviceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGlobalNetworkResponse createGlobalNetwork(CreateGlobalNetworkRequest createGlobalNetworkRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGlobalNetworkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGlobalNetwork");
            CreateGlobalNetworkResponse createGlobalNetworkResponse = (CreateGlobalNetworkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGlobalNetwork").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGlobalNetworkRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateGlobalNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGlobalNetworkResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, createGlobalNetworkRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLinkResponse createLink(CreateLinkRequest createLinkRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLinkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLink");
            CreateLinkResponse createLinkResponse = (CreateLinkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLink").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLinkRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateLinkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLinkResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, createLinkRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSiteResponse createSite(CreateSiteRequest createSiteRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSiteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSite");
            CreateSiteResponse createSiteResponse = (CreateSiteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSite").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSiteRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateSiteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSiteResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, createSiteRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDeviceResponse deleteDevice(DeleteDeviceRequest deleteDeviceRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDeviceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDevice");
            DeleteDeviceResponse deleteDeviceResponse = (DeleteDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDevice").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDeviceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDeviceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, deleteDeviceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGlobalNetworkResponse deleteGlobalNetwork(DeleteGlobalNetworkRequest deleteGlobalNetworkRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGlobalNetworkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGlobalNetwork");
            DeleteGlobalNetworkResponse deleteGlobalNetworkResponse = (DeleteGlobalNetworkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGlobalNetwork").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGlobalNetworkRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteGlobalNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteGlobalNetworkResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, deleteGlobalNetworkRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLinkResponse deleteLink(DeleteLinkRequest deleteLinkRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLinkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLink");
            DeleteLinkResponse deleteLinkResponse = (DeleteLinkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLink").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLinkRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLinkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLinkResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, deleteLinkRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSiteResponse deleteSite(DeleteSiteRequest deleteSiteRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSiteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSite");
            DeleteSiteResponse deleteSiteResponse = (DeleteSiteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSite").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSiteRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSiteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSiteResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, deleteSiteRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterTransitGatewayResponse deregisterTransitGateway(DeregisterTransitGatewayRequest deregisterTransitGatewayRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterTransitGatewayResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterTransitGateway");
            DeregisterTransitGatewayResponse deregisterTransitGatewayResponse = (DeregisterTransitGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterTransitGateway").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterTransitGatewayRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterTransitGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterTransitGatewayResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, deregisterTransitGatewayRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGlobalNetworksResponse describeGlobalNetworks(DescribeGlobalNetworksRequest describeGlobalNetworksRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGlobalNetworksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGlobalNetworks");
            DescribeGlobalNetworksResponse describeGlobalNetworksResponse = (DescribeGlobalNetworksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGlobalNetworks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeGlobalNetworksRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeGlobalNetworksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeGlobalNetworksResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, describeGlobalNetworksRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public DescribeGlobalNetworksIterable describeGlobalNetworksPaginator(DescribeGlobalNetworksRequest describeGlobalNetworksRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return new DescribeGlobalNetworksIterable(this, this.applyPaginatorUserAgent(describeGlobalNetworksRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateCustomerGatewayResponse disassociateCustomerGateway(DisassociateCustomerGatewayRequest disassociateCustomerGatewayRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateCustomerGatewayResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateCustomerGateway");
            DisassociateCustomerGatewayResponse disassociateCustomerGatewayResponse = (DisassociateCustomerGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateCustomerGateway").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateCustomerGatewayRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateCustomerGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateCustomerGatewayResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, disassociateCustomerGatewayRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateLinkResponse disassociateLink(DisassociateLinkRequest disassociateLinkRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateLinkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateLink");
            DisassociateLinkResponse disassociateLinkResponse = (DisassociateLinkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateLink").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateLinkRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateLinkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateLinkResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, disassociateLinkRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCustomerGatewayAssociationsResponse getCustomerGatewayAssociations(GetCustomerGatewayAssociationsRequest getCustomerGatewayAssociationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCustomerGatewayAssociationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCustomerGatewayAssociations");
            GetCustomerGatewayAssociationsResponse getCustomerGatewayAssociationsResponse = (GetCustomerGatewayAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCustomerGatewayAssociations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCustomerGatewayAssociationsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetCustomerGatewayAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCustomerGatewayAssociationsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, getCustomerGatewayAssociationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public GetCustomerGatewayAssociationsIterable getCustomerGatewayAssociationsPaginator(GetCustomerGatewayAssociationsRequest getCustomerGatewayAssociationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return new GetCustomerGatewayAssociationsIterable(this, this.applyPaginatorUserAgent(getCustomerGatewayAssociationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDevicesResponse getDevices(GetDevicesRequest getDevicesRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDevicesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDevices");
            GetDevicesResponse getDevicesResponse = (GetDevicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDevices").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDevicesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetDevicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDevicesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, getDevicesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public GetDevicesIterable getDevicesPaginator(GetDevicesRequest getDevicesRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return new GetDevicesIterable(this, this.applyPaginatorUserAgent(getDevicesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLinkAssociationsResponse getLinkAssociations(GetLinkAssociationsRequest getLinkAssociationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLinkAssociationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLinkAssociations");
            GetLinkAssociationsResponse getLinkAssociationsResponse = (GetLinkAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLinkAssociations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLinkAssociationsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetLinkAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLinkAssociationsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, getLinkAssociationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public GetLinkAssociationsIterable getLinkAssociationsPaginator(GetLinkAssociationsRequest getLinkAssociationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return new GetLinkAssociationsIterable(this, this.applyPaginatorUserAgent(getLinkAssociationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLinksResponse getLinks(GetLinksRequest getLinksRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLinksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLinks");
            GetLinksResponse getLinksResponse = (GetLinksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLinks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLinksRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetLinksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLinksResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, getLinksRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public GetLinksIterable getLinksPaginator(GetLinksRequest getLinksRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return new GetLinksIterable(this, this.applyPaginatorUserAgent(getLinksRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSitesResponse getSites(GetSitesRequest getSitesRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSitesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSites");
            GetSitesResponse getSitesResponse = (GetSitesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSites").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSitesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetSitesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSitesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, getSitesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public GetSitesIterable getSitesPaginator(GetSitesRequest getSitesRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return new GetSitesIterable(this, this.applyPaginatorUserAgent(getSitesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTransitGatewayRegistrationsResponse getTransitGatewayRegistrations(GetTransitGatewayRegistrationsRequest getTransitGatewayRegistrationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTransitGatewayRegistrationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTransitGatewayRegistrations");
            GetTransitGatewayRegistrationsResponse getTransitGatewayRegistrationsResponse = (GetTransitGatewayRegistrationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTransitGatewayRegistrations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTransitGatewayRegistrationsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetTransitGatewayRegistrationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTransitGatewayRegistrationsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, getTransitGatewayRegistrationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public GetTransitGatewayRegistrationsIterable getTransitGatewayRegistrationsPaginator(GetTransitGatewayRegistrationsRequest getTransitGatewayRegistrationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return new GetTransitGatewayRegistrationsIterable(this, this.applyPaginatorUserAgent(getTransitGatewayRegistrationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterTransitGatewayResponse registerTransitGateway(RegisterTransitGatewayRequest registerTransitGatewayRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterTransitGatewayResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterTransitGateway");
            RegisterTransitGatewayResponse registerTransitGatewayResponse = (RegisterTransitGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterTransitGateway").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerTransitGatewayRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new RegisterTransitGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerTransitGatewayResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, registerTransitGatewayRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDeviceResponse updateDevice(UpdateDeviceRequest updateDeviceRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDeviceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDevice");
            UpdateDeviceResponse updateDeviceResponse = (UpdateDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDevice").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDeviceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDeviceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, updateDeviceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGlobalNetworkResponse updateGlobalNetwork(UpdateGlobalNetworkRequest updateGlobalNetworkRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGlobalNetworkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGlobalNetwork");
            UpdateGlobalNetworkResponse updateGlobalNetworkResponse = (UpdateGlobalNetworkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGlobalNetwork").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGlobalNetworkRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGlobalNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGlobalNetworkResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, updateGlobalNetworkRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLinkResponse updateLink(UpdateLinkRequest updateLinkRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLinkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLink");
            UpdateLinkResponse updateLinkResponse = (UpdateLinkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLink").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateLinkRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateLinkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateLinkResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, updateLinkRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSiteResponse updateSite(UpdateSiteRequest updateSiteRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSiteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"NetworkManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSite");
            UpdateSiteResponse updateSiteResponse = (UpdateSiteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSite").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSiteRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSiteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSiteResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultNetworkManagerClient.resolveMetricPublishers(this.clientConfiguration, updateSiteRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(NetworkManagerException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends NetworkManagerRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.62").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((NetworkManagerRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

