/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.CustomerGatewayAssociation;
import software.amazon.awssdk.services.networkmanager.model.CustomerGatewayAssociationListCopier;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCustomerGatewayAssociationsResponse
extends NetworkManagerResponse
implements ToCopyableBuilder<Builder, GetCustomerGatewayAssociationsResponse> {
    private static final SdkField<List<CustomerGatewayAssociation>> CUSTOMER_GATEWAY_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetCustomerGatewayAssociationsResponse.getter(GetCustomerGatewayAssociationsResponse::customerGatewayAssociations)).setter(GetCustomerGatewayAssociationsResponse.setter(Builder::customerGatewayAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomerGatewayAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetCustomerGatewayAssociationsResponse.getter(GetCustomerGatewayAssociationsResponse::nextToken)).setter(GetCustomerGatewayAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_GATEWAY_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<CustomerGatewayAssociation> customerGatewayAssociations;
    private final String nextToken;

    private GetCustomerGatewayAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.customerGatewayAssociations = builder.customerGatewayAssociations;
        this.nextToken = builder.nextToken;
    }

    public List<CustomerGatewayAssociation> customerGatewayAssociations() {
        return this.customerGatewayAssociations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.customerGatewayAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCustomerGatewayAssociationsResponse)) {
            return false;
        }
        GetCustomerGatewayAssociationsResponse other = (GetCustomerGatewayAssociationsResponse)((Object)obj);
        return Objects.equals(this.customerGatewayAssociations(), other.customerGatewayAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetCustomerGatewayAssociationsResponse").add("CustomerGatewayAssociations", this.customerGatewayAssociations()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerGatewayAssociations": {
                return Optional.ofNullable(clazz.cast(this.customerGatewayAssociations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCustomerGatewayAssociationsResponse, T> g) {
        return obj -> g.apply((GetCustomerGatewayAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerResponse.BuilderImpl
    implements Builder {
        private List<CustomerGatewayAssociation> customerGatewayAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCustomerGatewayAssociationsResponse model) {
            super(model);
            this.customerGatewayAssociations(model.customerGatewayAssociations);
            this.nextToken(model.nextToken);
        }

        public final Collection<CustomerGatewayAssociation.Builder> getCustomerGatewayAssociations() {
            return this.customerGatewayAssociations != null ? (Collection)this.customerGatewayAssociations.stream().map(CustomerGatewayAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customerGatewayAssociations(Collection<CustomerGatewayAssociation> customerGatewayAssociations) {
            this.customerGatewayAssociations = CustomerGatewayAssociationListCopier.copy(customerGatewayAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerGatewayAssociations(CustomerGatewayAssociation ... customerGatewayAssociations) {
            this.customerGatewayAssociations(Arrays.asList(customerGatewayAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerGatewayAssociations(Consumer<CustomerGatewayAssociation.Builder> ... customerGatewayAssociations) {
            this.customerGatewayAssociations(Stream.of(customerGatewayAssociations).map(c -> (CustomerGatewayAssociation)((CustomerGatewayAssociation.Builder)CustomerGatewayAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomerGatewayAssociations(Collection<CustomerGatewayAssociation.BuilderImpl> customerGatewayAssociations) {
            this.customerGatewayAssociations = CustomerGatewayAssociationListCopier.copyFromBuilder(customerGatewayAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetCustomerGatewayAssociationsResponse build() {
            return new GetCustomerGatewayAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCustomerGatewayAssociationsResponse> {
        public Builder customerGatewayAssociations(Collection<CustomerGatewayAssociation> var1);

        public Builder customerGatewayAssociations(CustomerGatewayAssociation ... var1);

        public Builder customerGatewayAssociations(Consumer<CustomerGatewayAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

