/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Network Flow Monitor is a feature of Amazon CloudWatch Network Monitoring that provides visibility into the
 * performance of network flows for your Amazon Web Services workloads, between instances in subnets, as well as to and
 * from Amazon Web Services. Lightweight agents that you install on the instances capture performance metrics for your
 * network flows, such as packet loss and latency, and send them to the Network Flow Monitor backend. Then, you can view
 * and analyze metrics from the top contributors for each metric type, to help troubleshoot issues.
 * </p>
 * <p>
 * In addition, when you create a monitor, Network Flow Monitor provides a network health indicator (NHI) that informs
 * you whether there were Amazon Web Services network issues for one or more of the network flows tracked by a monitor,
 * during a time period that you choose. By using this value, you can independently determine if the Amazon Web Services
 * network is impacting your workload during a specific time frame, to help you focus troubleshooting efforts.
 * </p>
 * <p>
 * To learn more about Network Flow Monitor, see the <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-NetworkFlowMonitor.html">Network Flow
 * Monitor User Guide</a> in the Amazon CloudWatch User Guide.
 * </p>
 */
package software.amazon.awssdk.services.networkflowmonitor;