/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateScopeRequest extends NetworkFlowMonitorRequest implements
        ToCopyableBuilder<UpdateScopeRequest.Builder, UpdateScopeRequest> {
    private static final SdkField<String> SCOPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scopeId").getter(getter(UpdateScopeRequest::scopeId)).setter(setter(Builder::scopeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("scopeId").build()).build();

    private static final SdkField<List<TargetResource>> RESOURCES_TO_ADD_FIELD = SdkField
            .<List<TargetResource>> builder(MarshallingType.LIST)
            .memberName("resourcesToAdd")
            .getter(getter(UpdateScopeRequest::resourcesToAdd))
            .setter(setter(Builder::resourcesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TargetResource>> RESOURCES_TO_DELETE_FIELD = SdkField
            .<List<TargetResource>> builder(MarshallingType.LIST)
            .memberName("resourcesToDelete")
            .getter(getter(UpdateScopeRequest::resourcesToDelete))
            .setter(setter(Builder::resourcesToDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_ID_FIELD,
            RESOURCES_TO_ADD_FIELD, RESOURCES_TO_DELETE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String scopeId;

    private final List<TargetResource> resourcesToAdd;

    private final List<TargetResource> resourcesToDelete;

    private UpdateScopeRequest(BuilderImpl builder) {
        super(builder);
        this.scopeId = builder.scopeId;
        this.resourcesToAdd = builder.resourcesToAdd;
        this.resourcesToDelete = builder.resourcesToDelete;
    }

    /**
     * <p>
     * The identifier for the scope that includes the resources you want to get data results for. A scope ID is an
     * internally-generated identifier that includes all the resources for a specific root account.
     * </p>
     * 
     * @return The identifier for the scope that includes the resources you want to get data results for. A scope ID is
     *         an internally-generated identifier that includes all the resources for a specific root account.
     */
    public final String scopeId() {
        return scopeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourcesToAdd property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourcesToAdd() {
        return resourcesToAdd != null && !(resourcesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resources to add to a scope.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourcesToAdd} method.
     * </p>
     * 
     * @return A list of resources to add to a scope.
     */
    public final List<TargetResource> resourcesToAdd() {
        return resourcesToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourcesToDelete property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourcesToDelete() {
        return resourcesToDelete != null && !(resourcesToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resources to delete from a scope.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourcesToDelete} method.
     * </p>
     * 
     * @return A list of resources to delete from a scope.
     */
    public final List<TargetResource> resourcesToDelete() {
        return resourcesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scopeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourcesToAdd() ? resourcesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourcesToDelete() ? resourcesToDelete() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScopeRequest)) {
            return false;
        }
        UpdateScopeRequest other = (UpdateScopeRequest) obj;
        return Objects.equals(scopeId(), other.scopeId()) && hasResourcesToAdd() == other.hasResourcesToAdd()
                && Objects.equals(resourcesToAdd(), other.resourcesToAdd())
                && hasResourcesToDelete() == other.hasResourcesToDelete()
                && Objects.equals(resourcesToDelete(), other.resourcesToDelete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateScopeRequest").add("ScopeId", scopeId())
                .add("ResourcesToAdd", hasResourcesToAdd() ? resourcesToAdd() : null)
                .add("ResourcesToDelete", hasResourcesToDelete() ? resourcesToDelete() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scopeId":
            return Optional.ofNullable(clazz.cast(scopeId()));
        case "resourcesToAdd":
            return Optional.ofNullable(clazz.cast(resourcesToAdd()));
        case "resourcesToDelete":
            return Optional.ofNullable(clazz.cast(resourcesToDelete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scopeId", SCOPE_ID_FIELD);
        map.put("resourcesToAdd", RESOURCES_TO_ADD_FIELD);
        map.put("resourcesToDelete", RESOURCES_TO_DELETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateScopeRequest, T> g) {
        return obj -> g.apply((UpdateScopeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFlowMonitorRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateScopeRequest> {
        /**
         * <p>
         * The identifier for the scope that includes the resources you want to get data results for. A scope ID is an
         * internally-generated identifier that includes all the resources for a specific root account.
         * </p>
         * 
         * @param scopeId
         *        The identifier for the scope that includes the resources you want to get data results for. A scope ID
         *        is an internally-generated identifier that includes all the resources for a specific root account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeId(String scopeId);

        /**
         * <p>
         * A list of resources to add to a scope.
         * </p>
         * 
         * @param resourcesToAdd
         *        A list of resources to add to a scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesToAdd(Collection<TargetResource> resourcesToAdd);

        /**
         * <p>
         * A list of resources to add to a scope.
         * </p>
         * 
         * @param resourcesToAdd
         *        A list of resources to add to a scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesToAdd(TargetResource... resourcesToAdd);

        /**
         * <p>
         * A list of resources to add to a scope.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.TargetResource.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.TargetResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.TargetResource.Builder#build()} is called
         * immediately and its result is passed to {@link #resourcesToAdd(List<TargetResource>)}.
         * 
         * @param resourcesToAdd
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkflowmonitor.model.TargetResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcesToAdd(java.util.Collection<TargetResource>)
         */
        Builder resourcesToAdd(Consumer<TargetResource.Builder>... resourcesToAdd);

        /**
         * <p>
         * A list of resources to delete from a scope.
         * </p>
         * 
         * @param resourcesToDelete
         *        A list of resources to delete from a scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesToDelete(Collection<TargetResource> resourcesToDelete);

        /**
         * <p>
         * A list of resources to delete from a scope.
         * </p>
         * 
         * @param resourcesToDelete
         *        A list of resources to delete from a scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesToDelete(TargetResource... resourcesToDelete);

        /**
         * <p>
         * A list of resources to delete from a scope.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.TargetResource.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.TargetResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.TargetResource.Builder#build()} is called
         * immediately and its result is passed to {@link #resourcesToDelete(List<TargetResource>)}.
         * 
         * @param resourcesToDelete
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkflowmonitor.model.TargetResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcesToDelete(java.util.Collection<TargetResource>)
         */
        Builder resourcesToDelete(Consumer<TargetResource.Builder>... resourcesToDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFlowMonitorRequest.BuilderImpl implements Builder {
        private String scopeId;

        private List<TargetResource> resourcesToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<TargetResource> resourcesToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScopeRequest model) {
            super(model);
            scopeId(model.scopeId);
            resourcesToAdd(model.resourcesToAdd);
            resourcesToDelete(model.resourcesToDelete);
        }

        public final String getScopeId() {
            return scopeId;
        }

        public final void setScopeId(String scopeId) {
            this.scopeId = scopeId;
        }

        @Override
        public final Builder scopeId(String scopeId) {
            this.scopeId = scopeId;
            return this;
        }

        public final List<TargetResource.Builder> getResourcesToAdd() {
            List<TargetResource.Builder> result = UpdateScopeInputResourcesToAddListCopier.copyToBuilder(this.resourcesToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourcesToAdd(Collection<TargetResource.BuilderImpl> resourcesToAdd) {
            this.resourcesToAdd = UpdateScopeInputResourcesToAddListCopier.copyFromBuilder(resourcesToAdd);
        }

        @Override
        public final Builder resourcesToAdd(Collection<TargetResource> resourcesToAdd) {
            this.resourcesToAdd = UpdateScopeInputResourcesToAddListCopier.copy(resourcesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesToAdd(TargetResource... resourcesToAdd) {
            resourcesToAdd(Arrays.asList(resourcesToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesToAdd(Consumer<TargetResource.Builder>... resourcesToAdd) {
            resourcesToAdd(Stream.of(resourcesToAdd).map(c -> TargetResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<TargetResource.Builder> getResourcesToDelete() {
            List<TargetResource.Builder> result = UpdateScopeInputResourcesToDeleteListCopier
                    .copyToBuilder(this.resourcesToDelete);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourcesToDelete(Collection<TargetResource.BuilderImpl> resourcesToDelete) {
            this.resourcesToDelete = UpdateScopeInputResourcesToDeleteListCopier.copyFromBuilder(resourcesToDelete);
        }

        @Override
        public final Builder resourcesToDelete(Collection<TargetResource> resourcesToDelete) {
            this.resourcesToDelete = UpdateScopeInputResourcesToDeleteListCopier.copy(resourcesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesToDelete(TargetResource... resourcesToDelete) {
            resourcesToDelete(Arrays.asList(resourcesToDelete));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesToDelete(Consumer<TargetResource.Builder>... resourcesToDelete) {
            resourcesToDelete(Stream.of(resourcesToDelete).map(c -> TargetResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateScopeRequest build() {
            return new UpdateScopeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
