/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A section of the network that a network flow has traveled through.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TraversedComponent implements SdkPojo, Serializable,
        ToCopyableBuilder<TraversedComponent.Builder, TraversedComponent> {
    private static final SdkField<String> COMPONENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentId").getter(getter(TraversedComponent::componentId)).setter(setter(Builder::componentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentId").build()).build();

    private static final SdkField<String> COMPONENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentType").getter(getter(TraversedComponent::componentType)).setter(setter(Builder::componentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentType").build()).build();

    private static final SdkField<String> COMPONENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentArn").getter(getter(TraversedComponent::componentArn)).setter(setter(Builder::componentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentArn").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(TraversedComponent::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_ID_FIELD,
            COMPONENT_TYPE_FIELD, COMPONENT_ARN_FIELD, SERVICE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String componentId;

    private final String componentType;

    private final String componentArn;

    private final String serviceName;

    private TraversedComponent(BuilderImpl builder) {
        this.componentId = builder.componentId;
        this.componentType = builder.componentType;
        this.componentArn = builder.componentArn;
        this.serviceName = builder.serviceName;
    }

    /**
     * <p>
     * The identifier for the traversed component.
     * </p>
     * 
     * @return The identifier for the traversed component.
     */
    public final String componentId() {
        return componentId;
    }

    /**
     * <p>
     * The type of component that was traversed.
     * </p>
     * 
     * @return The type of component that was traversed.
     */
    public final String componentType() {
        return componentType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a traversed component.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a traversed component.
     */
    public final String componentArn() {
        return componentArn;
    }

    /**
     * <p>
     * The service name for the traversed component.
     * </p>
     * 
     * @return The service name for the traversed component.
     */
    public final String serviceName() {
        return serviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentId());
        hashCode = 31 * hashCode + Objects.hashCode(componentType());
        hashCode = 31 * hashCode + Objects.hashCode(componentArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TraversedComponent)) {
            return false;
        }
        TraversedComponent other = (TraversedComponent) obj;
        return Objects.equals(componentId(), other.componentId()) && Objects.equals(componentType(), other.componentType())
                && Objects.equals(componentArn(), other.componentArn()) && Objects.equals(serviceName(), other.serviceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TraversedComponent").add("ComponentId", componentId()).add("ComponentType", componentType())
                .add("ComponentArn", componentArn()).add("ServiceName", serviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentId":
            return Optional.ofNullable(clazz.cast(componentId()));
        case "componentType":
            return Optional.ofNullable(clazz.cast(componentType()));
        case "componentArn":
            return Optional.ofNullable(clazz.cast(componentArn()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("componentId", COMPONENT_ID_FIELD);
        map.put("componentType", COMPONENT_TYPE_FIELD);
        map.put("componentArn", COMPONENT_ARN_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TraversedComponent, T> g) {
        return obj -> g.apply((TraversedComponent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TraversedComponent> {
        /**
         * <p>
         * The identifier for the traversed component.
         * </p>
         * 
         * @param componentId
         *        The identifier for the traversed component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentId(String componentId);

        /**
         * <p>
         * The type of component that was traversed.
         * </p>
         * 
         * @param componentType
         *        The type of component that was traversed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentType(String componentType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a traversed component.
         * </p>
         * 
         * @param componentArn
         *        The Amazon Resource Name (ARN) of a traversed component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentArn(String componentArn);

        /**
         * <p>
         * The service name for the traversed component.
         * </p>
         * 
         * @param serviceName
         *        The service name for the traversed component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);
    }

    static final class BuilderImpl implements Builder {
        private String componentId;

        private String componentType;

        private String componentArn;

        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(TraversedComponent model) {
            componentId(model.componentId);
            componentType(model.componentType);
            componentArn(model.componentArn);
            serviceName(model.serviceName);
        }

        public final String getComponentId() {
            return componentId;
        }

        public final void setComponentId(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public final Builder componentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        public final String getComponentType() {
            return componentType;
        }

        public final void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        @Override
        public final Builder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        public final String getComponentArn() {
            return componentArn;
        }

        public final void setComponentArn(String componentArn) {
            this.componentArn = componentArn;
        }

        @Override
        public final Builder componentArn(String componentArn) {
            this.componentArn = componentArn;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public TraversedComponent build() {
            return new TraversedComponent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
