/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A target identifier is a pair of identifying information for a scope that is included in a target. A target
 * identifier is made up of a target ID and a target type. Currently the target ID is always an account ID and the
 * target type is always ACCOUNT.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetIdentifier.Builder, TargetIdentifier> {
    private static final SdkField<TargetId> TARGET_ID_FIELD = SdkField.<TargetId> builder(MarshallingType.SDK_POJO)
            .memberName("targetId").getter(getter(TargetIdentifier::targetId)).setter(setter(Builder::targetId))
            .constructor(TargetId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetId").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetType").getter(getter(TargetIdentifier::targetTypeAsString)).setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ID_FIELD,
            TARGET_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TargetId targetId;

    private final String targetType;

    private TargetIdentifier(BuilderImpl builder) {
        this.targetId = builder.targetId;
        this.targetType = builder.targetType;
    }

    /**
     * <p>
     * The identifier for a target, which is currently always an account ID .
     * </p>
     * 
     * @return The identifier for a target, which is currently always an account ID .
     */
    public final TargetId targetId() {
        return targetId;
    }

    /**
     * <p>
     * The type of a target. A target type is currently always <code>ACCOUNT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of a target. A target type is currently always <code>ACCOUNT</code>.
     * @see TargetType
     */
    public final TargetType targetType() {
        return TargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The type of a target. A target type is currently always <code>ACCOUNT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of a target. A target type is currently always <code>ACCOUNT</code>.
     * @see TargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetIdentifier)) {
            return false;
        }
        TargetIdentifier other = (TargetIdentifier) obj;
        return Objects.equals(targetId(), other.targetId()) && Objects.equals(targetTypeAsString(), other.targetTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetIdentifier").add("TargetId", targetId()).add("TargetType", targetTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "targetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("targetId", TARGET_ID_FIELD);
        map.put("targetType", TARGET_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetIdentifier, T> g) {
        return obj -> g.apply((TargetIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetIdentifier> {
        /**
         * <p>
         * The identifier for a target, which is currently always an account ID .
         * </p>
         * 
         * @param targetId
         *        The identifier for a target, which is currently always an account ID .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(TargetId targetId);

        /**
         * <p>
         * The identifier for a target, which is currently always an account ID .
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetId.Builder} avoiding the need to
         * create one manually via {@link TargetId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetId.Builder#build()} is called immediately and its result is
         * passed to {@link #targetId(TargetId)}.
         * 
         * @param targetId
         *        a consumer that will call methods on {@link TargetId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetId(TargetId)
         */
        default Builder targetId(Consumer<TargetId.Builder> targetId) {
            return targetId(TargetId.builder().applyMutation(targetId).build());
        }

        /**
         * <p>
         * The type of a target. A target type is currently always <code>ACCOUNT</code>.
         * </p>
         * 
         * @param targetType
         *        The type of a target. A target type is currently always <code>ACCOUNT</code>.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The type of a target. A target type is currently always <code>ACCOUNT</code>.
         * </p>
         * 
         * @param targetType
         *        The type of a target. A target type is currently always <code>ACCOUNT</code>.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(TargetType targetType);
    }

    static final class BuilderImpl implements Builder {
        private TargetId targetId;

        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetIdentifier model) {
            targetId(model.targetId);
            targetType(model.targetType);
        }

        public final TargetId.Builder getTargetId() {
            return targetId != null ? targetId.toBuilder() : null;
        }

        public final void setTargetId(TargetId.BuilderImpl targetId) {
            this.targetId = targetId != null ? targetId.build() : null;
        }

        @Override
        public final Builder targetId(TargetId targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        @Override
        public TargetIdentifier build() {
            return new TargetIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
