/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of information for a top contributor network flow in a monitor. In a monitor, Network Flow Monitor returns
 * information about the network flows for top contributors for each metric. Top contributors are network flows with the
 * top values for each metric type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitorTopContributorsRow implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitorTopContributorsRow.Builder, MonitorTopContributorsRow> {
    private static final SdkField<String> LOCAL_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localIp").getter(getter(MonitorTopContributorsRow::localIp)).setter(setter(Builder::localIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localIp").build()).build();

    private static final SdkField<String> SNAT_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("snatIp")
            .getter(getter(MonitorTopContributorsRow::snatIp)).setter(setter(Builder::snatIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snatIp").build()).build();

    private static final SdkField<String> LOCAL_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localInstanceId").getter(getter(MonitorTopContributorsRow::localInstanceId))
            .setter(setter(Builder::localInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localInstanceId").build()).build();

    private static final SdkField<String> LOCAL_VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localVpcId").getter(getter(MonitorTopContributorsRow::localVpcId)).setter(setter(Builder::localVpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localVpcId").build()).build();

    private static final SdkField<String> LOCAL_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localRegion").getter(getter(MonitorTopContributorsRow::localRegion))
            .setter(setter(Builder::localRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localRegion").build()).build();

    private static final SdkField<String> LOCAL_AZ_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localAz").getter(getter(MonitorTopContributorsRow::localAz)).setter(setter(Builder::localAz))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localAz").build()).build();

    private static final SdkField<String> LOCAL_SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localSubnetId").getter(getter(MonitorTopContributorsRow::localSubnetId))
            .setter(setter(Builder::localSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localSubnetId").build()).build();

    private static final SdkField<Integer> TARGET_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("targetPort").getter(getter(MonitorTopContributorsRow::targetPort)).setter(setter(Builder::targetPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetPort").build()).build();

    private static final SdkField<String> DESTINATION_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationCategory").getter(getter(MonitorTopContributorsRow::destinationCategoryAsString))
            .setter(setter(Builder::destinationCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCategory").build())
            .build();

    private static final SdkField<String> REMOTE_VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remoteVpcId").getter(getter(MonitorTopContributorsRow::remoteVpcId))
            .setter(setter(Builder::remoteVpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteVpcId").build()).build();

    private static final SdkField<String> REMOTE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remoteRegion").getter(getter(MonitorTopContributorsRow::remoteRegion))
            .setter(setter(Builder::remoteRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteRegion").build()).build();

    private static final SdkField<String> REMOTE_AZ_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remoteAz").getter(getter(MonitorTopContributorsRow::remoteAz)).setter(setter(Builder::remoteAz))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAz").build()).build();

    private static final SdkField<String> REMOTE_SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remoteSubnetId").getter(getter(MonitorTopContributorsRow::remoteSubnetId))
            .setter(setter(Builder::remoteSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteSubnetId").build()).build();

    private static final SdkField<String> REMOTE_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remoteInstanceId").getter(getter(MonitorTopContributorsRow::remoteInstanceId))
            .setter(setter(Builder::remoteInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteInstanceId").build()).build();

    private static final SdkField<String> REMOTE_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remoteIp").getter(getter(MonitorTopContributorsRow::remoteIp)).setter(setter(Builder::remoteIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteIp").build()).build();

    private static final SdkField<String> DNAT_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("dnatIp")
            .getter(getter(MonitorTopContributorsRow::dnatIp)).setter(setter(Builder::dnatIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnatIp").build()).build();

    private static final SdkField<Long> VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("value")
            .getter(getter(MonitorTopContributorsRow::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<List<TraversedComponent>> TRAVERSED_CONSTRUCTS_FIELD = SdkField
            .<List<TraversedComponent>> builder(MarshallingType.LIST)
            .memberName("traversedConstructs")
            .getter(getter(MonitorTopContributorsRow::traversedConstructs))
            .setter(setter(Builder::traversedConstructs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traversedConstructs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TraversedComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(TraversedComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<KubernetesMetadata> KUBERNETES_METADATA_FIELD = SdkField
            .<KubernetesMetadata> builder(MarshallingType.SDK_POJO).memberName("kubernetesMetadata")
            .getter(getter(MonitorTopContributorsRow::kubernetesMetadata)).setter(setter(Builder::kubernetesMetadata))
            .constructor(KubernetesMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesMetadata").build())
            .build();

    private static final SdkField<String> LOCAL_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localInstanceArn").getter(getter(MonitorTopContributorsRow::localInstanceArn))
            .setter(setter(Builder::localInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localInstanceArn").build()).build();

    private static final SdkField<String> LOCAL_SUBNET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localSubnetArn").getter(getter(MonitorTopContributorsRow::localSubnetArn))
            .setter(setter(Builder::localSubnetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localSubnetArn").build()).build();

    private static final SdkField<String> LOCAL_VPC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localVpcArn").getter(getter(MonitorTopContributorsRow::localVpcArn))
            .setter(setter(Builder::localVpcArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localVpcArn").build()).build();

    private static final SdkField<String> REMOTE_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remoteInstanceArn").getter(getter(MonitorTopContributorsRow::remoteInstanceArn))
            .setter(setter(Builder::remoteInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteInstanceArn").build()).build();

    private static final SdkField<String> REMOTE_SUBNET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remoteSubnetArn").getter(getter(MonitorTopContributorsRow::remoteSubnetArn))
            .setter(setter(Builder::remoteSubnetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteSubnetArn").build()).build();

    private static final SdkField<String> REMOTE_VPC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remoteVpcArn").getter(getter(MonitorTopContributorsRow::remoteVpcArn))
            .setter(setter(Builder::remoteVpcArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteVpcArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_IP_FIELD, SNAT_IP_FIELD,
            LOCAL_INSTANCE_ID_FIELD, LOCAL_VPC_ID_FIELD, LOCAL_REGION_FIELD, LOCAL_AZ_FIELD, LOCAL_SUBNET_ID_FIELD,
            TARGET_PORT_FIELD, DESTINATION_CATEGORY_FIELD, REMOTE_VPC_ID_FIELD, REMOTE_REGION_FIELD, REMOTE_AZ_FIELD,
            REMOTE_SUBNET_ID_FIELD, REMOTE_INSTANCE_ID_FIELD, REMOTE_IP_FIELD, DNAT_IP_FIELD, VALUE_FIELD,
            TRAVERSED_CONSTRUCTS_FIELD, KUBERNETES_METADATA_FIELD, LOCAL_INSTANCE_ARN_FIELD, LOCAL_SUBNET_ARN_FIELD,
            LOCAL_VPC_ARN_FIELD, REMOTE_INSTANCE_ARN_FIELD, REMOTE_SUBNET_ARN_FIELD, REMOTE_VPC_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String localIp;

    private final String snatIp;

    private final String localInstanceId;

    private final String localVpcId;

    private final String localRegion;

    private final String localAz;

    private final String localSubnetId;

    private final Integer targetPort;

    private final String destinationCategory;

    private final String remoteVpcId;

    private final String remoteRegion;

    private final String remoteAz;

    private final String remoteSubnetId;

    private final String remoteInstanceId;

    private final String remoteIp;

    private final String dnatIp;

    private final Long value;

    private final List<TraversedComponent> traversedConstructs;

    private final KubernetesMetadata kubernetesMetadata;

    private final String localInstanceArn;

    private final String localSubnetArn;

    private final String localVpcArn;

    private final String remoteInstanceArn;

    private final String remoteSubnetArn;

    private final String remoteVpcArn;

    private MonitorTopContributorsRow(BuilderImpl builder) {
        this.localIp = builder.localIp;
        this.snatIp = builder.snatIp;
        this.localInstanceId = builder.localInstanceId;
        this.localVpcId = builder.localVpcId;
        this.localRegion = builder.localRegion;
        this.localAz = builder.localAz;
        this.localSubnetId = builder.localSubnetId;
        this.targetPort = builder.targetPort;
        this.destinationCategory = builder.destinationCategory;
        this.remoteVpcId = builder.remoteVpcId;
        this.remoteRegion = builder.remoteRegion;
        this.remoteAz = builder.remoteAz;
        this.remoteSubnetId = builder.remoteSubnetId;
        this.remoteInstanceId = builder.remoteInstanceId;
        this.remoteIp = builder.remoteIp;
        this.dnatIp = builder.dnatIp;
        this.value = builder.value;
        this.traversedConstructs = builder.traversedConstructs;
        this.kubernetesMetadata = builder.kubernetesMetadata;
        this.localInstanceArn = builder.localInstanceArn;
        this.localSubnetArn = builder.localSubnetArn;
        this.localVpcArn = builder.localVpcArn;
        this.remoteInstanceArn = builder.remoteInstanceArn;
        this.remoteSubnetArn = builder.remoteSubnetArn;
        this.remoteVpcArn = builder.remoteVpcArn;
    }

    /**
     * <p>
     * The IP address of the local resource for a top contributor network flow.
     * </p>
     * 
     * @return The IP address of the local resource for a top contributor network flow.
     */
    public final String localIp() {
        return localIp;
    }

    /**
     * <p>
     * The secure network address translation (SNAT) IP address for a top contributor network flow.
     * </p>
     * 
     * @return The secure network address translation (SNAT) IP address for a top contributor network flow.
     */
    public final String snatIp() {
        return snatIp;
    }

    /**
     * <p>
     * The instance identifier for the local resource for a top contributor network flow.
     * </p>
     * 
     * @return The instance identifier for the local resource for a top contributor network flow.
     */
    public final String localInstanceId() {
        return localInstanceId;
    }

    /**
     * <p>
     * The VPC ID for a top contributor network flow for the local resource.
     * </p>
     * 
     * @return The VPC ID for a top contributor network flow for the local resource.
     */
    public final String localVpcId() {
        return localVpcId;
    }

    /**
     * <p>
     * The Amazon Web Services Region for the local resource for a top contributor network flow.
     * </p>
     * 
     * @return The Amazon Web Services Region for the local resource for a top contributor network flow.
     */
    public final String localRegion() {
        return localRegion;
    }

    /**
     * <p>
     * The Availability Zone for the local resource for a top contributor network flow.
     * </p>
     * 
     * @return The Availability Zone for the local resource for a top contributor network flow.
     */
    public final String localAz() {
        return localAz;
    }

    /**
     * <p>
     * The subnet ID for the local resource for a top contributor network flow.
     * </p>
     * 
     * @return The subnet ID for the local resource for a top contributor network flow.
     */
    public final String localSubnetId() {
        return localSubnetId;
    }

    /**
     * <p>
     * The target port.
     * </p>
     * 
     * @return The target port.
     */
    public final Integer targetPort() {
        return targetPort;
    }

    /**
     * <p>
     * The destination category for a top contributors row. Destination categories can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INTRA_AZ</code>: Top contributor network flows within a single Availability Zone
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTER_AZ</code>: Top contributor network flows between Availability Zones
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTER_REGION</code>: Top contributor network flows between Regions (to the edge of another Region)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTER_VPC</code>: Top contributor network flows between VPCs
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_SERVICES</code>: Top contributor network flows to or from Amazon Web Services services
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNCLASSIFIED</code>: Top contributor network flows that do not have a bucket classification
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #destinationCategory} will return {@link DestinationCategory#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #destinationCategoryAsString}.
     * </p>
     * 
     * @return The destination category for a top contributors row. Destination categories can be one of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INTRA_AZ</code>: Top contributor network flows within a single Availability Zone
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTER_AZ</code>: Top contributor network flows between Availability Zones
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTER_REGION</code>: Top contributor network flows between Regions (to the edge of another Region)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTER_VPC</code>: Top contributor network flows between VPCs
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_SERVICES</code>: Top contributor network flows to or from Amazon Web Services services
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNCLASSIFIED</code>: Top contributor network flows that do not have a bucket classification
     *         </p>
     *         </li>
     * @see DestinationCategory
     */
    public final DestinationCategory destinationCategory() {
        return DestinationCategory.fromValue(destinationCategory);
    }

    /**
     * <p>
     * The destination category for a top contributors row. Destination categories can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INTRA_AZ</code>: Top contributor network flows within a single Availability Zone
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTER_AZ</code>: Top contributor network flows between Availability Zones
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTER_REGION</code>: Top contributor network flows between Regions (to the edge of another Region)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTER_VPC</code>: Top contributor network flows between VPCs
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_SERVICES</code>: Top contributor network flows to or from Amazon Web Services services
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNCLASSIFIED</code>: Top contributor network flows that do not have a bucket classification
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #destinationCategory} will return {@link DestinationCategory#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #destinationCategoryAsString}.
     * </p>
     * 
     * @return The destination category for a top contributors row. Destination categories can be one of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INTRA_AZ</code>: Top contributor network flows within a single Availability Zone
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTER_AZ</code>: Top contributor network flows between Availability Zones
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTER_REGION</code>: Top contributor network flows between Regions (to the edge of another Region)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTER_VPC</code>: Top contributor network flows between VPCs
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_SERVICES</code>: Top contributor network flows to or from Amazon Web Services services
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNCLASSIFIED</code>: Top contributor network flows that do not have a bucket classification
     *         </p>
     *         </li>
     * @see DestinationCategory
     */
    public final String destinationCategoryAsString() {
        return destinationCategory;
    }

    /**
     * <p>
     * The VPC ID for a top contributor network flow for the remote resource.
     * </p>
     * 
     * @return The VPC ID for a top contributor network flow for the remote resource.
     */
    public final String remoteVpcId() {
        return remoteVpcId;
    }

    /**
     * <p>
     * The Amazon Web Services Region for the remote resource for a top contributor network flow.
     * </p>
     * 
     * @return The Amazon Web Services Region for the remote resource for a top contributor network flow.
     */
    public final String remoteRegion() {
        return remoteRegion;
    }

    /**
     * <p>
     * The Availability Zone for the remote resource for a top contributor network flow.
     * </p>
     * 
     * @return The Availability Zone for the remote resource for a top contributor network flow.
     */
    public final String remoteAz() {
        return remoteAz;
    }

    /**
     * <p>
     * The subnet ID for the remote resource for a top contributor network flow.
     * </p>
     * 
     * @return The subnet ID for the remote resource for a top contributor network flow.
     */
    public final String remoteSubnetId() {
        return remoteSubnetId;
    }

    /**
     * <p>
     * The instance identifier for the remote resource for a top contributor network flow.
     * </p>
     * 
     * @return The instance identifier for the remote resource for a top contributor network flow.
     */
    public final String remoteInstanceId() {
        return remoteInstanceId;
    }

    /**
     * <p>
     * The IP address of the remote resource for a top contributor network flow.
     * </p>
     * 
     * @return The IP address of the remote resource for a top contributor network flow.
     */
    public final String remoteIp() {
        return remoteIp;
    }

    /**
     * <p>
     * The destination network address translation (DNAT) IP address for a top contributor network flow.
     * </p>
     * 
     * @return The destination network address translation (DNAT) IP address for a top contributor network flow.
     */
    public final String dnatIp() {
        return dnatIp;
    }

    /**
     * <p>
     * The value of the metric for a top contributor network flow.
     * </p>
     * 
     * @return The value of the metric for a top contributor network flow.
     */
    public final Long value() {
        return value;
    }

    /**
     * For responses, this returns true if the service returned a value for the TraversedConstructs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTraversedConstructs() {
        return traversedConstructs != null && !(traversedConstructs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The constructs traversed by a network flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTraversedConstructs} method.
     * </p>
     * 
     * @return The constructs traversed by a network flow.
     */
    public final List<TraversedComponent> traversedConstructs() {
        return traversedConstructs;
    }

    /**
     * <p>
     * Meta data about Kubernetes resources.
     * </p>
     * 
     * @return Meta data about Kubernetes resources.
     */
    public final KubernetesMetadata kubernetesMetadata() {
        return kubernetesMetadata;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a local resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a local resource.
     */
    public final String localInstanceArn() {
        return localInstanceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a local subnet.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a local subnet.
     */
    public final String localSubnetArn() {
        return localSubnetArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a local VPC.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a local VPC.
     */
    public final String localVpcArn() {
        return localVpcArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a remote resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a remote resource.
     */
    public final String remoteInstanceArn() {
        return remoteInstanceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a remote subnet.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a remote subnet.
     */
    public final String remoteSubnetArn() {
        return remoteSubnetArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a remote VPC.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a remote VPC.
     */
    public final String remoteVpcArn() {
        return remoteVpcArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localIp());
        hashCode = 31 * hashCode + Objects.hashCode(snatIp());
        hashCode = 31 * hashCode + Objects.hashCode(localInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(localVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(localRegion());
        hashCode = 31 * hashCode + Objects.hashCode(localAz());
        hashCode = 31 * hashCode + Objects.hashCode(localSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetPort());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCategoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(remoteVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(remoteRegion());
        hashCode = 31 * hashCode + Objects.hashCode(remoteAz());
        hashCode = 31 * hashCode + Objects.hashCode(remoteSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(remoteInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(remoteIp());
        hashCode = 31 * hashCode + Objects.hashCode(dnatIp());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(hasTraversedConstructs() ? traversedConstructs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kubernetesMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(localInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(localSubnetArn());
        hashCode = 31 * hashCode + Objects.hashCode(localVpcArn());
        hashCode = 31 * hashCode + Objects.hashCode(remoteInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(remoteSubnetArn());
        hashCode = 31 * hashCode + Objects.hashCode(remoteVpcArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorTopContributorsRow)) {
            return false;
        }
        MonitorTopContributorsRow other = (MonitorTopContributorsRow) obj;
        return Objects.equals(localIp(), other.localIp()) && Objects.equals(snatIp(), other.snatIp())
                && Objects.equals(localInstanceId(), other.localInstanceId()) && Objects.equals(localVpcId(), other.localVpcId())
                && Objects.equals(localRegion(), other.localRegion()) && Objects.equals(localAz(), other.localAz())
                && Objects.equals(localSubnetId(), other.localSubnetId()) && Objects.equals(targetPort(), other.targetPort())
                && Objects.equals(destinationCategoryAsString(), other.destinationCategoryAsString())
                && Objects.equals(remoteVpcId(), other.remoteVpcId()) && Objects.equals(remoteRegion(), other.remoteRegion())
                && Objects.equals(remoteAz(), other.remoteAz()) && Objects.equals(remoteSubnetId(), other.remoteSubnetId())
                && Objects.equals(remoteInstanceId(), other.remoteInstanceId()) && Objects.equals(remoteIp(), other.remoteIp())
                && Objects.equals(dnatIp(), other.dnatIp()) && Objects.equals(value(), other.value())
                && hasTraversedConstructs() == other.hasTraversedConstructs()
                && Objects.equals(traversedConstructs(), other.traversedConstructs())
                && Objects.equals(kubernetesMetadata(), other.kubernetesMetadata())
                && Objects.equals(localInstanceArn(), other.localInstanceArn())
                && Objects.equals(localSubnetArn(), other.localSubnetArn()) && Objects.equals(localVpcArn(), other.localVpcArn())
                && Objects.equals(remoteInstanceArn(), other.remoteInstanceArn())
                && Objects.equals(remoteSubnetArn(), other.remoteSubnetArn())
                && Objects.equals(remoteVpcArn(), other.remoteVpcArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitorTopContributorsRow").add("LocalIp", localIp()).add("SnatIp", snatIp())
                .add("LocalInstanceId", localInstanceId()).add("LocalVpcId", localVpcId()).add("LocalRegion", localRegion())
                .add("LocalAz", localAz()).add("LocalSubnetId", localSubnetId()).add("TargetPort", targetPort())
                .add("DestinationCategory", destinationCategoryAsString()).add("RemoteVpcId", remoteVpcId())
                .add("RemoteRegion", remoteRegion()).add("RemoteAz", remoteAz()).add("RemoteSubnetId", remoteSubnetId())
                .add("RemoteInstanceId", remoteInstanceId()).add("RemoteIp", remoteIp()).add("DnatIp", dnatIp())
                .add("Value", value()).add("TraversedConstructs", hasTraversedConstructs() ? traversedConstructs() : null)
                .add("KubernetesMetadata", kubernetesMetadata()).add("LocalInstanceArn", localInstanceArn())
                .add("LocalSubnetArn", localSubnetArn()).add("LocalVpcArn", localVpcArn())
                .add("RemoteInstanceArn", remoteInstanceArn()).add("RemoteSubnetArn", remoteSubnetArn())
                .add("RemoteVpcArn", remoteVpcArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "localIp":
            return Optional.ofNullable(clazz.cast(localIp()));
        case "snatIp":
            return Optional.ofNullable(clazz.cast(snatIp()));
        case "localInstanceId":
            return Optional.ofNullable(clazz.cast(localInstanceId()));
        case "localVpcId":
            return Optional.ofNullable(clazz.cast(localVpcId()));
        case "localRegion":
            return Optional.ofNullable(clazz.cast(localRegion()));
        case "localAz":
            return Optional.ofNullable(clazz.cast(localAz()));
        case "localSubnetId":
            return Optional.ofNullable(clazz.cast(localSubnetId()));
        case "targetPort":
            return Optional.ofNullable(clazz.cast(targetPort()));
        case "destinationCategory":
            return Optional.ofNullable(clazz.cast(destinationCategoryAsString()));
        case "remoteVpcId":
            return Optional.ofNullable(clazz.cast(remoteVpcId()));
        case "remoteRegion":
            return Optional.ofNullable(clazz.cast(remoteRegion()));
        case "remoteAz":
            return Optional.ofNullable(clazz.cast(remoteAz()));
        case "remoteSubnetId":
            return Optional.ofNullable(clazz.cast(remoteSubnetId()));
        case "remoteInstanceId":
            return Optional.ofNullable(clazz.cast(remoteInstanceId()));
        case "remoteIp":
            return Optional.ofNullable(clazz.cast(remoteIp()));
        case "dnatIp":
            return Optional.ofNullable(clazz.cast(dnatIp()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "traversedConstructs":
            return Optional.ofNullable(clazz.cast(traversedConstructs()));
        case "kubernetesMetadata":
            return Optional.ofNullable(clazz.cast(kubernetesMetadata()));
        case "localInstanceArn":
            return Optional.ofNullable(clazz.cast(localInstanceArn()));
        case "localSubnetArn":
            return Optional.ofNullable(clazz.cast(localSubnetArn()));
        case "localVpcArn":
            return Optional.ofNullable(clazz.cast(localVpcArn()));
        case "remoteInstanceArn":
            return Optional.ofNullable(clazz.cast(remoteInstanceArn()));
        case "remoteSubnetArn":
            return Optional.ofNullable(clazz.cast(remoteSubnetArn()));
        case "remoteVpcArn":
            return Optional.ofNullable(clazz.cast(remoteVpcArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("localIp", LOCAL_IP_FIELD);
        map.put("snatIp", SNAT_IP_FIELD);
        map.put("localInstanceId", LOCAL_INSTANCE_ID_FIELD);
        map.put("localVpcId", LOCAL_VPC_ID_FIELD);
        map.put("localRegion", LOCAL_REGION_FIELD);
        map.put("localAz", LOCAL_AZ_FIELD);
        map.put("localSubnetId", LOCAL_SUBNET_ID_FIELD);
        map.put("targetPort", TARGET_PORT_FIELD);
        map.put("destinationCategory", DESTINATION_CATEGORY_FIELD);
        map.put("remoteVpcId", REMOTE_VPC_ID_FIELD);
        map.put("remoteRegion", REMOTE_REGION_FIELD);
        map.put("remoteAz", REMOTE_AZ_FIELD);
        map.put("remoteSubnetId", REMOTE_SUBNET_ID_FIELD);
        map.put("remoteInstanceId", REMOTE_INSTANCE_ID_FIELD);
        map.put("remoteIp", REMOTE_IP_FIELD);
        map.put("dnatIp", DNAT_IP_FIELD);
        map.put("value", VALUE_FIELD);
        map.put("traversedConstructs", TRAVERSED_CONSTRUCTS_FIELD);
        map.put("kubernetesMetadata", KUBERNETES_METADATA_FIELD);
        map.put("localInstanceArn", LOCAL_INSTANCE_ARN_FIELD);
        map.put("localSubnetArn", LOCAL_SUBNET_ARN_FIELD);
        map.put("localVpcArn", LOCAL_VPC_ARN_FIELD);
        map.put("remoteInstanceArn", REMOTE_INSTANCE_ARN_FIELD);
        map.put("remoteSubnetArn", REMOTE_SUBNET_ARN_FIELD);
        map.put("remoteVpcArn", REMOTE_VPC_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitorTopContributorsRow, T> g) {
        return obj -> g.apply((MonitorTopContributorsRow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitorTopContributorsRow> {
        /**
         * <p>
         * The IP address of the local resource for a top contributor network flow.
         * </p>
         * 
         * @param localIp
         *        The IP address of the local resource for a top contributor network flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localIp(String localIp);

        /**
         * <p>
         * The secure network address translation (SNAT) IP address for a top contributor network flow.
         * </p>
         * 
         * @param snatIp
         *        The secure network address translation (SNAT) IP address for a top contributor network flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snatIp(String snatIp);

        /**
         * <p>
         * The instance identifier for the local resource for a top contributor network flow.
         * </p>
         * 
         * @param localInstanceId
         *        The instance identifier for the local resource for a top contributor network flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localInstanceId(String localInstanceId);

        /**
         * <p>
         * The VPC ID for a top contributor network flow for the local resource.
         * </p>
         * 
         * @param localVpcId
         *        The VPC ID for a top contributor network flow for the local resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localVpcId(String localVpcId);

        /**
         * <p>
         * The Amazon Web Services Region for the local resource for a top contributor network flow.
         * </p>
         * 
         * @param localRegion
         *        The Amazon Web Services Region for the local resource for a top contributor network flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localRegion(String localRegion);

        /**
         * <p>
         * The Availability Zone for the local resource for a top contributor network flow.
         * </p>
         * 
         * @param localAz
         *        The Availability Zone for the local resource for a top contributor network flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localAz(String localAz);

        /**
         * <p>
         * The subnet ID for the local resource for a top contributor network flow.
         * </p>
         * 
         * @param localSubnetId
         *        The subnet ID for the local resource for a top contributor network flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSubnetId(String localSubnetId);

        /**
         * <p>
         * The target port.
         * </p>
         * 
         * @param targetPort
         *        The target port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetPort(Integer targetPort);

        /**
         * <p>
         * The destination category for a top contributors row. Destination categories can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INTRA_AZ</code>: Top contributor network flows within a single Availability Zone
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTER_AZ</code>: Top contributor network flows between Availability Zones
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTER_REGION</code>: Top contributor network flows between Regions (to the edge of another Region)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTER_VPC</code>: Top contributor network flows between VPCs
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_SERVICES</code>: Top contributor network flows to or from Amazon Web Services services
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNCLASSIFIED</code>: Top contributor network flows that do not have a bucket classification
         * </p>
         * </li>
         * </ul>
         * 
         * @param destinationCategory
         *        The destination category for a top contributors row. Destination categories can be one of the
         *        following: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INTRA_AZ</code>: Top contributor network flows within a single Availability Zone
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTER_AZ</code>: Top contributor network flows between Availability Zones
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTER_REGION</code>: Top contributor network flows between Regions (to the edge of another
         *        Region)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTER_VPC</code>: Top contributor network flows between VPCs
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_SERVICES</code>: Top contributor network flows to or from Amazon Web Services services
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNCLASSIFIED</code>: Top contributor network flows that do not have a bucket classification
         *        </p>
         *        </li>
         * @see DestinationCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationCategory
         */
        Builder destinationCategory(String destinationCategory);

        /**
         * <p>
         * The destination category for a top contributors row. Destination categories can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INTRA_AZ</code>: Top contributor network flows within a single Availability Zone
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTER_AZ</code>: Top contributor network flows between Availability Zones
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTER_REGION</code>: Top contributor network flows between Regions (to the edge of another Region)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTER_VPC</code>: Top contributor network flows between VPCs
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_SERVICES</code>: Top contributor network flows to or from Amazon Web Services services
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNCLASSIFIED</code>: Top contributor network flows that do not have a bucket classification
         * </p>
         * </li>
         * </ul>
         * 
         * @param destinationCategory
         *        The destination category for a top contributors row. Destination categories can be one of the
         *        following: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INTRA_AZ</code>: Top contributor network flows within a single Availability Zone
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTER_AZ</code>: Top contributor network flows between Availability Zones
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTER_REGION</code>: Top contributor network flows between Regions (to the edge of another
         *        Region)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTER_VPC</code>: Top contributor network flows between VPCs
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_SERVICES</code>: Top contributor network flows to or from Amazon Web Services services
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNCLASSIFIED</code>: Top contributor network flows that do not have a bucket classification
         *        </p>
         *        </li>
         * @see DestinationCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationCategory
         */
        Builder destinationCategory(DestinationCategory destinationCategory);

        /**
         * <p>
         * The VPC ID for a top contributor network flow for the remote resource.
         * </p>
         * 
         * @param remoteVpcId
         *        The VPC ID for a top contributor network flow for the remote resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteVpcId(String remoteVpcId);

        /**
         * <p>
         * The Amazon Web Services Region for the remote resource for a top contributor network flow.
         * </p>
         * 
         * @param remoteRegion
         *        The Amazon Web Services Region for the remote resource for a top contributor network flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteRegion(String remoteRegion);

        /**
         * <p>
         * The Availability Zone for the remote resource for a top contributor network flow.
         * </p>
         * 
         * @param remoteAz
         *        The Availability Zone for the remote resource for a top contributor network flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAz(String remoteAz);

        /**
         * <p>
         * The subnet ID for the remote resource for a top contributor network flow.
         * </p>
         * 
         * @param remoteSubnetId
         *        The subnet ID for the remote resource for a top contributor network flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteSubnetId(String remoteSubnetId);

        /**
         * <p>
         * The instance identifier for the remote resource for a top contributor network flow.
         * </p>
         * 
         * @param remoteInstanceId
         *        The instance identifier for the remote resource for a top contributor network flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteInstanceId(String remoteInstanceId);

        /**
         * <p>
         * The IP address of the remote resource for a top contributor network flow.
         * </p>
         * 
         * @param remoteIp
         *        The IP address of the remote resource for a top contributor network flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteIp(String remoteIp);

        /**
         * <p>
         * The destination network address translation (DNAT) IP address for a top contributor network flow.
         * </p>
         * 
         * @param dnatIp
         *        The destination network address translation (DNAT) IP address for a top contributor network flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnatIp(String dnatIp);

        /**
         * <p>
         * The value of the metric for a top contributor network flow.
         * </p>
         * 
         * @param value
         *        The value of the metric for a top contributor network flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Long value);

        /**
         * <p>
         * The constructs traversed by a network flow.
         * </p>
         * 
         * @param traversedConstructs
         *        The constructs traversed by a network flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traversedConstructs(Collection<TraversedComponent> traversedConstructs);

        /**
         * <p>
         * The constructs traversed by a network flow.
         * </p>
         * 
         * @param traversedConstructs
         *        The constructs traversed by a network flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traversedConstructs(TraversedComponent... traversedConstructs);

        /**
         * <p>
         * The constructs traversed by a network flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.TraversedComponent.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.TraversedComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.TraversedComponent.Builder#build()} is called
         * immediately and its result is passed to {@link #traversedConstructs(List<TraversedComponent>)}.
         * 
         * @param traversedConstructs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkflowmonitor.model.TraversedComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traversedConstructs(java.util.Collection<TraversedComponent>)
         */
        Builder traversedConstructs(Consumer<TraversedComponent.Builder>... traversedConstructs);

        /**
         * <p>
         * Meta data about Kubernetes resources.
         * </p>
         * 
         * @param kubernetesMetadata
         *        Meta data about Kubernetes resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesMetadata(KubernetesMetadata kubernetesMetadata);

        /**
         * <p>
         * Meta data about Kubernetes resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link KubernetesMetadata.Builder} avoiding the
         * need to create one manually via {@link KubernetesMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KubernetesMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #kubernetesMetadata(KubernetesMetadata)}.
         * 
         * @param kubernetesMetadata
         *        a consumer that will call methods on {@link KubernetesMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kubernetesMetadata(KubernetesMetadata)
         */
        default Builder kubernetesMetadata(Consumer<KubernetesMetadata.Builder> kubernetesMetadata) {
            return kubernetesMetadata(KubernetesMetadata.builder().applyMutation(kubernetesMetadata).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a local resource.
         * </p>
         * 
         * @param localInstanceArn
         *        The Amazon Resource Name (ARN) of a local resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localInstanceArn(String localInstanceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a local subnet.
         * </p>
         * 
         * @param localSubnetArn
         *        The Amazon Resource Name (ARN) of a local subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSubnetArn(String localSubnetArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a local VPC.
         * </p>
         * 
         * @param localVpcArn
         *        The Amazon Resource Name (ARN) of a local VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localVpcArn(String localVpcArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a remote resource.
         * </p>
         * 
         * @param remoteInstanceArn
         *        The Amazon Resource Name (ARN) of a remote resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteInstanceArn(String remoteInstanceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a remote subnet.
         * </p>
         * 
         * @param remoteSubnetArn
         *        The Amazon Resource Name (ARN) of a remote subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteSubnetArn(String remoteSubnetArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a remote VPC.
         * </p>
         * 
         * @param remoteVpcArn
         *        The Amazon Resource Name (ARN) of a remote VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteVpcArn(String remoteVpcArn);
    }

    static final class BuilderImpl implements Builder {
        private String localIp;

        private String snatIp;

        private String localInstanceId;

        private String localVpcId;

        private String localRegion;

        private String localAz;

        private String localSubnetId;

        private Integer targetPort;

        private String destinationCategory;

        private String remoteVpcId;

        private String remoteRegion;

        private String remoteAz;

        private String remoteSubnetId;

        private String remoteInstanceId;

        private String remoteIp;

        private String dnatIp;

        private Long value;

        private List<TraversedComponent> traversedConstructs = DefaultSdkAutoConstructList.getInstance();

        private KubernetesMetadata kubernetesMetadata;

        private String localInstanceArn;

        private String localSubnetArn;

        private String localVpcArn;

        private String remoteInstanceArn;

        private String remoteSubnetArn;

        private String remoteVpcArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitorTopContributorsRow model) {
            localIp(model.localIp);
            snatIp(model.snatIp);
            localInstanceId(model.localInstanceId);
            localVpcId(model.localVpcId);
            localRegion(model.localRegion);
            localAz(model.localAz);
            localSubnetId(model.localSubnetId);
            targetPort(model.targetPort);
            destinationCategory(model.destinationCategory);
            remoteVpcId(model.remoteVpcId);
            remoteRegion(model.remoteRegion);
            remoteAz(model.remoteAz);
            remoteSubnetId(model.remoteSubnetId);
            remoteInstanceId(model.remoteInstanceId);
            remoteIp(model.remoteIp);
            dnatIp(model.dnatIp);
            value(model.value);
            traversedConstructs(model.traversedConstructs);
            kubernetesMetadata(model.kubernetesMetadata);
            localInstanceArn(model.localInstanceArn);
            localSubnetArn(model.localSubnetArn);
            localVpcArn(model.localVpcArn);
            remoteInstanceArn(model.remoteInstanceArn);
            remoteSubnetArn(model.remoteSubnetArn);
            remoteVpcArn(model.remoteVpcArn);
        }

        public final String getLocalIp() {
            return localIp;
        }

        public final void setLocalIp(String localIp) {
            this.localIp = localIp;
        }

        @Override
        public final Builder localIp(String localIp) {
            this.localIp = localIp;
            return this;
        }

        public final String getSnatIp() {
            return snatIp;
        }

        public final void setSnatIp(String snatIp) {
            this.snatIp = snatIp;
        }

        @Override
        public final Builder snatIp(String snatIp) {
            this.snatIp = snatIp;
            return this;
        }

        public final String getLocalInstanceId() {
            return localInstanceId;
        }

        public final void setLocalInstanceId(String localInstanceId) {
            this.localInstanceId = localInstanceId;
        }

        @Override
        public final Builder localInstanceId(String localInstanceId) {
            this.localInstanceId = localInstanceId;
            return this;
        }

        public final String getLocalVpcId() {
            return localVpcId;
        }

        public final void setLocalVpcId(String localVpcId) {
            this.localVpcId = localVpcId;
        }

        @Override
        public final Builder localVpcId(String localVpcId) {
            this.localVpcId = localVpcId;
            return this;
        }

        public final String getLocalRegion() {
            return localRegion;
        }

        public final void setLocalRegion(String localRegion) {
            this.localRegion = localRegion;
        }

        @Override
        public final Builder localRegion(String localRegion) {
            this.localRegion = localRegion;
            return this;
        }

        public final String getLocalAz() {
            return localAz;
        }

        public final void setLocalAz(String localAz) {
            this.localAz = localAz;
        }

        @Override
        public final Builder localAz(String localAz) {
            this.localAz = localAz;
            return this;
        }

        public final String getLocalSubnetId() {
            return localSubnetId;
        }

        public final void setLocalSubnetId(String localSubnetId) {
            this.localSubnetId = localSubnetId;
        }

        @Override
        public final Builder localSubnetId(String localSubnetId) {
            this.localSubnetId = localSubnetId;
            return this;
        }

        public final Integer getTargetPort() {
            return targetPort;
        }

        public final void setTargetPort(Integer targetPort) {
            this.targetPort = targetPort;
        }

        @Override
        public final Builder targetPort(Integer targetPort) {
            this.targetPort = targetPort;
            return this;
        }

        public final String getDestinationCategory() {
            return destinationCategory;
        }

        public final void setDestinationCategory(String destinationCategory) {
            this.destinationCategory = destinationCategory;
        }

        @Override
        public final Builder destinationCategory(String destinationCategory) {
            this.destinationCategory = destinationCategory;
            return this;
        }

        @Override
        public final Builder destinationCategory(DestinationCategory destinationCategory) {
            this.destinationCategory(destinationCategory == null ? null : destinationCategory.toString());
            return this;
        }

        public final String getRemoteVpcId() {
            return remoteVpcId;
        }

        public final void setRemoteVpcId(String remoteVpcId) {
            this.remoteVpcId = remoteVpcId;
        }

        @Override
        public final Builder remoteVpcId(String remoteVpcId) {
            this.remoteVpcId = remoteVpcId;
            return this;
        }

        public final String getRemoteRegion() {
            return remoteRegion;
        }

        public final void setRemoteRegion(String remoteRegion) {
            this.remoteRegion = remoteRegion;
        }

        @Override
        public final Builder remoteRegion(String remoteRegion) {
            this.remoteRegion = remoteRegion;
            return this;
        }

        public final String getRemoteAz() {
            return remoteAz;
        }

        public final void setRemoteAz(String remoteAz) {
            this.remoteAz = remoteAz;
        }

        @Override
        public final Builder remoteAz(String remoteAz) {
            this.remoteAz = remoteAz;
            return this;
        }

        public final String getRemoteSubnetId() {
            return remoteSubnetId;
        }

        public final void setRemoteSubnetId(String remoteSubnetId) {
            this.remoteSubnetId = remoteSubnetId;
        }

        @Override
        public final Builder remoteSubnetId(String remoteSubnetId) {
            this.remoteSubnetId = remoteSubnetId;
            return this;
        }

        public final String getRemoteInstanceId() {
            return remoteInstanceId;
        }

        public final void setRemoteInstanceId(String remoteInstanceId) {
            this.remoteInstanceId = remoteInstanceId;
        }

        @Override
        public final Builder remoteInstanceId(String remoteInstanceId) {
            this.remoteInstanceId = remoteInstanceId;
            return this;
        }

        public final String getRemoteIp() {
            return remoteIp;
        }

        public final void setRemoteIp(String remoteIp) {
            this.remoteIp = remoteIp;
        }

        @Override
        public final Builder remoteIp(String remoteIp) {
            this.remoteIp = remoteIp;
            return this;
        }

        public final String getDnatIp() {
            return dnatIp;
        }

        public final void setDnatIp(String dnatIp) {
            this.dnatIp = dnatIp;
        }

        @Override
        public final Builder dnatIp(String dnatIp) {
            this.dnatIp = dnatIp;
            return this;
        }

        public final Long getValue() {
            return value;
        }

        public final void setValue(Long value) {
            this.value = value;
        }

        @Override
        public final Builder value(Long value) {
            this.value = value;
            return this;
        }

        public final List<TraversedComponent.Builder> getTraversedConstructs() {
            List<TraversedComponent.Builder> result = TraversedConstructsListCopier.copyToBuilder(this.traversedConstructs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTraversedConstructs(Collection<TraversedComponent.BuilderImpl> traversedConstructs) {
            this.traversedConstructs = TraversedConstructsListCopier.copyFromBuilder(traversedConstructs);
        }

        @Override
        public final Builder traversedConstructs(Collection<TraversedComponent> traversedConstructs) {
            this.traversedConstructs = TraversedConstructsListCopier.copy(traversedConstructs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traversedConstructs(TraversedComponent... traversedConstructs) {
            traversedConstructs(Arrays.asList(traversedConstructs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traversedConstructs(Consumer<TraversedComponent.Builder>... traversedConstructs) {
            traversedConstructs(Stream.of(traversedConstructs).map(c -> TraversedComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final KubernetesMetadata.Builder getKubernetesMetadata() {
            return kubernetesMetadata != null ? kubernetesMetadata.toBuilder() : null;
        }

        public final void setKubernetesMetadata(KubernetesMetadata.BuilderImpl kubernetesMetadata) {
            this.kubernetesMetadata = kubernetesMetadata != null ? kubernetesMetadata.build() : null;
        }

        @Override
        public final Builder kubernetesMetadata(KubernetesMetadata kubernetesMetadata) {
            this.kubernetesMetadata = kubernetesMetadata;
            return this;
        }

        public final String getLocalInstanceArn() {
            return localInstanceArn;
        }

        public final void setLocalInstanceArn(String localInstanceArn) {
            this.localInstanceArn = localInstanceArn;
        }

        @Override
        public final Builder localInstanceArn(String localInstanceArn) {
            this.localInstanceArn = localInstanceArn;
            return this;
        }

        public final String getLocalSubnetArn() {
            return localSubnetArn;
        }

        public final void setLocalSubnetArn(String localSubnetArn) {
            this.localSubnetArn = localSubnetArn;
        }

        @Override
        public final Builder localSubnetArn(String localSubnetArn) {
            this.localSubnetArn = localSubnetArn;
            return this;
        }

        public final String getLocalVpcArn() {
            return localVpcArn;
        }

        public final void setLocalVpcArn(String localVpcArn) {
            this.localVpcArn = localVpcArn;
        }

        @Override
        public final Builder localVpcArn(String localVpcArn) {
            this.localVpcArn = localVpcArn;
            return this;
        }

        public final String getRemoteInstanceArn() {
            return remoteInstanceArn;
        }

        public final void setRemoteInstanceArn(String remoteInstanceArn) {
            this.remoteInstanceArn = remoteInstanceArn;
        }

        @Override
        public final Builder remoteInstanceArn(String remoteInstanceArn) {
            this.remoteInstanceArn = remoteInstanceArn;
            return this;
        }

        public final String getRemoteSubnetArn() {
            return remoteSubnetArn;
        }

        public final void setRemoteSubnetArn(String remoteSubnetArn) {
            this.remoteSubnetArn = remoteSubnetArn;
        }

        @Override
        public final Builder remoteSubnetArn(String remoteSubnetArn) {
            this.remoteSubnetArn = remoteSubnetArn;
            return this;
        }

        public final String getRemoteVpcArn() {
            return remoteVpcArn;
        }

        public final void setRemoteVpcArn(String remoteVpcArn) {
            this.remoteVpcArn = remoteVpcArn;
        }

        @Override
        public final Builder remoteVpcArn(String remoteVpcArn) {
            this.remoteVpcArn = remoteVpcArn;
            return this;
        }

        @Override
        public MonitorTopContributorsRow build() {
            return new MonitorTopContributorsRow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
