/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A local resource is the host where the agent is installed. Local resources can be a a subnet, a VPC, an Availability
 * Zone, an EKS cluster or an Amazon Web Services Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitorLocalResource implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitorLocalResource.Builder, MonitorLocalResource> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(MonitorLocalResource::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(MonitorLocalResource::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String identifier;

    private MonitorLocalResource(BuilderImpl builder) {
        this.type = builder.type;
        this.identifier = builder.identifier;
    }

    /**
     * <p>
     * The type of the local resource. Valid values are <code>AWS::EC2::VPC</code> <code>AWS::AvailabilityZone</code>,
     * <code>AWS::EC2::Subnet</code>, <code>AWS::EKS::Cluster</code>, or <code>AWS::Region</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MonitorLocalResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the local resource. Valid values are <code>AWS::EC2::VPC</code>
     *         <code>AWS::AvailabilityZone</code>, <code>AWS::EC2::Subnet</code>, <code>AWS::EKS::Cluster</code>, or
     *         <code>AWS::Region</code>.
     * @see MonitorLocalResourceType
     */
    public final MonitorLocalResourceType type() {
        return MonitorLocalResourceType.fromValue(type);
    }

    /**
     * <p>
     * The type of the local resource. Valid values are <code>AWS::EC2::VPC</code> <code>AWS::AvailabilityZone</code>,
     * <code>AWS::EC2::Subnet</code>, <code>AWS::EKS::Cluster</code>, or <code>AWS::Region</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MonitorLocalResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the local resource. Valid values are <code>AWS::EC2::VPC</code>
     *         <code>AWS::AvailabilityZone</code>, <code>AWS::EC2::Subnet</code>, <code>AWS::EKS::Cluster</code>, or
     *         <code>AWS::Region</code>.
     * @see MonitorLocalResourceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The identifier of the local resource. The values you can specify are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For a VPC, subnet or EKS cluster, this identifier is the VPC Amazon Resource Name (ARN), subnet ARN or cluster
     * ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * For an Availability Zone, this identifier is the AZ name, for example, us-west-2b.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a Region, this identifier is the Region name, for example, us-west-2.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the local resource. The values you can specify are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For a VPC, subnet or EKS cluster, this identifier is the VPC Amazon Resource Name (ARN), subnet ARN or
     *         cluster ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For an Availability Zone, this identifier is the AZ name, for example, us-west-2b.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For a Region, this identifier is the Region name, for example, us-west-2.
     *         </p>
     *         </li>
     */
    public final String identifier() {
        return identifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorLocalResource)) {
            return false;
        }
        MonitorLocalResource other = (MonitorLocalResource) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(identifier(), other.identifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitorLocalResource").add("Type", typeAsString()).add("Identifier", identifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitorLocalResource, T> g) {
        return obj -> g.apply((MonitorLocalResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitorLocalResource> {
        /**
         * <p>
         * The type of the local resource. Valid values are <code>AWS::EC2::VPC</code>
         * <code>AWS::AvailabilityZone</code>, <code>AWS::EC2::Subnet</code>, <code>AWS::EKS::Cluster</code>, or
         * <code>AWS::Region</code>.
         * </p>
         * 
         * @param type
         *        The type of the local resource. Valid values are <code>AWS::EC2::VPC</code>
         *        <code>AWS::AvailabilityZone</code>, <code>AWS::EC2::Subnet</code>, <code>AWS::EKS::Cluster</code>, or
         *        <code>AWS::Region</code>.
         * @see MonitorLocalResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitorLocalResourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the local resource. Valid values are <code>AWS::EC2::VPC</code>
         * <code>AWS::AvailabilityZone</code>, <code>AWS::EC2::Subnet</code>, <code>AWS::EKS::Cluster</code>, or
         * <code>AWS::Region</code>.
         * </p>
         * 
         * @param type
         *        The type of the local resource. Valid values are <code>AWS::EC2::VPC</code>
         *        <code>AWS::AvailabilityZone</code>, <code>AWS::EC2::Subnet</code>, <code>AWS::EKS::Cluster</code>, or
         *        <code>AWS::Region</code>.
         * @see MonitorLocalResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitorLocalResourceType
         */
        Builder type(MonitorLocalResourceType type);

        /**
         * <p>
         * The identifier of the local resource. The values you can specify are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For a VPC, subnet or EKS cluster, this identifier is the VPC Amazon Resource Name (ARN), subnet ARN or
         * cluster ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * For an Availability Zone, this identifier is the AZ name, for example, us-west-2b.
         * </p>
         * </li>
         * <li>
         * <p>
         * For a Region, this identifier is the Region name, for example, us-west-2.
         * </p>
         * </li>
         * </ul>
         * 
         * @param identifier
         *        The identifier of the local resource. The values you can specify are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For a VPC, subnet or EKS cluster, this identifier is the VPC Amazon Resource Name (ARN), subnet ARN or
         *        cluster ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For an Availability Zone, this identifier is the AZ name, for example, us-west-2b.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For a Region, this identifier is the Region name, for example, us-west-2.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String identifier;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitorLocalResource model) {
            type(model.type);
            identifier(model.identifier);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MonitorLocalResourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public MonitorLocalResource build() {
            return new MonitorLocalResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
