/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Meta data about Kubernetes resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KubernetesMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<KubernetesMetadata.Builder, KubernetesMetadata> {
    private static final SdkField<String> LOCAL_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localServiceName").getter(getter(KubernetesMetadata::localServiceName))
            .setter(setter(Builder::localServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localServiceName").build()).build();

    private static final SdkField<String> LOCAL_POD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localPodName").getter(getter(KubernetesMetadata::localPodName)).setter(setter(Builder::localPodName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localPodName").build()).build();

    private static final SdkField<String> LOCAL_POD_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localPodNamespace").getter(getter(KubernetesMetadata::localPodNamespace))
            .setter(setter(Builder::localPodNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localPodNamespace").build()).build();

    private static final SdkField<String> REMOTE_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remoteServiceName").getter(getter(KubernetesMetadata::remoteServiceName))
            .setter(setter(Builder::remoteServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteServiceName").build()).build();

    private static final SdkField<String> REMOTE_POD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remotePodName").getter(getter(KubernetesMetadata::remotePodName)).setter(setter(Builder::remotePodName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remotePodName").build()).build();

    private static final SdkField<String> REMOTE_POD_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remotePodNamespace").getter(getter(KubernetesMetadata::remotePodNamespace))
            .setter(setter(Builder::remotePodNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remotePodNamespace").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_SERVICE_NAME_FIELD,
            LOCAL_POD_NAME_FIELD, LOCAL_POD_NAMESPACE_FIELD, REMOTE_SERVICE_NAME_FIELD, REMOTE_POD_NAME_FIELD,
            REMOTE_POD_NAMESPACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String localServiceName;

    private final String localPodName;

    private final String localPodNamespace;

    private final String remoteServiceName;

    private final String remotePodName;

    private final String remotePodNamespace;

    private KubernetesMetadata(BuilderImpl builder) {
        this.localServiceName = builder.localServiceName;
        this.localPodName = builder.localPodName;
        this.localPodNamespace = builder.localPodNamespace;
        this.remoteServiceName = builder.remoteServiceName;
        this.remotePodName = builder.remotePodName;
        this.remotePodNamespace = builder.remotePodNamespace;
    }

    /**
     * <p>
     * The service name for a local resource.
     * </p>
     * 
     * @return The service name for a local resource.
     */
    public final String localServiceName() {
        return localServiceName;
    }

    /**
     * <p>
     * The name of the pod for a local resource.
     * </p>
     * 
     * @return The name of the pod for a local resource.
     */
    public final String localPodName() {
        return localPodName;
    }

    /**
     * <p>
     * The namespace of the pod for a local resource.
     * </p>
     * 
     * @return The namespace of the pod for a local resource.
     */
    public final String localPodNamespace() {
        return localPodNamespace;
    }

    /**
     * <p>
     * The service name for a remote resource.
     * </p>
     * 
     * @return The service name for a remote resource.
     */
    public final String remoteServiceName() {
        return remoteServiceName;
    }

    /**
     * <p>
     * The name of the pod for a remote resource.
     * </p>
     * 
     * @return The name of the pod for a remote resource.
     */
    public final String remotePodName() {
        return remotePodName;
    }

    /**
     * <p>
     * The namespace of the pod for a remote resource.
     * </p>
     * 
     * @return The namespace of the pod for a remote resource.
     */
    public final String remotePodNamespace() {
        return remotePodNamespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(localPodName());
        hashCode = 31 * hashCode + Objects.hashCode(localPodNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(remoteServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(remotePodName());
        hashCode = 31 * hashCode + Objects.hashCode(remotePodNamespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesMetadata)) {
            return false;
        }
        KubernetesMetadata other = (KubernetesMetadata) obj;
        return Objects.equals(localServiceName(), other.localServiceName())
                && Objects.equals(localPodName(), other.localPodName())
                && Objects.equals(localPodNamespace(), other.localPodNamespace())
                && Objects.equals(remoteServiceName(), other.remoteServiceName())
                && Objects.equals(remotePodName(), other.remotePodName())
                && Objects.equals(remotePodNamespace(), other.remotePodNamespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KubernetesMetadata").add("LocalServiceName", localServiceName())
                .add("LocalPodName", localPodName()).add("LocalPodNamespace", localPodNamespace())
                .add("RemoteServiceName", remoteServiceName()).add("RemotePodName", remotePodName())
                .add("RemotePodNamespace", remotePodNamespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "localServiceName":
            return Optional.ofNullable(clazz.cast(localServiceName()));
        case "localPodName":
            return Optional.ofNullable(clazz.cast(localPodName()));
        case "localPodNamespace":
            return Optional.ofNullable(clazz.cast(localPodNamespace()));
        case "remoteServiceName":
            return Optional.ofNullable(clazz.cast(remoteServiceName()));
        case "remotePodName":
            return Optional.ofNullable(clazz.cast(remotePodName()));
        case "remotePodNamespace":
            return Optional.ofNullable(clazz.cast(remotePodNamespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("localServiceName", LOCAL_SERVICE_NAME_FIELD);
        map.put("localPodName", LOCAL_POD_NAME_FIELD);
        map.put("localPodNamespace", LOCAL_POD_NAMESPACE_FIELD);
        map.put("remoteServiceName", REMOTE_SERVICE_NAME_FIELD);
        map.put("remotePodName", REMOTE_POD_NAME_FIELD);
        map.put("remotePodNamespace", REMOTE_POD_NAMESPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KubernetesMetadata, T> g) {
        return obj -> g.apply((KubernetesMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KubernetesMetadata> {
        /**
         * <p>
         * The service name for a local resource.
         * </p>
         * 
         * @param localServiceName
         *        The service name for a local resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localServiceName(String localServiceName);

        /**
         * <p>
         * The name of the pod for a local resource.
         * </p>
         * 
         * @param localPodName
         *        The name of the pod for a local resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localPodName(String localPodName);

        /**
         * <p>
         * The namespace of the pod for a local resource.
         * </p>
         * 
         * @param localPodNamespace
         *        The namespace of the pod for a local resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localPodNamespace(String localPodNamespace);

        /**
         * <p>
         * The service name for a remote resource.
         * </p>
         * 
         * @param remoteServiceName
         *        The service name for a remote resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteServiceName(String remoteServiceName);

        /**
         * <p>
         * The name of the pod for a remote resource.
         * </p>
         * 
         * @param remotePodName
         *        The name of the pod for a remote resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remotePodName(String remotePodName);

        /**
         * <p>
         * The namespace of the pod for a remote resource.
         * </p>
         * 
         * @param remotePodNamespace
         *        The namespace of the pod for a remote resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remotePodNamespace(String remotePodNamespace);
    }

    static final class BuilderImpl implements Builder {
        private String localServiceName;

        private String localPodName;

        private String localPodNamespace;

        private String remoteServiceName;

        private String remotePodName;

        private String remotePodNamespace;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesMetadata model) {
            localServiceName(model.localServiceName);
            localPodName(model.localPodName);
            localPodNamespace(model.localPodNamespace);
            remoteServiceName(model.remoteServiceName);
            remotePodName(model.remotePodName);
            remotePodNamespace(model.remotePodNamespace);
        }

        public final String getLocalServiceName() {
            return localServiceName;
        }

        public final void setLocalServiceName(String localServiceName) {
            this.localServiceName = localServiceName;
        }

        @Override
        public final Builder localServiceName(String localServiceName) {
            this.localServiceName = localServiceName;
            return this;
        }

        public final String getLocalPodName() {
            return localPodName;
        }

        public final void setLocalPodName(String localPodName) {
            this.localPodName = localPodName;
        }

        @Override
        public final Builder localPodName(String localPodName) {
            this.localPodName = localPodName;
            return this;
        }

        public final String getLocalPodNamespace() {
            return localPodNamespace;
        }

        public final void setLocalPodNamespace(String localPodNamespace) {
            this.localPodNamespace = localPodNamespace;
        }

        @Override
        public final Builder localPodNamespace(String localPodNamespace) {
            this.localPodNamespace = localPodNamespace;
            return this;
        }

        public final String getRemoteServiceName() {
            return remoteServiceName;
        }

        public final void setRemoteServiceName(String remoteServiceName) {
            this.remoteServiceName = remoteServiceName;
        }

        @Override
        public final Builder remoteServiceName(String remoteServiceName) {
            this.remoteServiceName = remoteServiceName;
            return this;
        }

        public final String getRemotePodName() {
            return remotePodName;
        }

        public final void setRemotePodName(String remotePodName) {
            this.remotePodName = remotePodName;
        }

        @Override
        public final Builder remotePodName(String remotePodName) {
            this.remotePodName = remotePodName;
            return this;
        }

        public final String getRemotePodNamespace() {
            return remotePodNamespace;
        }

        public final void setRemotePodNamespace(String remotePodNamespace) {
            this.remotePodNamespace = remotePodNamespace;
        }

        @Override
        public final Builder remotePodNamespace(String remotePodNamespace) {
            this.remotePodNamespace = remotePodNamespace;
            return this;
        }

        @Override
        public KubernetesMetadata build() {
            return new KubernetesMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
