/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQueryStatusWorkloadInsightsTopContributorsResponse extends NetworkFlowMonitorResponse
        implements
        ToCopyableBuilder<GetQueryStatusWorkloadInsightsTopContributorsResponse.Builder, GetQueryStatusWorkloadInsightsTopContributorsResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetQueryStatusWorkloadInsightsTopContributorsResponse::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String status;

    private GetQueryStatusWorkloadInsightsTopContributorsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
    }

    /**
     * <p>
     * When you run a query, use this call to check the status of the query to make sure that the query has
     * <code>SUCCEEDED</code> before you review the results.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>QUEUED</code>: The query is scheduled to run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: The query is in progress but not complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The query completed sucessfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The query failed due to an error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELED</code>: The query was canceled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return When you run a query, use this call to check the status of the query to make sure that the query has
     *         <code>SUCCEEDED</code> before you review the results.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>QUEUED</code>: The query is scheduled to run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>: The query is in progress but not complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>: The query completed sucessfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The query failed due to an error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELED</code>: The query was canceled.
     *         </p>
     *         </li>
     * @see QueryStatus
     */
    public final QueryStatus status() {
        return QueryStatus.fromValue(status);
    }

    /**
     * <p>
     * When you run a query, use this call to check the status of the query to make sure that the query has
     * <code>SUCCEEDED</code> before you review the results.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>QUEUED</code>: The query is scheduled to run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: The query is in progress but not complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The query completed sucessfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The query failed due to an error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELED</code>: The query was canceled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return When you run a query, use this call to check the status of the query to make sure that the query has
     *         <code>SUCCEEDED</code> before you review the results.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>QUEUED</code>: The query is scheduled to run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>: The query is in progress but not complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>: The query completed sucessfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The query failed due to an error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELED</code>: The query was canceled.
     *         </p>
     *         </li>
     * @see QueryStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryStatusWorkloadInsightsTopContributorsResponse)) {
            return false;
        }
        GetQueryStatusWorkloadInsightsTopContributorsResponse other = (GetQueryStatusWorkloadInsightsTopContributorsResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetQueryStatusWorkloadInsightsTopContributorsResponse").add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQueryStatusWorkloadInsightsTopContributorsResponse, T> g) {
        return obj -> g.apply((GetQueryStatusWorkloadInsightsTopContributorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFlowMonitorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetQueryStatusWorkloadInsightsTopContributorsResponse> {
        /**
         * <p>
         * When you run a query, use this call to check the status of the query to make sure that the query has
         * <code>SUCCEEDED</code> before you review the results.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>QUEUED</code>: The query is scheduled to run.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>: The query is in progress but not complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>: The query completed sucessfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The query failed due to an error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELED</code>: The query was canceled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        When you run a query, use this call to check the status of the query to make sure that the query has
         *        <code>SUCCEEDED</code> before you review the results.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>QUEUED</code>: The query is scheduled to run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>: The query is in progress but not complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>: The query completed sucessfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The query failed due to an error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELED</code>: The query was canceled.
         *        </p>
         *        </li>
         * @see QueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * When you run a query, use this call to check the status of the query to make sure that the query has
         * <code>SUCCEEDED</code> before you review the results.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>QUEUED</code>: The query is scheduled to run.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>: The query is in progress but not complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>: The query completed sucessfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The query failed due to an error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELED</code>: The query was canceled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        When you run a query, use this call to check the status of the query to make sure that the query has
         *        <code>SUCCEEDED</code> before you review the results.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>QUEUED</code>: The query is scheduled to run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>: The query is in progress but not complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>: The query completed sucessfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The query failed due to an error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELED</code>: The query was canceled.
         *        </p>
         *        </li>
         * @see QueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryStatus
         */
        Builder status(QueryStatus status);
    }

    static final class BuilderImpl extends NetworkFlowMonitorResponse.BuilderImpl implements Builder {
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryStatusWorkloadInsightsTopContributorsResponse model) {
            super(model);
            status(model.status);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetQueryStatusWorkloadInsightsTopContributorsResponse build() {
            return new GetQueryStatusWorkloadInsightsTopContributorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
