/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQueryResultsWorkloadInsightsTopContributorsResponse extends NetworkFlowMonitorResponse
        implements
        ToCopyableBuilder<GetQueryResultsWorkloadInsightsTopContributorsResponse.Builder, GetQueryResultsWorkloadInsightsTopContributorsResponse> {
    private static final SdkField<List<WorkloadInsightsTopContributorsRow>> TOP_CONTRIBUTORS_FIELD = SdkField
            .<List<WorkloadInsightsTopContributorsRow>> builder(MarshallingType.LIST)
            .memberName("topContributors")
            .getter(getter(GetQueryResultsWorkloadInsightsTopContributorsResponse::topContributors))
            .setter(setter(Builder::topContributors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topContributors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkloadInsightsTopContributorsRow> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkloadInsightsTopContributorsRow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetQueryResultsWorkloadInsightsTopContributorsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOP_CONTRIBUTORS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<WorkloadInsightsTopContributorsRow> topContributors;

    private final String nextToken;

    private GetQueryResultsWorkloadInsightsTopContributorsResponse(BuilderImpl builder) {
        super(builder);
        this.topContributors = builder.topContributors;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TopContributors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTopContributors() {
        return topContributors != null && !(topContributors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The top contributor network flows overall for a specific metric type, for example, the number of retransmissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTopContributors} method.
     * </p>
     * 
     * @return The top contributor network flows overall for a specific metric type, for example, the number of
     *         retransmissions.
     */
    public final List<WorkloadInsightsTopContributorsRow> topContributors() {
        return topContributors;
    }

    /**
     * <p>
     * The token for the next set of results. You receive this token from a previous call.
     * </p>
     * 
     * @return The token for the next set of results. You receive this token from a previous call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTopContributors() ? topContributors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryResultsWorkloadInsightsTopContributorsResponse)) {
            return false;
        }
        GetQueryResultsWorkloadInsightsTopContributorsResponse other = (GetQueryResultsWorkloadInsightsTopContributorsResponse) obj;
        return hasTopContributors() == other.hasTopContributors() && Objects.equals(topContributors(), other.topContributors())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetQueryResultsWorkloadInsightsTopContributorsResponse")
                .add("TopContributors", hasTopContributors() ? topContributors() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "topContributors":
            return Optional.ofNullable(clazz.cast(topContributors()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("topContributors", TOP_CONTRIBUTORS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQueryResultsWorkloadInsightsTopContributorsResponse, T> g) {
        return obj -> g.apply((GetQueryResultsWorkloadInsightsTopContributorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFlowMonitorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetQueryResultsWorkloadInsightsTopContributorsResponse> {
        /**
         * <p>
         * The top contributor network flows overall for a specific metric type, for example, the number of
         * retransmissions.
         * </p>
         * 
         * @param topContributors
         *        The top contributor network flows overall for a specific metric type, for example, the number of
         *        retransmissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topContributors(Collection<WorkloadInsightsTopContributorsRow> topContributors);

        /**
         * <p>
         * The top contributor network flows overall for a specific metric type, for example, the number of
         * retransmissions.
         * </p>
         * 
         * @param topContributors
         *        The top contributor network flows overall for a specific metric type, for example, the number of
         *        retransmissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topContributors(WorkloadInsightsTopContributorsRow... topContributors);

        /**
         * <p>
         * The top contributor network flows overall for a specific metric type, for example, the number of
         * retransmissions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.WorkloadInsightsTopContributorsRow.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.WorkloadInsightsTopContributorsRow#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.WorkloadInsightsTopContributorsRow.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #topContributors(List<WorkloadInsightsTopContributorsRow>)}.
         * 
         * @param topContributors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkflowmonitor.model.WorkloadInsightsTopContributorsRow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topContributors(java.util.Collection<WorkloadInsightsTopContributorsRow>)
         */
        Builder topContributors(Consumer<WorkloadInsightsTopContributorsRow.Builder>... topContributors);

        /**
         * <p>
         * The token for the next set of results. You receive this token from a previous call.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. You receive this token from a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NetworkFlowMonitorResponse.BuilderImpl implements Builder {
        private List<WorkloadInsightsTopContributorsRow> topContributors = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryResultsWorkloadInsightsTopContributorsResponse model) {
            super(model);
            topContributors(model.topContributors);
            nextToken(model.nextToken);
        }

        public final List<WorkloadInsightsTopContributorsRow.Builder> getTopContributors() {
            List<WorkloadInsightsTopContributorsRow.Builder> result = WorkloadInsightsTopContributorsRowListCopier
                    .copyToBuilder(this.topContributors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopContributors(Collection<WorkloadInsightsTopContributorsRow.BuilderImpl> topContributors) {
            this.topContributors = WorkloadInsightsTopContributorsRowListCopier.copyFromBuilder(topContributors);
        }

        @Override
        public final Builder topContributors(Collection<WorkloadInsightsTopContributorsRow> topContributors) {
            this.topContributors = WorkloadInsightsTopContributorsRowListCopier.copy(topContributors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topContributors(WorkloadInsightsTopContributorsRow... topContributors) {
            topContributors(Arrays.asList(topContributors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topContributors(Consumer<WorkloadInsightsTopContributorsRow.Builder>... topContributors) {
            topContributors(Stream.of(topContributors)
                    .map(c -> WorkloadInsightsTopContributorsRow.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetQueryResultsWorkloadInsightsTopContributorsResponse build() {
            return new GetQueryResultsWorkloadInsightsTopContributorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
