/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQueryResultsMonitorTopContributorsResponse extends NetworkFlowMonitorResponse implements
        ToCopyableBuilder<GetQueryResultsMonitorTopContributorsResponse.Builder, GetQueryResultsMonitorTopContributorsResponse> {
    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(GetQueryResultsMonitorTopContributorsResponse::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<List<MonitorTopContributorsRow>> TOP_CONTRIBUTORS_FIELD = SdkField
            .<List<MonitorTopContributorsRow>> builder(MarshallingType.LIST)
            .memberName("topContributors")
            .getter(getter(GetQueryResultsMonitorTopContributorsResponse::topContributors))
            .setter(setter(Builder::topContributors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topContributors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MonitorTopContributorsRow> builder(MarshallingType.SDK_POJO)
                                            .constructor(MonitorTopContributorsRow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetQueryResultsMonitorTopContributorsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNIT_FIELD,
            TOP_CONTRIBUTORS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String unit;

    private final List<MonitorTopContributorsRow> topContributors;

    private final String nextToken;

    private GetQueryResultsMonitorTopContributorsResponse(BuilderImpl builder) {
        super(builder);
        this.unit = builder.unit;
        this.topContributors = builder.topContributors;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The units for a metric returned by the query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link MetricUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The units for a metric returned by the query.
     * @see MetricUnit
     */
    public final MetricUnit unit() {
        return MetricUnit.fromValue(unit);
    }

    /**
     * <p>
     * The units for a metric returned by the query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link MetricUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The units for a metric returned by the query.
     * @see MetricUnit
     */
    public final String unitAsString() {
        return unit;
    }

    /**
     * For responses, this returns true if the service returned a value for the TopContributors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTopContributors() {
        return topContributors != null && !(topContributors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The top contributor network flows overall for a specific metric type, for example, the number of retransmissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTopContributors} method.
     * </p>
     * 
     * @return The top contributor network flows overall for a specific metric type, for example, the number of
     *         retransmissions.
     */
    public final List<MonitorTopContributorsRow> topContributors() {
        return topContributors;
    }

    /**
     * <p>
     * The token for the next set of results. You receive this token from a previous call.
     * </p>
     * 
     * @return The token for the next set of results. You receive this token from a previous call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTopContributors() ? topContributors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryResultsMonitorTopContributorsResponse)) {
            return false;
        }
        GetQueryResultsMonitorTopContributorsResponse other = (GetQueryResultsMonitorTopContributorsResponse) obj;
        return Objects.equals(unitAsString(), other.unitAsString()) && hasTopContributors() == other.hasTopContributors()
                && Objects.equals(topContributors(), other.topContributors()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetQueryResultsMonitorTopContributorsResponse").add("Unit", unitAsString())
                .add("TopContributors", hasTopContributors() ? topContributors() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "topContributors":
            return Optional.ofNullable(clazz.cast(topContributors()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("unit", UNIT_FIELD);
        map.put("topContributors", TOP_CONTRIBUTORS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQueryResultsMonitorTopContributorsResponse, T> g) {
        return obj -> g.apply((GetQueryResultsMonitorTopContributorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFlowMonitorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetQueryResultsMonitorTopContributorsResponse> {
        /**
         * <p>
         * The units for a metric returned by the query.
         * </p>
         * 
         * @param unit
         *        The units for a metric returned by the query.
         * @see MetricUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The units for a metric returned by the query.
         * </p>
         * 
         * @param unit
         *        The units for a metric returned by the query.
         * @see MetricUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricUnit
         */
        Builder unit(MetricUnit unit);

        /**
         * <p>
         * The top contributor network flows overall for a specific metric type, for example, the number of
         * retransmissions.
         * </p>
         * 
         * @param topContributors
         *        The top contributor network flows overall for a specific metric type, for example, the number of
         *        retransmissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topContributors(Collection<MonitorTopContributorsRow> topContributors);

        /**
         * <p>
         * The top contributor network flows overall for a specific metric type, for example, the number of
         * retransmissions.
         * </p>
         * 
         * @param topContributors
         *        The top contributor network flows overall for a specific metric type, for example, the number of
         *        retransmissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topContributors(MonitorTopContributorsRow... topContributors);

        /**
         * <p>
         * The top contributor network flows overall for a specific metric type, for example, the number of
         * retransmissions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorTopContributorsRow.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorTopContributorsRow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorTopContributorsRow.Builder#build()} is
         * called immediately and its result is passed to {@link #topContributors(List<MonitorTopContributorsRow>)}.
         * 
         * @param topContributors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorTopContributorsRow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topContributors(java.util.Collection<MonitorTopContributorsRow>)
         */
        Builder topContributors(Consumer<MonitorTopContributorsRow.Builder>... topContributors);

        /**
         * <p>
         * The token for the next set of results. You receive this token from a previous call.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. You receive this token from a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NetworkFlowMonitorResponse.BuilderImpl implements Builder {
        private String unit;

        private List<MonitorTopContributorsRow> topContributors = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryResultsMonitorTopContributorsResponse model) {
            super(model);
            unit(model.unit);
            topContributors(model.topContributors);
            nextToken(model.nextToken);
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(MetricUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final List<MonitorTopContributorsRow.Builder> getTopContributors() {
            List<MonitorTopContributorsRow.Builder> result = MonitorTopContributorsRowListCopier
                    .copyToBuilder(this.topContributors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopContributors(Collection<MonitorTopContributorsRow.BuilderImpl> topContributors) {
            this.topContributors = MonitorTopContributorsRowListCopier.copyFromBuilder(topContributors);
        }

        @Override
        public final Builder topContributors(Collection<MonitorTopContributorsRow> topContributors) {
            this.topContributors = MonitorTopContributorsRowListCopier.copy(topContributors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topContributors(MonitorTopContributorsRow... topContributors) {
            topContributors(Arrays.asList(topContributors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topContributors(Consumer<MonitorTopContributorsRow.Builder>... topContributors) {
            topContributors(Stream.of(topContributors).map(c -> MonitorTopContributorsRow.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetQueryResultsMonitorTopContributorsResponse build() {
            return new GetQueryResultsMonitorTopContributorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
