/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMonitorResponse extends NetworkFlowMonitorResponse implements
        ToCopyableBuilder<CreateMonitorResponse.Builder, CreateMonitorResponse> {
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("monitorArn").getter(getter(CreateMonitorResponse::monitorArn)).setter(setter(Builder::monitorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorArn").build()).build();

    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("monitorName").getter(getter(CreateMonitorResponse::monitorName)).setter(setter(Builder::monitorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorName").build()).build();

    private static final SdkField<String> MONITOR_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("monitorStatus").getter(getter(CreateMonitorResponse::monitorStatusAsString))
            .setter(setter(Builder::monitorStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorStatus").build()).build();

    private static final SdkField<List<MonitorLocalResource>> LOCAL_RESOURCES_FIELD = SdkField
            .<List<MonitorLocalResource>> builder(MarshallingType.LIST)
            .memberName("localResources")
            .getter(getter(CreateMonitorResponse::localResources))
            .setter(setter(Builder::localResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MonitorLocalResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(MonitorLocalResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MonitorRemoteResource>> REMOTE_RESOURCES_FIELD = SdkField
            .<List<MonitorRemoteResource>> builder(MarshallingType.LIST)
            .memberName("remoteResources")
            .getter(getter(CreateMonitorResponse::remoteResources))
            .setter(setter(Builder::remoteResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MonitorRemoteResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(MonitorRemoteResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(CreateMonitorResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt").getter(getter(CreateMonitorResponse::modifiedAt)).setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateMonitorResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ARN_FIELD,
            MONITOR_NAME_FIELD, MONITOR_STATUS_FIELD, LOCAL_RESOURCES_FIELD, REMOTE_RESOURCES_FIELD, CREATED_AT_FIELD,
            MODIFIED_AT_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String monitorArn;

    private final String monitorName;

    private final String monitorStatus;

    private final List<MonitorLocalResource> localResources;

    private final List<MonitorRemoteResource> remoteResources;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final Map<String, String> tags;

    private CreateMonitorResponse(BuilderImpl builder) {
        super(builder);
        this.monitorArn = builder.monitorArn;
        this.monitorName = builder.monitorName;
        this.monitorStatus = builder.monitorStatus;
        this.localResources = builder.localResources;
        this.remoteResources = builder.remoteResources;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the monitor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the monitor.
     */
    public final String monitorArn() {
        return monitorArn;
    }

    /**
     * <p>
     * The name of the monitor.
     * </p>
     * 
     * @return The name of the monitor.
     */
    public final String monitorName() {
        return monitorName;
    }

    /**
     * <p>
     * The status of a monitor. The status can be one of the following
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code>: The monitor is in the process of being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The monitor is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code>: The monitor is inactive.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>: Monitor creation failed due to an error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: The monitor is in the process of being deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #monitorStatus}
     * will return {@link MonitorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #monitorStatusAsString}.
     * </p>
     * 
     * @return The status of a monitor. The status can be one of the following</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: The monitor is in the process of being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The monitor is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code>: The monitor is inactive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>: Monitor creation failed due to an error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: The monitor is in the process of being deleted.
     *         </p>
     *         </li>
     * @see MonitorStatus
     */
    public final MonitorStatus monitorStatus() {
        return MonitorStatus.fromValue(monitorStatus);
    }

    /**
     * <p>
     * The status of a monitor. The status can be one of the following
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code>: The monitor is in the process of being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The monitor is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code>: The monitor is inactive.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>: Monitor creation failed due to an error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: The monitor is in the process of being deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #monitorStatus}
     * will return {@link MonitorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #monitorStatusAsString}.
     * </p>
     * 
     * @return The status of a monitor. The status can be one of the following</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: The monitor is in the process of being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The monitor is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code>: The monitor is inactive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>: Monitor creation failed due to an error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: The monitor is in the process of being deleted.
     *         </p>
     *         </li>
     * @see MonitorStatus
     */
    public final String monitorStatusAsString() {
        return monitorStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the LocalResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLocalResources() {
        return localResources != null && !(localResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The local resources to monitor. A local resource in a workload is the location of hosts where the Network Flow
     * Monitor agent is installed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocalResources} method.
     * </p>
     * 
     * @return The local resources to monitor. A local resource in a workload is the location of hosts where the Network
     *         Flow Monitor agent is installed.
     */
    public final List<MonitorLocalResource> localResources() {
        return localResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoteResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoteResources() {
        return remoteResources != null && !(remoteResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The remote resources to monitor. A remote resource is the other endpoint specified for the network flow of a
     * workload, with a local resource. For example, Amazon Dynamo DB can be a remote resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoteResources} method.
     * </p>
     * 
     * @return The remote resources to monitor. A remote resource is the other endpoint specified for the network flow
     *         of a workload, with a local resource. For example, Amazon Dynamo DB can be a remote resource.
     */
    public final List<MonitorRemoteResource> remoteResources() {
        return remoteResources;
    }

    /**
     * <p>
     * The date and time when the monitor was created.
     * </p>
     * 
     * @return The date and time when the monitor was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The last date and time that the monitor was modified.
     * </p>
     * 
     * @return The last date and time that the monitor was modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags for a monitor.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for a monitor.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(monitorStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocalResources() ? localResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoteResources() ? remoteResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMonitorResponse)) {
            return false;
        }
        CreateMonitorResponse other = (CreateMonitorResponse) obj;
        return Objects.equals(monitorArn(), other.monitorArn()) && Objects.equals(monitorName(), other.monitorName())
                && Objects.equals(monitorStatusAsString(), other.monitorStatusAsString())
                && hasLocalResources() == other.hasLocalResources() && Objects.equals(localResources(), other.localResources())
                && hasRemoteResources() == other.hasRemoteResources()
                && Objects.equals(remoteResources(), other.remoteResources()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(modifiedAt(), other.modifiedAt()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMonitorResponse").add("MonitorArn", monitorArn()).add("MonitorName", monitorName())
                .add("MonitorStatus", monitorStatusAsString())
                .add("LocalResources", hasLocalResources() ? localResources() : null)
                .add("RemoteResources", hasRemoteResources() ? remoteResources() : null).add("CreatedAt", createdAt())
                .add("ModifiedAt", modifiedAt()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "monitorArn":
            return Optional.ofNullable(clazz.cast(monitorArn()));
        case "monitorName":
            return Optional.ofNullable(clazz.cast(monitorName()));
        case "monitorStatus":
            return Optional.ofNullable(clazz.cast(monitorStatusAsString()));
        case "localResources":
            return Optional.ofNullable(clazz.cast(localResources()));
        case "remoteResources":
            return Optional.ofNullable(clazz.cast(remoteResources()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("monitorArn", MONITOR_ARN_FIELD);
        map.put("monitorName", MONITOR_NAME_FIELD);
        map.put("monitorStatus", MONITOR_STATUS_FIELD);
        map.put("localResources", LOCAL_RESOURCES_FIELD);
        map.put("remoteResources", REMOTE_RESOURCES_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMonitorResponse, T> g) {
        return obj -> g.apply((CreateMonitorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFlowMonitorResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateMonitorResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the monitor.
         * </p>
         * 
         * @param monitorArn
         *        The Amazon Resource Name (ARN) of the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorArn(String monitorArn);

        /**
         * <p>
         * The name of the monitor.
         * </p>
         * 
         * @param monitorName
         *        The name of the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorName(String monitorName);

        /**
         * <p>
         * The status of a monitor. The status can be one of the following
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>: The monitor is in the process of being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The monitor is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code>: The monitor is inactive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: Monitor creation failed due to an error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: The monitor is in the process of being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param monitorStatus
         *        The status of a monitor. The status can be one of the following</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The monitor is in the process of being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The monitor is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code>: The monitor is inactive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: Monitor creation failed due to an error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: The monitor is in the process of being deleted.
         *        </p>
         *        </li>
         * @see MonitorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitorStatus
         */
        Builder monitorStatus(String monitorStatus);

        /**
         * <p>
         * The status of a monitor. The status can be one of the following
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>: The monitor is in the process of being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The monitor is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code>: The monitor is inactive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: Monitor creation failed due to an error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: The monitor is in the process of being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param monitorStatus
         *        The status of a monitor. The status can be one of the following</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The monitor is in the process of being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The monitor is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code>: The monitor is inactive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: Monitor creation failed due to an error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: The monitor is in the process of being deleted.
         *        </p>
         *        </li>
         * @see MonitorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitorStatus
         */
        Builder monitorStatus(MonitorStatus monitorStatus);

        /**
         * <p>
         * The local resources to monitor. A local resource in a workload is the location of hosts where the Network
         * Flow Monitor agent is installed.
         * </p>
         * 
         * @param localResources
         *        The local resources to monitor. A local resource in a workload is the location of hosts where the
         *        Network Flow Monitor agent is installed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localResources(Collection<MonitorLocalResource> localResources);

        /**
         * <p>
         * The local resources to monitor. A local resource in a workload is the location of hosts where the Network
         * Flow Monitor agent is installed.
         * </p>
         * 
         * @param localResources
         *        The local resources to monitor. A local resource in a workload is the location of hosts where the
         *        Network Flow Monitor agent is installed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localResources(MonitorLocalResource... localResources);

        /**
         * <p>
         * The local resources to monitor. A local resource in a workload is the location of hosts where the Network
         * Flow Monitor agent is installed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource.Builder#build()} is
         * called immediately and its result is passed to {@link #localResources(List<MonitorLocalResource>)}.
         * 
         * @param localResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localResources(java.util.Collection<MonitorLocalResource>)
         */
        Builder localResources(Consumer<MonitorLocalResource.Builder>... localResources);

        /**
         * <p>
         * The remote resources to monitor. A remote resource is the other endpoint specified for the network flow of a
         * workload, with a local resource. For example, Amazon Dynamo DB can be a remote resource.
         * </p>
         * 
         * @param remoteResources
         *        The remote resources to monitor. A remote resource is the other endpoint specified for the network
         *        flow of a workload, with a local resource. For example, Amazon Dynamo DB can be a remote resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteResources(Collection<MonitorRemoteResource> remoteResources);

        /**
         * <p>
         * The remote resources to monitor. A remote resource is the other endpoint specified for the network flow of a
         * workload, with a local resource. For example, Amazon Dynamo DB can be a remote resource.
         * </p>
         * 
         * @param remoteResources
         *        The remote resources to monitor. A remote resource is the other endpoint specified for the network
         *        flow of a workload, with a local resource. For example, Amazon Dynamo DB can be a remote resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteResources(MonitorRemoteResource... remoteResources);

        /**
         * <p>
         * The remote resources to monitor. A remote resource is the other endpoint specified for the network flow of a
         * workload, with a local resource. For example, Amazon Dynamo DB can be a remote resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource.Builder#build()} is
         * called immediately and its result is passed to {@link #remoteResources(List<MonitorRemoteResource>)}.
         * 
         * @param remoteResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteResources(java.util.Collection<MonitorRemoteResource>)
         */
        Builder remoteResources(Consumer<MonitorRemoteResource.Builder>... remoteResources);

        /**
         * <p>
         * The date and time when the monitor was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the monitor was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The last date and time that the monitor was modified.
         * </p>
         * 
         * @param modifiedAt
         *        The last date and time that the monitor was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The tags for a monitor.
         * </p>
         * 
         * @param tags
         *        The tags for a monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends NetworkFlowMonitorResponse.BuilderImpl implements Builder {
        private String monitorArn;

        private String monitorName;

        private String monitorStatus;

        private List<MonitorLocalResource> localResources = DefaultSdkAutoConstructList.getInstance();

        private List<MonitorRemoteResource> remoteResources = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private Instant modifiedAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMonitorResponse model) {
            super(model);
            monitorArn(model.monitorArn);
            monitorName(model.monitorName);
            monitorStatus(model.monitorStatus);
            localResources(model.localResources);
            remoteResources(model.remoteResources);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            tags(model.tags);
        }

        public final String getMonitorArn() {
            return monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final String getMonitorName() {
            return monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final String getMonitorStatus() {
            return monitorStatus;
        }

        public final void setMonitorStatus(String monitorStatus) {
            this.monitorStatus = monitorStatus;
        }

        @Override
        public final Builder monitorStatus(String monitorStatus) {
            this.monitorStatus = monitorStatus;
            return this;
        }

        @Override
        public final Builder monitorStatus(MonitorStatus monitorStatus) {
            this.monitorStatus(monitorStatus == null ? null : monitorStatus.toString());
            return this;
        }

        public final List<MonitorLocalResource.Builder> getLocalResources() {
            List<MonitorLocalResource.Builder> result = MonitorLocalResourcesCopier.copyToBuilder(this.localResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocalResources(Collection<MonitorLocalResource.BuilderImpl> localResources) {
            this.localResources = MonitorLocalResourcesCopier.copyFromBuilder(localResources);
        }

        @Override
        public final Builder localResources(Collection<MonitorLocalResource> localResources) {
            this.localResources = MonitorLocalResourcesCopier.copy(localResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localResources(MonitorLocalResource... localResources) {
            localResources(Arrays.asList(localResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localResources(Consumer<MonitorLocalResource.Builder>... localResources) {
            localResources(Stream.of(localResources).map(c -> MonitorLocalResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MonitorRemoteResource.Builder> getRemoteResources() {
            List<MonitorRemoteResource.Builder> result = MonitorRemoteResourcesCopier.copyToBuilder(this.remoteResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoteResources(Collection<MonitorRemoteResource.BuilderImpl> remoteResources) {
            this.remoteResources = MonitorRemoteResourcesCopier.copyFromBuilder(remoteResources);
        }

        @Override
        public final Builder remoteResources(Collection<MonitorRemoteResource> remoteResources) {
            this.remoteResources = MonitorRemoteResourcesCopier.copy(remoteResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteResources(MonitorRemoteResource... remoteResources) {
            remoteResources(Arrays.asList(remoteResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteResources(Consumer<MonitorRemoteResource.Builder>... remoteResources) {
            remoteResources(Stream.of(remoteResources).map(c -> MonitorRemoteResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public CreateMonitorResponse build() {
            return new CreateMonitorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
