/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkflowmonitor;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.networkflowmonitor.model.CreateMonitorRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.CreateMonitorResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.CreateScopeRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.CreateScopeResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.DeleteMonitorRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.DeleteMonitorResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.DeleteScopeRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.DeleteScopeResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.GetMonitorRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetMonitorResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryStatusMonitorTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryStatusMonitorTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryStatusWorkloadInsightsTopContributorsDataRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryStatusWorkloadInsightsTopContributorsDataResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryStatusWorkloadInsightsTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryStatusWorkloadInsightsTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.GetScopeRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetScopeResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.ListScopesRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.ListScopesResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.StartQueryMonitorTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.StartQueryMonitorTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.StartQueryWorkloadInsightsTopContributorsDataRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.StartQueryWorkloadInsightsTopContributorsDataResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.StartQueryWorkloadInsightsTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.StartQueryWorkloadInsightsTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.StopQueryMonitorTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.StopQueryMonitorTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.StopQueryWorkloadInsightsTopContributorsDataRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.StopQueryWorkloadInsightsTopContributorsDataResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.StopQueryWorkloadInsightsTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.StopQueryWorkloadInsightsTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.TagResourceRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.TagResourceResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.UntagResourceRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.UntagResourceResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.UpdateMonitorRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.UpdateMonitorResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.UpdateScopeRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.UpdateScopeResponse;
import software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsMonitorTopContributorsPublisher;
import software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsDataPublisher;
import software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsPublisher;
import software.amazon.awssdk.services.networkflowmonitor.paginators.ListMonitorsPublisher;
import software.amazon.awssdk.services.networkflowmonitor.paginators.ListScopesPublisher;

/**
 * Service client for accessing Network Flow Monitor asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Network Flow Monitor is a feature of Amazon CloudWatch Network Monitoring that provides visibility into the
 * performance of network flows for your Amazon Web Services workloads, between instances in subnets, as well as to and
 * from Amazon Web Services. Lightweight agents that you install on the instances capture performance metrics for your
 * network flows, such as packet loss and latency, and send them to the Network Flow Monitor backend. Then, you can view
 * and analyze metrics from the top contributors for each metric type, to help troubleshoot issues.
 * </p>
 * <p>
 * In addition, when you create a monitor, Network Flow Monitor provides a network health indicator (NHI) that informs
 * you whether there were Amazon Web Services network issues for one or more of the network flows tracked by a monitor,
 * during a time period that you choose. By using this value, you can independently determine if the Amazon Web Services
 * network is impacting your workload during a specific time frame, to help you focus troubleshooting efforts.
 * </p>
 * <p>
 * To learn more about Network Flow Monitor, see the <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-NetworkFlowMonitor.html">Network Flow
 * Monitor User Guide</a> in the Amazon CloudWatch User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface NetworkFlowMonitorAsyncClient extends AwsClient {
    String SERVICE_NAME = "networkflowmonitor";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "networkflowmonitor";

    /**
     * <p>
     * Create a monitor for specific network flows between local and remote resources, so that you can monitor network
     * performance for one or several of your workloads. For each monitor, Network Flow Monitor publishes detailed
     * end-to-end performance metrics and a network health indicator (NHI) that informs you whether there were Amazon
     * Web Services network issues for one or more of the network flows tracked by a monitor, during a time period that
     * you choose.
     * </p>
     *
     * @param createMonitorRequest
     * @return A Java Future containing the result of the CreateMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ConflictException The requested resource is in use.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.CreateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/CreateMonitor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMonitorResponse> createMonitor(CreateMonitorRequest createMonitorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a monitor for specific network flows between local and remote resources, so that you can monitor network
     * performance for one or several of your workloads. For each monitor, Network Flow Monitor publishes detailed
     * end-to-end performance metrics and a network health indicator (NHI) that informs you whether there were Amazon
     * Web Services network issues for one or more of the network flows tracked by a monitor, during a time period that
     * you choose.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMonitorRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMonitorRequest#builder()}
     * </p>
     *
     * @param createMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.CreateMonitorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ConflictException The requested resource is in use.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.CreateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/CreateMonitor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMonitorResponse> createMonitor(Consumer<CreateMonitorRequest.Builder> createMonitorRequest) {
        return createMonitor(CreateMonitorRequest.builder().applyMutation(createMonitorRequest).build());
    }

    /**
     * <p>
     * In Network Flow Monitor, you specify a scope for the service to generate metrics for. By using the scope, Network
     * Flow Monitor can generate a topology of all the resources to measure performance metrics for. When you create a
     * scope, you enable permissions for Network Flow Monitor.
     * </p>
     * <p>
     * A scope is a Region-account pair or multiple Region-account pairs. Network Flow Monitor uses your scope to
     * determine all the resources (the topology) where Network Flow Monitor will gather network flow performance
     * metrics for you. To provide performance metrics, Network Flow Monitor uses the data that is sent by the Network
     * Flow Monitor agents you install on the resources.
     * </p>
     * <p>
     * To define the Region-account pairs for your scope, the Network Flow Monitor API uses the following constucts,
     * which allow for future flexibility in defining scopes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Targets</i>, which are arrays of targetResources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Target resources</i>, which are Region-targetIdentifier pairs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Target identifiers</i>, made up of a targetID (currently always an account ID) and a targetType (currently
     * always an account).
     * </p>
     * </li>
     * </ul>
     *
     * @param createScopeRequest
     * @return A Java Future containing the result of the CreateScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ConflictException The requested resource is in use.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.CreateScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/CreateScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateScopeResponse> createScope(CreateScopeRequest createScopeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * In Network Flow Monitor, you specify a scope for the service to generate metrics for. By using the scope, Network
     * Flow Monitor can generate a topology of all the resources to measure performance metrics for. When you create a
     * scope, you enable permissions for Network Flow Monitor.
     * </p>
     * <p>
     * A scope is a Region-account pair or multiple Region-account pairs. Network Flow Monitor uses your scope to
     * determine all the resources (the topology) where Network Flow Monitor will gather network flow performance
     * metrics for you. To provide performance metrics, Network Flow Monitor uses the data that is sent by the Network
     * Flow Monitor agents you install on the resources.
     * </p>
     * <p>
     * To define the Region-account pairs for your scope, the Network Flow Monitor API uses the following constucts,
     * which allow for future flexibility in defining scopes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Targets</i>, which are arrays of targetResources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Target resources</i>, which are Region-targetIdentifier pairs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Target identifiers</i>, made up of a targetID (currently always an account ID) and a targetType (currently
     * always an account).
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateScopeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateScopeRequest#builder()}
     * </p>
     *
     * @param createScopeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.CreateScopeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ConflictException The requested resource is in use.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.CreateScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/CreateScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateScopeResponse> createScope(Consumer<CreateScopeRequest.Builder> createScopeRequest) {
        return createScope(CreateScopeRequest.builder().applyMutation(createScopeRequest).build());
    }

    /**
     * <p>
     * Deletes a monitor in Network Flow Monitor.
     * </p>
     *
     * @param deleteMonitorRequest
     * @return A Java Future containing the result of the DeleteMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ConflictException The requested resource is in use.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.DeleteMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/DeleteMonitor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMonitorResponse> deleteMonitor(DeleteMonitorRequest deleteMonitorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a monitor in Network Flow Monitor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMonitorRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMonitorRequest#builder()}
     * </p>
     *
     * @param deleteMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.DeleteMonitorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ConflictException The requested resource is in use.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.DeleteMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/DeleteMonitor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMonitorResponse> deleteMonitor(Consumer<DeleteMonitorRequest.Builder> deleteMonitorRequest) {
        return deleteMonitor(DeleteMonitorRequest.builder().applyMutation(deleteMonitorRequest).build());
    }

    /**
     * <p>
     * Deletes a scope that has been defined.
     * </p>
     *
     * @param deleteScopeRequest
     * @return A Java Future containing the result of the DeleteScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ConflictException The requested resource is in use.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.DeleteScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/DeleteScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteScopeResponse> deleteScope(DeleteScopeRequest deleteScopeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a scope that has been defined.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScopeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteScopeRequest#builder()}
     * </p>
     *
     * @param deleteScopeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.DeleteScopeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ConflictException The requested resource is in use.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.DeleteScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/DeleteScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteScopeResponse> deleteScope(Consumer<DeleteScopeRequest.Builder> deleteScopeRequest) {
        return deleteScope(DeleteScopeRequest.builder().applyMutation(deleteScopeRequest).build());
    }

    /**
     * <p>
     * Gets information about a monitor in Network Flow Monitor based on a monitor name. The information returned
     * includes the Amazon Resource Name (ARN), create time, modified time, resources included in the monitor, and
     * status information.
     * </p>
     *
     * @param getMonitorRequest
     * @return A Java Future containing the result of the GetMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetMonitor" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMonitorResponse> getMonitor(GetMonitorRequest getMonitorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a monitor in Network Flow Monitor based on a monitor name. The information returned
     * includes the Amazon Resource Name (ARN), create time, modified time, resources included in the monitor, and
     * status information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMonitorRequest.Builder} avoiding the need to
     * create one manually via {@link GetMonitorRequest#builder()}
     * </p>
     *
     * @param getMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetMonitorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetMonitor" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMonitorResponse> getMonitor(Consumer<GetMonitorRequest.Builder> getMonitorRequest) {
        return getMonitor(GetMonitorRequest.builder().applyMutation(getMonitorRequest).build());
    }

    /**
     * <p>
     * Return the data for a query with the Network Flow Monitor query interface. You specify the query that you want to
     * return results for by providing a query ID and a monitor name. This query returns the top contributors for a
     * specific monitor.
     * </p>
     * <p>
     * Create a query ID for this call by calling the corresponding API call to start the query,
     * <code>StartQueryMonitorTopContributors</code>. Use the scope ID that was returned for your account by
     * <code>CreateScope</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     *
     * @param getQueryResultsMonitorTopContributorsRequest
     * @return A Java Future containing the result of the GetQueryResultsMonitorTopContributors operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetQueryResultsMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQueryResultsMonitorTopContributorsResponse> getQueryResultsMonitorTopContributors(
            GetQueryResultsMonitorTopContributorsRequest getQueryResultsMonitorTopContributorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Return the data for a query with the Network Flow Monitor query interface. You specify the query that you want to
     * return results for by providing a query ID and a monitor name. This query returns the top contributors for a
     * specific monitor.
     * </p>
     * <p>
     * Create a query ID for this call by calling the corresponding API call to start the query,
     * <code>StartQueryMonitorTopContributors</code>. Use the scope ID that was returned for your account by
     * <code>CreateScope</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetQueryResultsMonitorTopContributorsRequest.Builder} avoiding the need to create one manually via
     * {@link GetQueryResultsMonitorTopContributorsRequest#builder()}
     * </p>
     *
     * @param getQueryResultsMonitorTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetQueryResultsMonitorTopContributors operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetQueryResultsMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQueryResultsMonitorTopContributorsResponse> getQueryResultsMonitorTopContributors(
            Consumer<GetQueryResultsMonitorTopContributorsRequest.Builder> getQueryResultsMonitorTopContributorsRequest) {
        return getQueryResultsMonitorTopContributors(GetQueryResultsMonitorTopContributorsRequest.builder()
                .applyMutation(getQueryResultsMonitorTopContributorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getQueryResultsMonitorTopContributors(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsMonitorTopContributorsPublisher publisher = client.getQueryResultsMonitorTopContributorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsMonitorTopContributorsPublisher publisher = client.getQueryResultsMonitorTopContributorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getQueryResultsMonitorTopContributors(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getQueryResultsMonitorTopContributorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetQueryResultsMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryResultsMonitorTopContributorsPublisher getQueryResultsMonitorTopContributorsPaginator(
            GetQueryResultsMonitorTopContributorsRequest getQueryResultsMonitorTopContributorsRequest) {
        return new GetQueryResultsMonitorTopContributorsPublisher(this, getQueryResultsMonitorTopContributorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getQueryResultsMonitorTopContributors(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsMonitorTopContributorsPublisher publisher = client.getQueryResultsMonitorTopContributorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsMonitorTopContributorsPublisher publisher = client.getQueryResultsMonitorTopContributorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getQueryResultsMonitorTopContributors(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetQueryResultsMonitorTopContributorsRequest.Builder} avoiding the need to create one manually via
     * {@link GetQueryResultsMonitorTopContributorsRequest#builder()}
     * </p>
     *
     * @param getQueryResultsMonitorTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetQueryResultsMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryResultsMonitorTopContributorsPublisher getQueryResultsMonitorTopContributorsPaginator(
            Consumer<GetQueryResultsMonitorTopContributorsRequest.Builder> getQueryResultsMonitorTopContributorsRequest) {
        return getQueryResultsMonitorTopContributorsPaginator(GetQueryResultsMonitorTopContributorsRequest.builder()
                .applyMutation(getQueryResultsMonitorTopContributorsRequest).build());
    }

    /**
     * <p>
     * Return the data for a query with the Network Flow Monitor query interface. You specify the query that you want to
     * return results for by providing a query ID and a monitor name.
     * </p>
     * <p>
     * This query returns the top contributors for a scope for workload insights. Workload insights provide a high level
     * view of network flow performance data collected by agents. To return the data for the top contributors, see
     * <code>GetQueryResultsWorkloadInsightsTopContributorsData</code>.
     * </p>
     * <p>
     * Create a query ID for this call by calling the corresponding API call to start the query,
     * <code>StartQueryWorkloadInsightsTopContributors</code>. Use the scope ID that was returned for your account by
     * <code>CreateScope</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     *
     * @param getQueryResultsWorkloadInsightsTopContributorsRequest
     * @return A Java Future containing the result of the GetQueryResultsWorkloadInsightsTopContributors operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetQueryResultsWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQueryResultsWorkloadInsightsTopContributorsResponse> getQueryResultsWorkloadInsightsTopContributors(
            GetQueryResultsWorkloadInsightsTopContributorsRequest getQueryResultsWorkloadInsightsTopContributorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Return the data for a query with the Network Flow Monitor query interface. You specify the query that you want to
     * return results for by providing a query ID and a monitor name.
     * </p>
     * <p>
     * This query returns the top contributors for a scope for workload insights. Workload insights provide a high level
     * view of network flow performance data collected by agents. To return the data for the top contributors, see
     * <code>GetQueryResultsWorkloadInsightsTopContributorsData</code>.
     * </p>
     * <p>
     * Create a query ID for this call by calling the corresponding API call to start the query,
     * <code>StartQueryWorkloadInsightsTopContributors</code>. Use the scope ID that was returned for your account by
     * <code>CreateScope</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetQueryResultsWorkloadInsightsTopContributorsRequest.Builder} avoiding the need to create one manually
     * via {@link GetQueryResultsWorkloadInsightsTopContributorsRequest#builder()}
     * </p>
     *
     * @param getQueryResultsWorkloadInsightsTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetQueryResultsWorkloadInsightsTopContributors operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetQueryResultsWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQueryResultsWorkloadInsightsTopContributorsResponse> getQueryResultsWorkloadInsightsTopContributors(
            Consumer<GetQueryResultsWorkloadInsightsTopContributorsRequest.Builder> getQueryResultsWorkloadInsightsTopContributorsRequest) {
        return getQueryResultsWorkloadInsightsTopContributors(GetQueryResultsWorkloadInsightsTopContributorsRequest.builder()
                .applyMutation(getQueryResultsWorkloadInsightsTopContributorsRequest).build());
    }

    /**
     * <p>
     * Return the data for a query with the Network Flow Monitor query interface. Specify the query that you want to
     * return results for by providing a query ID and a scope ID.
     * </p>
     * <p>
     * This query returns the data for top contributors for workload insights for a specific scope. Workload insights
     * provide a high level view of network flow performance data collected by agents for a scope. To return just the
     * top contributors, see <code>GetQueryResultsWorkloadInsightsTopContributors</code>.
     * </p>
     * <p>
     * Create a query ID for this call by calling the corresponding API call to start the query,
     * <code>StartQueryWorkloadInsightsTopContributorsData</code>. Use the scope ID that was returned for your account
     * by <code>CreateScope</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <p>
     * The top contributor network flows overall are for a specific metric type, for example, the number of
     * retransmissions.
     * </p>
     *
     * @param getQueryResultsWorkloadInsightsTopContributorsDataRequest
     * @return A Java Future containing the result of the GetQueryResultsWorkloadInsightsTopContributorsData operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetQueryResultsWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQueryResultsWorkloadInsightsTopContributorsDataResponse> getQueryResultsWorkloadInsightsTopContributorsData(
            GetQueryResultsWorkloadInsightsTopContributorsDataRequest getQueryResultsWorkloadInsightsTopContributorsDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Return the data for a query with the Network Flow Monitor query interface. Specify the query that you want to
     * return results for by providing a query ID and a scope ID.
     * </p>
     * <p>
     * This query returns the data for top contributors for workload insights for a specific scope. Workload insights
     * provide a high level view of network flow performance data collected by agents for a scope. To return just the
     * top contributors, see <code>GetQueryResultsWorkloadInsightsTopContributors</code>.
     * </p>
     * <p>
     * Create a query ID for this call by calling the corresponding API call to start the query,
     * <code>StartQueryWorkloadInsightsTopContributorsData</code>. Use the scope ID that was returned for your account
     * by <code>CreateScope</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <p>
     * The top contributor network flows overall are for a specific metric type, for example, the number of
     * retransmissions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetQueryResultsWorkloadInsightsTopContributorsDataRequest.Builder} avoiding the need to create one
     * manually via {@link GetQueryResultsWorkloadInsightsTopContributorsDataRequest#builder()}
     * </p>
     *
     * @param getQueryResultsWorkloadInsightsTopContributorsDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetQueryResultsWorkloadInsightsTopContributorsData operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetQueryResultsWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQueryResultsWorkloadInsightsTopContributorsDataResponse> getQueryResultsWorkloadInsightsTopContributorsData(
            Consumer<GetQueryResultsWorkloadInsightsTopContributorsDataRequest.Builder> getQueryResultsWorkloadInsightsTopContributorsDataRequest) {
        return getQueryResultsWorkloadInsightsTopContributorsData(GetQueryResultsWorkloadInsightsTopContributorsDataRequest
                .builder().applyMutation(getQueryResultsWorkloadInsightsTopContributorsDataRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getQueryResultsWorkloadInsightsTopContributorsData(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsDataPublisher publisher = client.getQueryResultsWorkloadInsightsTopContributorsDataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsDataPublisher publisher = client.getQueryResultsWorkloadInsightsTopContributorsDataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getQueryResultsWorkloadInsightsTopContributorsData(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataRequest)}
     * operation.</b>
     * </p>
     *
     * @param getQueryResultsWorkloadInsightsTopContributorsDataRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetQueryResultsWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryResultsWorkloadInsightsTopContributorsDataPublisher getQueryResultsWorkloadInsightsTopContributorsDataPaginator(
            GetQueryResultsWorkloadInsightsTopContributorsDataRequest getQueryResultsWorkloadInsightsTopContributorsDataRequest) {
        return new GetQueryResultsWorkloadInsightsTopContributorsDataPublisher(this,
                getQueryResultsWorkloadInsightsTopContributorsDataRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getQueryResultsWorkloadInsightsTopContributorsData(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsDataPublisher publisher = client.getQueryResultsWorkloadInsightsTopContributorsDataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsDataPublisher publisher = client.getQueryResultsWorkloadInsightsTopContributorsDataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getQueryResultsWorkloadInsightsTopContributorsData(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetQueryResultsWorkloadInsightsTopContributorsDataRequest.Builder} avoiding the need to create one
     * manually via {@link GetQueryResultsWorkloadInsightsTopContributorsDataRequest#builder()}
     * </p>
     *
     * @param getQueryResultsWorkloadInsightsTopContributorsDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsDataRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetQueryResultsWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryResultsWorkloadInsightsTopContributorsDataPublisher getQueryResultsWorkloadInsightsTopContributorsDataPaginator(
            Consumer<GetQueryResultsWorkloadInsightsTopContributorsDataRequest.Builder> getQueryResultsWorkloadInsightsTopContributorsDataRequest) {
        return getQueryResultsWorkloadInsightsTopContributorsDataPaginator(GetQueryResultsWorkloadInsightsTopContributorsDataRequest
                .builder().applyMutation(getQueryResultsWorkloadInsightsTopContributorsDataRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getQueryResultsWorkloadInsightsTopContributors(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsPublisher publisher = client.getQueryResultsWorkloadInsightsTopContributorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsPublisher publisher = client.getQueryResultsWorkloadInsightsTopContributorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getQueryResultsWorkloadInsightsTopContributors(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getQueryResultsWorkloadInsightsTopContributorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetQueryResultsWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryResultsWorkloadInsightsTopContributorsPublisher getQueryResultsWorkloadInsightsTopContributorsPaginator(
            GetQueryResultsWorkloadInsightsTopContributorsRequest getQueryResultsWorkloadInsightsTopContributorsRequest) {
        return new GetQueryResultsWorkloadInsightsTopContributorsPublisher(this,
                getQueryResultsWorkloadInsightsTopContributorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getQueryResultsWorkloadInsightsTopContributors(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsPublisher publisher = client.getQueryResultsWorkloadInsightsTopContributorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.GetQueryResultsWorkloadInsightsTopContributorsPublisher publisher = client.getQueryResultsWorkloadInsightsTopContributorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getQueryResultsWorkloadInsightsTopContributors(software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetQueryResultsWorkloadInsightsTopContributorsRequest.Builder} avoiding the need to create one manually
     * via {@link GetQueryResultsWorkloadInsightsTopContributorsRequest#builder()}
     * </p>
     *
     * @param getQueryResultsWorkloadInsightsTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetQueryResultsWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryResultsWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryResultsWorkloadInsightsTopContributorsPublisher getQueryResultsWorkloadInsightsTopContributorsPaginator(
            Consumer<GetQueryResultsWorkloadInsightsTopContributorsRequest.Builder> getQueryResultsWorkloadInsightsTopContributorsRequest) {
        return getQueryResultsWorkloadInsightsTopContributorsPaginator(GetQueryResultsWorkloadInsightsTopContributorsRequest
                .builder().applyMutation(getQueryResultsWorkloadInsightsTopContributorsRequest).build());
    }

    /**
     * <p>
     * Returns the current status of a query for the Network Flow Monitor query interface, for a specified query ID and
     * monitor. This call returns the query status for the top contributors for a monitor.
     * </p>
     * <p>
     * When you create a query, use this call to check the status of the query to make sure that it has has
     * <code>SUCCEEDED</code> before you review the results. Use the same query ID that you used for the corresponding
     * API call to start (create) the query, <code>StartQueryMonitorTopContributors</code>.
     * </p>
     * <p>
     * When you run a query, use this call to check the status of the query to make sure that the query has
     * <code>SUCCEEDED</code> before you review the results.
     * </p>
     *
     * @param getQueryStatusMonitorTopContributorsRequest
     * @return A Java Future containing the result of the GetQueryStatusMonitorTopContributors operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetQueryStatusMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryStatusMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQueryStatusMonitorTopContributorsResponse> getQueryStatusMonitorTopContributors(
            GetQueryStatusMonitorTopContributorsRequest getQueryStatusMonitorTopContributorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current status of a query for the Network Flow Monitor query interface, for a specified query ID and
     * monitor. This call returns the query status for the top contributors for a monitor.
     * </p>
     * <p>
     * When you create a query, use this call to check the status of the query to make sure that it has has
     * <code>SUCCEEDED</code> before you review the results. Use the same query ID that you used for the corresponding
     * API call to start (create) the query, <code>StartQueryMonitorTopContributors</code>.
     * </p>
     * <p>
     * When you run a query, use this call to check the status of the query to make sure that the query has
     * <code>SUCCEEDED</code> before you review the results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetQueryStatusMonitorTopContributorsRequest.Builder} avoiding the need to create one manually via
     * {@link GetQueryStatusMonitorTopContributorsRequest#builder()}
     * </p>
     *
     * @param getQueryStatusMonitorTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetQueryStatusMonitorTopContributorsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetQueryStatusMonitorTopContributors operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetQueryStatusMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryStatusMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQueryStatusMonitorTopContributorsResponse> getQueryStatusMonitorTopContributors(
            Consumer<GetQueryStatusMonitorTopContributorsRequest.Builder> getQueryStatusMonitorTopContributorsRequest) {
        return getQueryStatusMonitorTopContributors(GetQueryStatusMonitorTopContributorsRequest.builder()
                .applyMutation(getQueryStatusMonitorTopContributorsRequest).build());
    }

    /**
     * <p>
     * Return the data for a query with the Network Flow Monitor query interface. Specify the query that you want to
     * return results for by providing a query ID and a monitor name. This query returns the top contributors for
     * workload insights.
     * </p>
     * <p>
     * When you start a query, use this call to check the status of the query to make sure that it has has
     * <code>SUCCEEDED</code> before you review the results. Use the same query ID that you used for the corresponding
     * API call to start the query, <code>StartQueryWorkloadInsightsTopContributors</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     *
     * @param getQueryStatusWorkloadInsightsTopContributorsRequest
     * @return A Java Future containing the result of the GetQueryStatusWorkloadInsightsTopContributors operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetQueryStatusWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryStatusWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQueryStatusWorkloadInsightsTopContributorsResponse> getQueryStatusWorkloadInsightsTopContributors(
            GetQueryStatusWorkloadInsightsTopContributorsRequest getQueryStatusWorkloadInsightsTopContributorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Return the data for a query with the Network Flow Monitor query interface. Specify the query that you want to
     * return results for by providing a query ID and a monitor name. This query returns the top contributors for
     * workload insights.
     * </p>
     * <p>
     * When you start a query, use this call to check the status of the query to make sure that it has has
     * <code>SUCCEEDED</code> before you review the results. Use the same query ID that you used for the corresponding
     * API call to start the query, <code>StartQueryWorkloadInsightsTopContributors</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetQueryStatusWorkloadInsightsTopContributorsRequest.Builder} avoiding the need to create one manually via
     * {@link GetQueryStatusWorkloadInsightsTopContributorsRequest#builder()}
     * </p>
     *
     * @param getQueryStatusWorkloadInsightsTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetQueryStatusWorkloadInsightsTopContributorsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetQueryStatusWorkloadInsightsTopContributors operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetQueryStatusWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryStatusWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQueryStatusWorkloadInsightsTopContributorsResponse> getQueryStatusWorkloadInsightsTopContributors(
            Consumer<GetQueryStatusWorkloadInsightsTopContributorsRequest.Builder> getQueryStatusWorkloadInsightsTopContributorsRequest) {
        return getQueryStatusWorkloadInsightsTopContributors(GetQueryStatusWorkloadInsightsTopContributorsRequest.builder()
                .applyMutation(getQueryStatusWorkloadInsightsTopContributorsRequest).build());
    }

    /**
     * <p>
     * Returns the current status of a query for the Network Flow Monitor query interface, for a specified query ID and
     * monitor. This call returns the query status for the top contributors data for workload insights.
     * </p>
     * <p>
     * When you start a query, use this call to check the status of the query to make sure that it has has
     * <code>SUCCEEDED</code> before you review the results. Use the same query ID that you used for the corresponding
     * API call to start the query, <code>StartQueryWorkloadInsightsTopContributorsData</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <p>
     * The top contributor network flows overall are for a specific metric type, for example, the number of
     * retransmissions.
     * </p>
     *
     * @param getQueryStatusWorkloadInsightsTopContributorsDataRequest
     * @return A Java Future containing the result of the GetQueryStatusWorkloadInsightsTopContributorsData operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetQueryStatusWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryStatusWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQueryStatusWorkloadInsightsTopContributorsDataResponse> getQueryStatusWorkloadInsightsTopContributorsData(
            GetQueryStatusWorkloadInsightsTopContributorsDataRequest getQueryStatusWorkloadInsightsTopContributorsDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current status of a query for the Network Flow Monitor query interface, for a specified query ID and
     * monitor. This call returns the query status for the top contributors data for workload insights.
     * </p>
     * <p>
     * When you start a query, use this call to check the status of the query to make sure that it has has
     * <code>SUCCEEDED</code> before you review the results. Use the same query ID that you used for the corresponding
     * API call to start the query, <code>StartQueryWorkloadInsightsTopContributorsData</code>.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <p>
     * The top contributor network flows overall are for a specific metric type, for example, the number of
     * retransmissions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetQueryStatusWorkloadInsightsTopContributorsDataRequest.Builder} avoiding the need to create one manually
     * via {@link GetQueryStatusWorkloadInsightsTopContributorsDataRequest#builder()}
     * </p>
     *
     * @param getQueryStatusWorkloadInsightsTopContributorsDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetQueryStatusWorkloadInsightsTopContributorsDataRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetQueryStatusWorkloadInsightsTopContributorsData operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetQueryStatusWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetQueryStatusWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQueryStatusWorkloadInsightsTopContributorsDataResponse> getQueryStatusWorkloadInsightsTopContributorsData(
            Consumer<GetQueryStatusWorkloadInsightsTopContributorsDataRequest.Builder> getQueryStatusWorkloadInsightsTopContributorsDataRequest) {
        return getQueryStatusWorkloadInsightsTopContributorsData(GetQueryStatusWorkloadInsightsTopContributorsDataRequest
                .builder().applyMutation(getQueryStatusWorkloadInsightsTopContributorsDataRequest).build());
    }

    /**
     * <p>
     * Gets information about a scope, including the name, status, tags, and target details. The scope in Network Flow
     * Monitor is an account.
     * </p>
     *
     * @param getScopeRequest
     * @return A Java Future containing the result of the GetScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetScope" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetScopeResponse> getScope(GetScopeRequest getScopeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a scope, including the name, status, tags, and target details. The scope in Network Flow
     * Monitor is an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetScopeRequest.Builder} avoiding the need to
     * create one manually via {@link GetScopeRequest#builder()}
     * </p>
     *
     * @param getScopeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.GetScopeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.GetScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/GetScope" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetScopeResponse> getScope(Consumer<GetScopeRequest.Builder> getScopeRequest) {
        return getScope(GetScopeRequest.builder().applyMutation(getScopeRequest).build());
    }

    /**
     * <p>
     * List all monitors in an account. Optionally, you can list only monitors that have a specific status, by using the
     * <code>STATUS</code> parameter.
     * </p>
     *
     * @param listMonitorsRequest
     * @return A Java Future containing the result of the ListMonitors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListMonitors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMonitorsResponse> listMonitors(ListMonitorsRequest listMonitorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all monitors in an account. Optionally, you can list only monitors that have a specific status, by using the
     * <code>STATUS</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMonitorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMonitorsRequest#builder()}
     * </p>
     *
     * @param listMonitorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMonitors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListMonitors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMonitorsResponse> listMonitors(Consumer<ListMonitorsRequest.Builder> listMonitorsRequest) {
        return listMonitors(ListMonitorsRequest.builder().applyMutation(listMonitorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMonitors(software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.ListMonitorsPublisher publisher = client.listMonitorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.ListMonitorsPublisher publisher = client.listMonitorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitors(software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMonitorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListMonitors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMonitorsPublisher listMonitorsPaginator(ListMonitorsRequest listMonitorsRequest) {
        return new ListMonitorsPublisher(this, listMonitorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMonitors(software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.ListMonitorsPublisher publisher = client.listMonitorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.ListMonitorsPublisher publisher = client.listMonitorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitors(software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMonitorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMonitorsRequest#builder()}
     * </p>
     *
     * @param listMonitorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListMonitors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMonitorsPublisher listMonitorsPaginator(Consumer<ListMonitorsRequest.Builder> listMonitorsRequest) {
        return listMonitorsPaginator(ListMonitorsRequest.builder().applyMutation(listMonitorsRequest).build());
    }

    /**
     * <p>
     * List all the scopes for an account.
     * </p>
     *
     * @param listScopesRequest
     * @return A Java Future containing the result of the ListScopes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.ListScopes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListScopes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListScopesResponse> listScopes(ListScopesRequest listScopesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all the scopes for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScopesRequest.Builder} avoiding the need to
     * create one manually via {@link ListScopesRequest#builder()}
     * </p>
     *
     * @param listScopesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.ListScopesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListScopes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.ListScopes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListScopes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListScopesResponse> listScopes(Consumer<ListScopesRequest.Builder> listScopesRequest) {
        return listScopes(ListScopesRequest.builder().applyMutation(listScopesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listScopes(software.amazon.awssdk.services.networkflowmonitor.model.ListScopesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.ListScopesPublisher publisher = client.listScopesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.ListScopesPublisher publisher = client.listScopesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkflowmonitor.model.ListScopesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkflowmonitor.model.ListScopesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScopes(software.amazon.awssdk.services.networkflowmonitor.model.ListScopesRequest)} operation.</b>
     * </p>
     *
     * @param listScopesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.ListScopes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListScopes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListScopesPublisher listScopesPaginator(ListScopesRequest listScopesRequest) {
        return new ListScopesPublisher(this, listScopesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listScopes(software.amazon.awssdk.services.networkflowmonitor.model.ListScopesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.ListScopesPublisher publisher = client.listScopesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkflowmonitor.paginators.ListScopesPublisher publisher = client.listScopesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkflowmonitor.model.ListScopesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkflowmonitor.model.ListScopesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScopes(software.amazon.awssdk.services.networkflowmonitor.model.ListScopesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScopesRequest.Builder} avoiding the need to
     * create one manually via {@link ListScopesRequest#builder()}
     * </p>
     *
     * @param listScopesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.ListScopesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.ListScopes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListScopes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListScopesPublisher listScopesPaginator(Consumer<ListScopesRequest.Builder> listScopesRequest) {
        return listScopesPaginator(ListScopesRequest.builder().applyMutation(listScopesRequest).build());
    }

    /**
     * <p>
     * Returns all the tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ConflictException The requested resource is in use.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all the tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ConflictException The requested resource is in use.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Create a query that you can use with the Network Flow Monitor query interface to return the top contributors for
     * a monitor. Specify the monitor that you want to create the query for.
     * </p>
     * <p>
     * The call returns a query ID that you can use with <a href=
     * "https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsMonitorTopContributors.html">
     * GetQueryResultsMonitorTopContributors</a> to run the query and return the top contributors for a specific
     * monitor.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable APIs for the top contributors that you want to be returned.
     * </p>
     *
     * @param startQueryMonitorTopContributorsRequest
     * @return A Java Future containing the result of the StartQueryMonitorTopContributors operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.StartQueryMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StartQueryMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartQueryMonitorTopContributorsResponse> startQueryMonitorTopContributors(
            StartQueryMonitorTopContributorsRequest startQueryMonitorTopContributorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a query that you can use with the Network Flow Monitor query interface to return the top contributors for
     * a monitor. Specify the monitor that you want to create the query for.
     * </p>
     * <p>
     * The call returns a query ID that you can use with <a href=
     * "https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsMonitorTopContributors.html">
     * GetQueryResultsMonitorTopContributors</a> to run the query and return the top contributors for a specific
     * monitor.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable APIs for the top contributors that you want to be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartQueryMonitorTopContributorsRequest.Builder}
     * avoiding the need to create one manually via {@link StartQueryMonitorTopContributorsRequest#builder()}
     * </p>
     *
     * @param startQueryMonitorTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.StartQueryMonitorTopContributorsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartQueryMonitorTopContributors operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.StartQueryMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StartQueryMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartQueryMonitorTopContributorsResponse> startQueryMonitorTopContributors(
            Consumer<StartQueryMonitorTopContributorsRequest.Builder> startQueryMonitorTopContributorsRequest) {
        return startQueryMonitorTopContributors(StartQueryMonitorTopContributorsRequest.builder()
                .applyMutation(startQueryMonitorTopContributorsRequest).build());
    }

    /**
     * <p>
     * Create a query with the Network Flow Monitor query interface that you can run to return workload insights top
     * contributors. Specify the scope that you want to create a query for.
     * </p>
     * <p>
     * The call returns a query ID that you can use with <a href=
     * "https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsWorkloadInsightsTopContributors.html"
     * > GetQueryResultsWorkloadInsightsTopContributors</a> to run the query and return the top contributors for the
     * workload insights for a scope.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable APIs for the top contributors that you want to be returned.
     * </p>
     *
     * @param startQueryWorkloadInsightsTopContributorsRequest
     * @return A Java Future containing the result of the StartQueryWorkloadInsightsTopContributors operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.StartQueryWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StartQueryWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartQueryWorkloadInsightsTopContributorsResponse> startQueryWorkloadInsightsTopContributors(
            StartQueryWorkloadInsightsTopContributorsRequest startQueryWorkloadInsightsTopContributorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a query with the Network Flow Monitor query interface that you can run to return workload insights top
     * contributors. Specify the scope that you want to create a query for.
     * </p>
     * <p>
     * The call returns a query ID that you can use with <a href=
     * "https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsWorkloadInsightsTopContributors.html"
     * > GetQueryResultsWorkloadInsightsTopContributors</a> to run the query and return the top contributors for the
     * workload insights for a scope.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable APIs for the top contributors that you want to be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StartQueryWorkloadInsightsTopContributorsRequest.Builder} avoiding the need to create one manually via
     * {@link StartQueryWorkloadInsightsTopContributorsRequest#builder()}
     * </p>
     *
     * @param startQueryWorkloadInsightsTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.StartQueryWorkloadInsightsTopContributorsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartQueryWorkloadInsightsTopContributors operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.StartQueryWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StartQueryWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartQueryWorkloadInsightsTopContributorsResponse> startQueryWorkloadInsightsTopContributors(
            Consumer<StartQueryWorkloadInsightsTopContributorsRequest.Builder> startQueryWorkloadInsightsTopContributorsRequest) {
        return startQueryWorkloadInsightsTopContributors(StartQueryWorkloadInsightsTopContributorsRequest.builder()
                .applyMutation(startQueryWorkloadInsightsTopContributorsRequest).build());
    }

    /**
     * <p>
     * Create a query with the Network Flow Monitor query interface that you can run to return data for workload
     * insights top contributors. Specify the scope that you want to create a query for.
     * </p>
     * <p>
     * The call returns a query ID that you can use with <a href=
     * "https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsWorkloadInsightsTopContributorsData.html"
     * > GetQueryResultsWorkloadInsightsTopContributorsData</a> to run the query and return the data for the top
     * contributors for the workload insights for a scope.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     *
     * @param startQueryWorkloadInsightsTopContributorsDataRequest
     * @return A Java Future containing the result of the StartQueryWorkloadInsightsTopContributorsData operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.StartQueryWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StartQueryWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartQueryWorkloadInsightsTopContributorsDataResponse> startQueryWorkloadInsightsTopContributorsData(
            StartQueryWorkloadInsightsTopContributorsDataRequest startQueryWorkloadInsightsTopContributorsDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a query with the Network Flow Monitor query interface that you can run to return data for workload
     * insights top contributors. Specify the scope that you want to create a query for.
     * </p>
     * <p>
     * The call returns a query ID that you can use with <a href=
     * "https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsWorkloadInsightsTopContributorsData.html"
     * > GetQueryResultsWorkloadInsightsTopContributorsData</a> to run the query and return the data for the top
     * contributors for the workload insights for a scope.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StartQueryWorkloadInsightsTopContributorsDataRequest.Builder} avoiding the need to create one manually via
     * {@link StartQueryWorkloadInsightsTopContributorsDataRequest#builder()}
     * </p>
     *
     * @param startQueryWorkloadInsightsTopContributorsDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.StartQueryWorkloadInsightsTopContributorsDataRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartQueryWorkloadInsightsTopContributorsData operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.StartQueryWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StartQueryWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartQueryWorkloadInsightsTopContributorsDataResponse> startQueryWorkloadInsightsTopContributorsData(
            Consumer<StartQueryWorkloadInsightsTopContributorsDataRequest.Builder> startQueryWorkloadInsightsTopContributorsDataRequest) {
        return startQueryWorkloadInsightsTopContributorsData(StartQueryWorkloadInsightsTopContributorsDataRequest.builder()
                .applyMutation(startQueryWorkloadInsightsTopContributorsDataRequest).build());
    }

    /**
     * <p>
     * Stop a top contributors query for a monitor. Specify the query that you want to stop by providing a query ID and
     * a monitor name.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     *
     * @param stopQueryMonitorTopContributorsRequest
     * @return A Java Future containing the result of the StopQueryMonitorTopContributors operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.StopQueryMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StopQueryMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopQueryMonitorTopContributorsResponse> stopQueryMonitorTopContributors(
            StopQueryMonitorTopContributorsRequest stopQueryMonitorTopContributorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stop a top contributors query for a monitor. Specify the query that you want to stop by providing a query ID and
     * a monitor name.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopQueryMonitorTopContributorsRequest.Builder}
     * avoiding the need to create one manually via {@link StopQueryMonitorTopContributorsRequest#builder()}
     * </p>
     *
     * @param stopQueryMonitorTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.StopQueryMonitorTopContributorsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StopQueryMonitorTopContributors operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.StopQueryMonitorTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StopQueryMonitorTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopQueryMonitorTopContributorsResponse> stopQueryMonitorTopContributors(
            Consumer<StopQueryMonitorTopContributorsRequest.Builder> stopQueryMonitorTopContributorsRequest) {
        return stopQueryMonitorTopContributors(StopQueryMonitorTopContributorsRequest.builder()
                .applyMutation(stopQueryMonitorTopContributorsRequest).build());
    }

    /**
     * <p>
     * Stop a top contributors query for workload insights. Specify the query that you want to stop by providing a query
     * ID and a scope ID.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     *
     * @param stopQueryWorkloadInsightsTopContributorsRequest
     * @return A Java Future containing the result of the StopQueryWorkloadInsightsTopContributors operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.StopQueryWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StopQueryWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopQueryWorkloadInsightsTopContributorsResponse> stopQueryWorkloadInsightsTopContributors(
            StopQueryWorkloadInsightsTopContributorsRequest stopQueryWorkloadInsightsTopContributorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stop a top contributors query for workload insights. Specify the query that you want to stop by providing a query
     * ID and a scope ID.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StopQueryWorkloadInsightsTopContributorsRequest.Builder} avoiding the need to create one manually via
     * {@link StopQueryWorkloadInsightsTopContributorsRequest#builder()}
     * </p>
     *
     * @param stopQueryWorkloadInsightsTopContributorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.StopQueryWorkloadInsightsTopContributorsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StopQueryWorkloadInsightsTopContributors operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.StopQueryWorkloadInsightsTopContributors
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StopQueryWorkloadInsightsTopContributors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopQueryWorkloadInsightsTopContributorsResponse> stopQueryWorkloadInsightsTopContributors(
            Consumer<StopQueryWorkloadInsightsTopContributorsRequest.Builder> stopQueryWorkloadInsightsTopContributorsRequest) {
        return stopQueryWorkloadInsightsTopContributors(StopQueryWorkloadInsightsTopContributorsRequest.builder()
                .applyMutation(stopQueryWorkloadInsightsTopContributorsRequest).build());
    }

    /**
     * <p>
     * Stop a top contributors data query for workload insights. Specify the query that you want to stop by providing a
     * query ID and a scope ID.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     *
     * @param stopQueryWorkloadInsightsTopContributorsDataRequest
     * @return A Java Future containing the result of the StopQueryWorkloadInsightsTopContributorsData operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.StopQueryWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StopQueryWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopQueryWorkloadInsightsTopContributorsDataResponse> stopQueryWorkloadInsightsTopContributorsData(
            StopQueryWorkloadInsightsTopContributorsDataRequest stopQueryWorkloadInsightsTopContributorsDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stop a top contributors data query for workload insights. Specify the query that you want to stop by providing a
     * query ID and a scope ID.
     * </p>
     * <p>
     * Top contributors in Network Flow Monitor are network flows with the highest values for a specific metric type.
     * Top contributors can be across all workload insights, for a given scope, or for a specific monitor. Use the
     * applicable call for the top contributors that you want to be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StopQueryWorkloadInsightsTopContributorsDataRequest.Builder} avoiding the need to create one manually via
     * {@link StopQueryWorkloadInsightsTopContributorsDataRequest#builder()}
     * </p>
     *
     * @param stopQueryWorkloadInsightsTopContributorsDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.StopQueryWorkloadInsightsTopContributorsDataRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StopQueryWorkloadInsightsTopContributorsData operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.StopQueryWorkloadInsightsTopContributorsData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/StopQueryWorkloadInsightsTopContributorsData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopQueryWorkloadInsightsTopContributorsDataResponse> stopQueryWorkloadInsightsTopContributorsData(
            Consumer<StopQueryWorkloadInsightsTopContributorsDataRequest.Builder> stopQueryWorkloadInsightsTopContributorsDataRequest) {
        return stopQueryWorkloadInsightsTopContributorsData(StopQueryWorkloadInsightsTopContributorsDataRequest.builder()
                .applyMutation(stopQueryWorkloadInsightsTopContributorsDataRequest).build());
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ConflictException The requested resource is in use.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ConflictException The requested resource is in use.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ConflictException The requested resource is in use.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ConflictException The requested resource is in use.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update a monitor to add or remove local or remote resources.
     * </p>
     *
     * @param updateMonitorRequest
     * @return A Java Future containing the result of the UpdateMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.UpdateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/UpdateMonitor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMonitorResponse> updateMonitor(UpdateMonitorRequest updateMonitorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a monitor to add or remove local or remote resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMonitorRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateMonitorRequest#builder()}
     * </p>
     *
     * @param updateMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.UpdateMonitorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.UpdateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/UpdateMonitor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMonitorResponse> updateMonitor(Consumer<UpdateMonitorRequest.Builder> updateMonitorRequest) {
        return updateMonitor(UpdateMonitorRequest.builder().applyMutation(updateMonitorRequest).build());
    }

    /**
     * <p>
     * Update a scope to add or remove resources that you want to be available for Network Flow Monitor to generate
     * metrics for, when you have active agents on those resources sending metrics reports to the Network Flow Monitor
     * backend.
     * </p>
     *
     * @param updateScopeRequest
     * @return A Java Future containing the result of the UpdateScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ConflictException The requested resource is in use.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.UpdateScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/UpdateScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateScopeResponse> updateScope(UpdateScopeRequest updateScopeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a scope to add or remove resources that you want to be available for Network Flow Monitor to generate
     * metrics for, when you have active agents on those resources sending metrics reports to the Network Flow Monitor
     * backend.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateScopeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateScopeRequest#builder()}
     * </p>
     *
     * @param updateScopeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkflowmonitor.model.UpdateScopeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded a service quota.</li>
     *         <li>ResourceNotFoundException The request specifies a resource that doesn't exist.</li>
     *         <li>ConflictException The requested resource is in use.</li>
     *         <li>ValidationException Invalid request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFlowMonitorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample NetworkFlowMonitorAsyncClient.UpdateScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/networkflowmonitor-2023-04-19/UpdateScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateScopeResponse> updateScope(Consumer<UpdateScopeRequest.Builder> updateScopeRequest) {
        return updateScope(UpdateScopeRequest.builder().applyMutation(updateScopeRequest).build());
    }

    @Override
    default NetworkFlowMonitorServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link NetworkFlowMonitorAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static NetworkFlowMonitorAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link NetworkFlowMonitorAsyncClient}.
     */
    static NetworkFlowMonitorAsyncClientBuilder builder() {
        return new DefaultNetworkFlowMonitorAsyncClientBuilder();
    }
}
