/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DestinationCategory {
    INTRA_AZ("INTRA_AZ"),
    INTER_AZ("INTER_AZ"),
    INTER_VPC("INTER_VPC"),
    UNCLASSIFIED("UNCLASSIFIED"),
    AMAZON_S3("AMAZON_S3"),
    AMAZON_DYNAMODB("AMAZON_DYNAMODB"),
    INTER_REGION("INTER_REGION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DestinationCategory> VALUE_MAP;
    private final String value;

    private DestinationCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DestinationCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DestinationCategory> knownValues() {
        EnumSet<DestinationCategory> knownValues = EnumSet.allOf(DestinationCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DestinationCategory.class, DestinationCategory::toString);
    }
}

