/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkflowmonitor.model.CreateMonitorInputLocalResourcesListCopier;
import software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource;
import software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource;
import software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResourcesCopier;
import software.amazon.awssdk.services.networkflowmonitor.model.NetworkFlowMonitorRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMonitorRequest
extends NetworkFlowMonitorRequest
implements ToCopyableBuilder<Builder, CreateMonitorRequest> {
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitorName").getter(CreateMonitorRequest.getter(CreateMonitorRequest::monitorName)).setter(CreateMonitorRequest.setter(Builder::monitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorName").build()}).build();
    private static final SdkField<List<MonitorLocalResource>> LOCAL_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("localResources").getter(CreateMonitorRequest.getter(CreateMonitorRequest::localResources)).setter(CreateMonitorRequest.setter(Builder::localResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonitorLocalResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MonitorRemoteResource>> REMOTE_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("remoteResources").getter(CreateMonitorRequest.getter(CreateMonitorRequest::remoteResources)).setter(CreateMonitorRequest.setter(Builder::remoteResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonitorRemoteResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCOPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scopeArn").getter(CreateMonitorRequest.getter(CreateMonitorRequest::scopeArn)).setter(CreateMonitorRequest.setter(Builder::scopeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopeArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateMonitorRequest.getter(CreateMonitorRequest::clientToken)).setter(CreateMonitorRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateMonitorRequest.getter(CreateMonitorRequest::tags)).setter(CreateMonitorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_NAME_FIELD, LOCAL_RESOURCES_FIELD, REMOTE_RESOURCES_FIELD, SCOPE_ARN_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMonitorRequest.memberNameToFieldInitializer();
    private final String monitorName;
    private final List<MonitorLocalResource> localResources;
    private final List<MonitorRemoteResource> remoteResources;
    private final String scopeArn;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateMonitorRequest(BuilderImpl builder) {
        super(builder);
        this.monitorName = builder.monitorName;
        this.localResources = builder.localResources;
        this.remoteResources = builder.remoteResources;
        this.scopeArn = builder.scopeArn;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String monitorName() {
        return this.monitorName;
    }

    public final boolean hasLocalResources() {
        return this.localResources != null && !(this.localResources instanceof SdkAutoConstructList);
    }

    public final List<MonitorLocalResource> localResources() {
        return this.localResources;
    }

    public final boolean hasRemoteResources() {
        return this.remoteResources != null && !(this.remoteResources instanceof SdkAutoConstructList);
    }

    public final List<MonitorRemoteResource> remoteResources() {
        return this.remoteResources;
    }

    public final String scopeArn() {
        return this.scopeArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocalResources() ? this.localResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoteResources() ? this.remoteResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMonitorRequest)) {
            return false;
        }
        CreateMonitorRequest other = (CreateMonitorRequest)((Object)obj);
        return Objects.equals(this.monitorName(), other.monitorName()) && this.hasLocalResources() == other.hasLocalResources() && Objects.equals(this.localResources(), other.localResources()) && this.hasRemoteResources() == other.hasRemoteResources() && Objects.equals(this.remoteResources(), other.remoteResources()) && Objects.equals(this.scopeArn(), other.scopeArn()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMonitorRequest").add("MonitorName", (Object)this.monitorName()).add("LocalResources", this.hasLocalResources() ? this.localResources() : null).add("RemoteResources", this.hasRemoteResources() ? this.remoteResources() : null).add("ScopeArn", (Object)this.scopeArn()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "monitorName": {
                return Optional.ofNullable(clazz.cast(this.monitorName()));
            }
            case "localResources": {
                return Optional.ofNullable(clazz.cast(this.localResources()));
            }
            case "remoteResources": {
                return Optional.ofNullable(clazz.cast(this.remoteResources()));
            }
            case "scopeArn": {
                return Optional.ofNullable(clazz.cast(this.scopeArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("monitorName", MONITOR_NAME_FIELD);
        map.put("localResources", LOCAL_RESOURCES_FIELD);
        map.put("remoteResources", REMOTE_RESOURCES_FIELD);
        map.put("scopeArn", SCOPE_ARN_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMonitorRequest, T> g) {
        return obj -> g.apply((CreateMonitorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFlowMonitorRequest.BuilderImpl
    implements Builder {
        private String monitorName;
        private List<MonitorLocalResource> localResources = DefaultSdkAutoConstructList.getInstance();
        private List<MonitorRemoteResource> remoteResources = DefaultSdkAutoConstructList.getInstance();
        private String scopeArn;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMonitorRequest model) {
            super(model);
            this.monitorName(model.monitorName);
            this.localResources(model.localResources);
            this.remoteResources(model.remoteResources);
            this.scopeArn(model.scopeArn);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getMonitorName() {
            return this.monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final List<MonitorLocalResource.Builder> getLocalResources() {
            List<MonitorLocalResource.Builder> result = CreateMonitorInputLocalResourcesListCopier.copyToBuilder(this.localResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocalResources(Collection<MonitorLocalResource.BuilderImpl> localResources) {
            this.localResources = CreateMonitorInputLocalResourcesListCopier.copyFromBuilder(localResources);
        }

        @Override
        public final Builder localResources(Collection<MonitorLocalResource> localResources) {
            this.localResources = CreateMonitorInputLocalResourcesListCopier.copy(localResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localResources(MonitorLocalResource ... localResources) {
            this.localResources(Arrays.asList(localResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localResources(Consumer<MonitorLocalResource.Builder> ... localResources) {
            this.localResources(Stream.of(localResources).map(c -> (MonitorLocalResource)((MonitorLocalResource.Builder)MonitorLocalResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MonitorRemoteResource.Builder> getRemoteResources() {
            List<MonitorRemoteResource.Builder> result = MonitorRemoteResourcesCopier.copyToBuilder(this.remoteResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoteResources(Collection<MonitorRemoteResource.BuilderImpl> remoteResources) {
            this.remoteResources = MonitorRemoteResourcesCopier.copyFromBuilder(remoteResources);
        }

        @Override
        public final Builder remoteResources(Collection<MonitorRemoteResource> remoteResources) {
            this.remoteResources = MonitorRemoteResourcesCopier.copy(remoteResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteResources(MonitorRemoteResource ... remoteResources) {
            this.remoteResources(Arrays.asList(remoteResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteResources(Consumer<MonitorRemoteResource.Builder> ... remoteResources) {
            this.remoteResources(Stream.of(remoteResources).map(c -> (MonitorRemoteResource)((MonitorRemoteResource.Builder)MonitorRemoteResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getScopeArn() {
            return this.scopeArn;
        }

        public final void setScopeArn(String scopeArn) {
            this.scopeArn = scopeArn;
        }

        @Override
        public final Builder scopeArn(String scopeArn) {
            this.scopeArn = scopeArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMonitorRequest build() {
            return new CreateMonitorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFlowMonitorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMonitorRequest> {
        public Builder monitorName(String var1);

        public Builder localResources(Collection<MonitorLocalResource> var1);

        public Builder localResources(MonitorLocalResource ... var1);

        public Builder localResources(Consumer<MonitorLocalResource.Builder> ... var1);

        public Builder remoteResources(Collection<MonitorRemoteResource> var1);

        public Builder remoteResources(MonitorRemoteResource ... var1);

        public Builder remoteResources(Consumer<MonitorRemoteResource.Builder> ... var1);

        public Builder scopeArn(String var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

