/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource;
import software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResourcesCopier;
import software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource;
import software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResourcesCopier;
import software.amazon.awssdk.services.networkflowmonitor.model.NetworkFlowMonitorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMonitorRequest
extends NetworkFlowMonitorRequest
implements ToCopyableBuilder<Builder, UpdateMonitorRequest> {
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitorName").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::monitorName)).setter(UpdateMonitorRequest.setter(Builder::monitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("monitorName").build()}).build();
    private static final SdkField<List<MonitorLocalResource>> LOCAL_RESOURCES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("localResourcesToAdd").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::localResourcesToAdd)).setter(UpdateMonitorRequest.setter(Builder::localResourcesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localResourcesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonitorLocalResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MonitorLocalResource>> LOCAL_RESOURCES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("localResourcesToRemove").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::localResourcesToRemove)).setter(UpdateMonitorRequest.setter(Builder::localResourcesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localResourcesToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonitorLocalResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MonitorRemoteResource>> REMOTE_RESOURCES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("remoteResourcesToAdd").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::remoteResourcesToAdd)).setter(UpdateMonitorRequest.setter(Builder::remoteResourcesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteResourcesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonitorRemoteResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MonitorRemoteResource>> REMOTE_RESOURCES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("remoteResourcesToRemove").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::remoteResourcesToRemove)).setter(UpdateMonitorRequest.setter(Builder::remoteResourcesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteResourcesToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonitorRemoteResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::clientToken)).setter(UpdateMonitorRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_NAME_FIELD, LOCAL_RESOURCES_TO_ADD_FIELD, LOCAL_RESOURCES_TO_REMOVE_FIELD, REMOTE_RESOURCES_TO_ADD_FIELD, REMOTE_RESOURCES_TO_REMOVE_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMonitorRequest.memberNameToFieldInitializer();
    private final String monitorName;
    private final List<MonitorLocalResource> localResourcesToAdd;
    private final List<MonitorLocalResource> localResourcesToRemove;
    private final List<MonitorRemoteResource> remoteResourcesToAdd;
    private final List<MonitorRemoteResource> remoteResourcesToRemove;
    private final String clientToken;

    private UpdateMonitorRequest(BuilderImpl builder) {
        super(builder);
        this.monitorName = builder.monitorName;
        this.localResourcesToAdd = builder.localResourcesToAdd;
        this.localResourcesToRemove = builder.localResourcesToRemove;
        this.remoteResourcesToAdd = builder.remoteResourcesToAdd;
        this.remoteResourcesToRemove = builder.remoteResourcesToRemove;
        this.clientToken = builder.clientToken;
    }

    public final String monitorName() {
        return this.monitorName;
    }

    public final boolean hasLocalResourcesToAdd() {
        return this.localResourcesToAdd != null && !(this.localResourcesToAdd instanceof SdkAutoConstructList);
    }

    public final List<MonitorLocalResource> localResourcesToAdd() {
        return this.localResourcesToAdd;
    }

    public final boolean hasLocalResourcesToRemove() {
        return this.localResourcesToRemove != null && !(this.localResourcesToRemove instanceof SdkAutoConstructList);
    }

    public final List<MonitorLocalResource> localResourcesToRemove() {
        return this.localResourcesToRemove;
    }

    public final boolean hasRemoteResourcesToAdd() {
        return this.remoteResourcesToAdd != null && !(this.remoteResourcesToAdd instanceof SdkAutoConstructList);
    }

    public final List<MonitorRemoteResource> remoteResourcesToAdd() {
        return this.remoteResourcesToAdd;
    }

    public final boolean hasRemoteResourcesToRemove() {
        return this.remoteResourcesToRemove != null && !(this.remoteResourcesToRemove instanceof SdkAutoConstructList);
    }

    public final List<MonitorRemoteResource> remoteResourcesToRemove() {
        return this.remoteResourcesToRemove;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocalResourcesToAdd() ? this.localResourcesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocalResourcesToRemove() ? this.localResourcesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoteResourcesToAdd() ? this.remoteResourcesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoteResourcesToRemove() ? this.remoteResourcesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMonitorRequest)) {
            return false;
        }
        UpdateMonitorRequest other = (UpdateMonitorRequest)((Object)obj);
        return Objects.equals(this.monitorName(), other.monitorName()) && this.hasLocalResourcesToAdd() == other.hasLocalResourcesToAdd() && Objects.equals(this.localResourcesToAdd(), other.localResourcesToAdd()) && this.hasLocalResourcesToRemove() == other.hasLocalResourcesToRemove() && Objects.equals(this.localResourcesToRemove(), other.localResourcesToRemove()) && this.hasRemoteResourcesToAdd() == other.hasRemoteResourcesToAdd() && Objects.equals(this.remoteResourcesToAdd(), other.remoteResourcesToAdd()) && this.hasRemoteResourcesToRemove() == other.hasRemoteResourcesToRemove() && Objects.equals(this.remoteResourcesToRemove(), other.remoteResourcesToRemove()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMonitorRequest").add("MonitorName", (Object)this.monitorName()).add("LocalResourcesToAdd", this.hasLocalResourcesToAdd() ? this.localResourcesToAdd() : null).add("LocalResourcesToRemove", this.hasLocalResourcesToRemove() ? this.localResourcesToRemove() : null).add("RemoteResourcesToAdd", this.hasRemoteResourcesToAdd() ? this.remoteResourcesToAdd() : null).add("RemoteResourcesToRemove", this.hasRemoteResourcesToRemove() ? this.remoteResourcesToRemove() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "monitorName": {
                return Optional.ofNullable(clazz.cast(this.monitorName()));
            }
            case "localResourcesToAdd": {
                return Optional.ofNullable(clazz.cast(this.localResourcesToAdd()));
            }
            case "localResourcesToRemove": {
                return Optional.ofNullable(clazz.cast(this.localResourcesToRemove()));
            }
            case "remoteResourcesToAdd": {
                return Optional.ofNullable(clazz.cast(this.remoteResourcesToAdd()));
            }
            case "remoteResourcesToRemove": {
                return Optional.ofNullable(clazz.cast(this.remoteResourcesToRemove()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("monitorName", MONITOR_NAME_FIELD);
        map.put("localResourcesToAdd", LOCAL_RESOURCES_TO_ADD_FIELD);
        map.put("localResourcesToRemove", LOCAL_RESOURCES_TO_REMOVE_FIELD);
        map.put("remoteResourcesToAdd", REMOTE_RESOURCES_TO_ADD_FIELD);
        map.put("remoteResourcesToRemove", REMOTE_RESOURCES_TO_REMOVE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMonitorRequest, T> g) {
        return obj -> g.apply((UpdateMonitorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFlowMonitorRequest.BuilderImpl
    implements Builder {
        private String monitorName;
        private List<MonitorLocalResource> localResourcesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<MonitorLocalResource> localResourcesToRemove = DefaultSdkAutoConstructList.getInstance();
        private List<MonitorRemoteResource> remoteResourcesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<MonitorRemoteResource> remoteResourcesToRemove = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMonitorRequest model) {
            super(model);
            this.monitorName(model.monitorName);
            this.localResourcesToAdd(model.localResourcesToAdd);
            this.localResourcesToRemove(model.localResourcesToRemove);
            this.remoteResourcesToAdd(model.remoteResourcesToAdd);
            this.remoteResourcesToRemove(model.remoteResourcesToRemove);
            this.clientToken(model.clientToken);
        }

        public final String getMonitorName() {
            return this.monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final List<MonitorLocalResource.Builder> getLocalResourcesToAdd() {
            List<MonitorLocalResource.Builder> result = MonitorLocalResourcesCopier.copyToBuilder(this.localResourcesToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocalResourcesToAdd(Collection<MonitorLocalResource.BuilderImpl> localResourcesToAdd) {
            this.localResourcesToAdd = MonitorLocalResourcesCopier.copyFromBuilder(localResourcesToAdd);
        }

        @Override
        public final Builder localResourcesToAdd(Collection<MonitorLocalResource> localResourcesToAdd) {
            this.localResourcesToAdd = MonitorLocalResourcesCopier.copy(localResourcesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localResourcesToAdd(MonitorLocalResource ... localResourcesToAdd) {
            this.localResourcesToAdd(Arrays.asList(localResourcesToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localResourcesToAdd(Consumer<MonitorLocalResource.Builder> ... localResourcesToAdd) {
            this.localResourcesToAdd(Stream.of(localResourcesToAdd).map(c -> (MonitorLocalResource)((MonitorLocalResource.Builder)MonitorLocalResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MonitorLocalResource.Builder> getLocalResourcesToRemove() {
            List<MonitorLocalResource.Builder> result = MonitorLocalResourcesCopier.copyToBuilder(this.localResourcesToRemove);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocalResourcesToRemove(Collection<MonitorLocalResource.BuilderImpl> localResourcesToRemove) {
            this.localResourcesToRemove = MonitorLocalResourcesCopier.copyFromBuilder(localResourcesToRemove);
        }

        @Override
        public final Builder localResourcesToRemove(Collection<MonitorLocalResource> localResourcesToRemove) {
            this.localResourcesToRemove = MonitorLocalResourcesCopier.copy(localResourcesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localResourcesToRemove(MonitorLocalResource ... localResourcesToRemove) {
            this.localResourcesToRemove(Arrays.asList(localResourcesToRemove));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localResourcesToRemove(Consumer<MonitorLocalResource.Builder> ... localResourcesToRemove) {
            this.localResourcesToRemove(Stream.of(localResourcesToRemove).map(c -> (MonitorLocalResource)((MonitorLocalResource.Builder)MonitorLocalResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MonitorRemoteResource.Builder> getRemoteResourcesToAdd() {
            List<MonitorRemoteResource.Builder> result = MonitorRemoteResourcesCopier.copyToBuilder(this.remoteResourcesToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoteResourcesToAdd(Collection<MonitorRemoteResource.BuilderImpl> remoteResourcesToAdd) {
            this.remoteResourcesToAdd = MonitorRemoteResourcesCopier.copyFromBuilder(remoteResourcesToAdd);
        }

        @Override
        public final Builder remoteResourcesToAdd(Collection<MonitorRemoteResource> remoteResourcesToAdd) {
            this.remoteResourcesToAdd = MonitorRemoteResourcesCopier.copy(remoteResourcesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteResourcesToAdd(MonitorRemoteResource ... remoteResourcesToAdd) {
            this.remoteResourcesToAdd(Arrays.asList(remoteResourcesToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteResourcesToAdd(Consumer<MonitorRemoteResource.Builder> ... remoteResourcesToAdd) {
            this.remoteResourcesToAdd(Stream.of(remoteResourcesToAdd).map(c -> (MonitorRemoteResource)((MonitorRemoteResource.Builder)MonitorRemoteResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MonitorRemoteResource.Builder> getRemoteResourcesToRemove() {
            List<MonitorRemoteResource.Builder> result = MonitorRemoteResourcesCopier.copyToBuilder(this.remoteResourcesToRemove);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoteResourcesToRemove(Collection<MonitorRemoteResource.BuilderImpl> remoteResourcesToRemove) {
            this.remoteResourcesToRemove = MonitorRemoteResourcesCopier.copyFromBuilder(remoteResourcesToRemove);
        }

        @Override
        public final Builder remoteResourcesToRemove(Collection<MonitorRemoteResource> remoteResourcesToRemove) {
            this.remoteResourcesToRemove = MonitorRemoteResourcesCopier.copy(remoteResourcesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteResourcesToRemove(MonitorRemoteResource ... remoteResourcesToRemove) {
            this.remoteResourcesToRemove(Arrays.asList(remoteResourcesToRemove));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteResourcesToRemove(Consumer<MonitorRemoteResource.Builder> ... remoteResourcesToRemove) {
            this.remoteResourcesToRemove(Stream.of(remoteResourcesToRemove).map(c -> (MonitorRemoteResource)((MonitorRemoteResource.Builder)MonitorRemoteResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMonitorRequest build() {
            return new UpdateMonitorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkFlowMonitorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMonitorRequest> {
        public Builder monitorName(String var1);

        public Builder localResourcesToAdd(Collection<MonitorLocalResource> var1);

        public Builder localResourcesToAdd(MonitorLocalResource ... var1);

        public Builder localResourcesToAdd(Consumer<MonitorLocalResource.Builder> ... var1);

        public Builder localResourcesToRemove(Collection<MonitorLocalResource> var1);

        public Builder localResourcesToRemove(MonitorLocalResource ... var1);

        public Builder localResourcesToRemove(Consumer<MonitorLocalResource.Builder> ... var1);

        public Builder remoteResourcesToAdd(Collection<MonitorRemoteResource> var1);

        public Builder remoteResourcesToAdd(MonitorRemoteResource ... var1);

        public Builder remoteResourcesToAdd(Consumer<MonitorRemoteResource.Builder> ... var1);

        public Builder remoteResourcesToRemove(Collection<MonitorRemoteResource> var1);

        public Builder remoteResourcesToRemove(MonitorRemoteResource ... var1);

        public Builder remoteResourcesToRemove(Consumer<MonitorRemoteResource.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

