/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MonitorRemoteResourceType {
    AWS_EC2_VPC("AWS::EC2::VPC"),
    AWS_AVAILABILITY_ZONE("AWS::AvailabilityZone"),
    AWS_EC2_SUBNET("AWS::EC2::Subnet"),
    AWS_AWS_SERVICE("AWS::AWSService"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MonitorRemoteResourceType> VALUE_MAP;
    private final String value;

    private MonitorRemoteResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MonitorRemoteResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MonitorRemoteResourceType> knownValues() {
        EnumSet<MonitorRemoteResourceType> knownValues = EnumSet.allOf(MonitorRemoteResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MonitorRemoteResourceType.class, MonitorRemoteResourceType::toString);
    }
}

