/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResource;
import software.amazon.awssdk.services.networkflowmonitor.model.MonitorLocalResourcesCopier;
import software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResource;
import software.amazon.awssdk.services.networkflowmonitor.model.MonitorRemoteResourcesCopier;
import software.amazon.awssdk.services.networkflowmonitor.model.MonitorStatus;
import software.amazon.awssdk.services.networkflowmonitor.model.NetworkFlowMonitorResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMonitorResponse
extends NetworkFlowMonitorResponse
implements ToCopyableBuilder<Builder, UpdateMonitorResponse> {
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitorArn").getter(UpdateMonitorResponse.getter(UpdateMonitorResponse::monitorArn)).setter(UpdateMonitorResponse.setter(Builder::monitorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorArn").build()}).build();
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitorName").getter(UpdateMonitorResponse.getter(UpdateMonitorResponse::monitorName)).setter(UpdateMonitorResponse.setter(Builder::monitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorName").build()}).build();
    private static final SdkField<String> MONITOR_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitorStatus").getter(UpdateMonitorResponse.getter(UpdateMonitorResponse::monitorStatusAsString)).setter(UpdateMonitorResponse.setter(Builder::monitorStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorStatus").build()}).build();
    private static final SdkField<List<MonitorLocalResource>> LOCAL_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("localResources").getter(UpdateMonitorResponse.getter(UpdateMonitorResponse::localResources)).setter(UpdateMonitorResponse.setter(Builder::localResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonitorLocalResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MonitorRemoteResource>> REMOTE_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("remoteResources").getter(UpdateMonitorResponse.getter(UpdateMonitorResponse::remoteResources)).setter(UpdateMonitorResponse.setter(Builder::remoteResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonitorRemoteResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(UpdateMonitorResponse.getter(UpdateMonitorResponse::createdAt)).setter(UpdateMonitorResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(UpdateMonitorResponse.getter(UpdateMonitorResponse::modifiedAt)).setter(UpdateMonitorResponse.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(UpdateMonitorResponse.getter(UpdateMonitorResponse::tags)).setter(UpdateMonitorResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ARN_FIELD, MONITOR_NAME_FIELD, MONITOR_STATUS_FIELD, LOCAL_RESOURCES_FIELD, REMOTE_RESOURCES_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("monitorArn", MONITOR_ARN_FIELD);
            this.put("monitorName", MONITOR_NAME_FIELD);
            this.put("monitorStatus", MONITOR_STATUS_FIELD);
            this.put("localResources", LOCAL_RESOURCES_FIELD);
            this.put("remoteResources", REMOTE_RESOURCES_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("modifiedAt", MODIFIED_AT_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String monitorArn;
    private final String monitorName;
    private final String monitorStatus;
    private final List<MonitorLocalResource> localResources;
    private final List<MonitorRemoteResource> remoteResources;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final Map<String, String> tags;

    private UpdateMonitorResponse(BuilderImpl builder) {
        super(builder);
        this.monitorArn = builder.monitorArn;
        this.monitorName = builder.monitorName;
        this.monitorStatus = builder.monitorStatus;
        this.localResources = builder.localResources;
        this.remoteResources = builder.remoteResources;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.tags = builder.tags;
    }

    public final String monitorArn() {
        return this.monitorArn;
    }

    public final String monitorName() {
        return this.monitorName;
    }

    public final MonitorStatus monitorStatus() {
        return MonitorStatus.fromValue(this.monitorStatus);
    }

    public final String monitorStatusAsString() {
        return this.monitorStatus;
    }

    public final boolean hasLocalResources() {
        return this.localResources != null && !(this.localResources instanceof SdkAutoConstructList);
    }

    public final List<MonitorLocalResource> localResources() {
        return this.localResources;
    }

    public final boolean hasRemoteResources() {
        return this.remoteResources != null && !(this.remoteResources instanceof SdkAutoConstructList);
    }

    public final List<MonitorRemoteResource> remoteResources() {
        return this.remoteResources;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocalResources() ? this.localResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoteResources() ? this.remoteResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMonitorResponse)) {
            return false;
        }
        UpdateMonitorResponse other = (UpdateMonitorResponse)((Object)obj);
        return Objects.equals(this.monitorArn(), other.monitorArn()) && Objects.equals(this.monitorName(), other.monitorName()) && Objects.equals(this.monitorStatusAsString(), other.monitorStatusAsString()) && this.hasLocalResources() == other.hasLocalResources() && Objects.equals(this.localResources(), other.localResources()) && this.hasRemoteResources() == other.hasRemoteResources() && Objects.equals(this.remoteResources(), other.remoteResources()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMonitorResponse").add("MonitorArn", (Object)this.monitorArn()).add("MonitorName", (Object)this.monitorName()).add("MonitorStatus", (Object)this.monitorStatusAsString()).add("LocalResources", this.hasLocalResources() ? this.localResources() : null).add("RemoteResources", this.hasRemoteResources() ? this.remoteResources() : null).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "monitorArn": {
                return Optional.ofNullable(clazz.cast(this.monitorArn()));
            }
            case "monitorName": {
                return Optional.ofNullable(clazz.cast(this.monitorName()));
            }
            case "monitorStatus": {
                return Optional.ofNullable(clazz.cast(this.monitorStatusAsString()));
            }
            case "localResources": {
                return Optional.ofNullable(clazz.cast(this.localResources()));
            }
            case "remoteResources": {
                return Optional.ofNullable(clazz.cast(this.remoteResources()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMonitorResponse, T> g) {
        return obj -> g.apply((UpdateMonitorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFlowMonitorResponse.BuilderImpl
    implements Builder {
        private String monitorArn;
        private String monitorName;
        private String monitorStatus;
        private List<MonitorLocalResource> localResources = DefaultSdkAutoConstructList.getInstance();
        private List<MonitorRemoteResource> remoteResources = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant modifiedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMonitorResponse model) {
            super(model);
            this.monitorArn(model.monitorArn);
            this.monitorName(model.monitorName);
            this.monitorStatus(model.monitorStatus);
            this.localResources(model.localResources);
            this.remoteResources(model.remoteResources);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.tags(model.tags);
        }

        public final String getMonitorArn() {
            return this.monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final String getMonitorName() {
            return this.monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final String getMonitorStatus() {
            return this.monitorStatus;
        }

        public final void setMonitorStatus(String monitorStatus) {
            this.monitorStatus = monitorStatus;
        }

        @Override
        public final Builder monitorStatus(String monitorStatus) {
            this.monitorStatus = monitorStatus;
            return this;
        }

        @Override
        public final Builder monitorStatus(MonitorStatus monitorStatus) {
            this.monitorStatus(monitorStatus == null ? null : monitorStatus.toString());
            return this;
        }

        public final List<MonitorLocalResource.Builder> getLocalResources() {
            List<MonitorLocalResource.Builder> result = MonitorLocalResourcesCopier.copyToBuilder(this.localResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocalResources(Collection<MonitorLocalResource.BuilderImpl> localResources) {
            this.localResources = MonitorLocalResourcesCopier.copyFromBuilder(localResources);
        }

        @Override
        public final Builder localResources(Collection<MonitorLocalResource> localResources) {
            this.localResources = MonitorLocalResourcesCopier.copy(localResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localResources(MonitorLocalResource ... localResources) {
            this.localResources(Arrays.asList(localResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localResources(Consumer<MonitorLocalResource.Builder> ... localResources) {
            this.localResources(Stream.of(localResources).map(c -> (MonitorLocalResource)((MonitorLocalResource.Builder)MonitorLocalResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MonitorRemoteResource.Builder> getRemoteResources() {
            List<MonitorRemoteResource.Builder> result = MonitorRemoteResourcesCopier.copyToBuilder(this.remoteResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoteResources(Collection<MonitorRemoteResource.BuilderImpl> remoteResources) {
            this.remoteResources = MonitorRemoteResourcesCopier.copyFromBuilder(remoteResources);
        }

        @Override
        public final Builder remoteResources(Collection<MonitorRemoteResource> remoteResources) {
            this.remoteResources = MonitorRemoteResourcesCopier.copy(remoteResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteResources(MonitorRemoteResource ... remoteResources) {
            this.remoteResources(Arrays.asList(remoteResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteResources(Consumer<MonitorRemoteResource.Builder> ... remoteResources) {
            this.remoteResources(Stream.of(remoteResources).map(c -> (MonitorRemoteResource)((MonitorRemoteResource.Builder)MonitorRemoteResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public UpdateMonitorResponse build() {
            return new UpdateMonitorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkFlowMonitorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMonitorResponse> {
        public Builder monitorArn(String var1);

        public Builder monitorName(String var1);

        public Builder monitorStatus(String var1);

        public Builder monitorStatus(MonitorStatus var1);

        public Builder localResources(Collection<MonitorLocalResource> var1);

        public Builder localResources(MonitorLocalResource ... var1);

        public Builder localResources(Consumer<MonitorLocalResource.Builder> ... var1);

        public Builder remoteResources(Collection<MonitorRemoteResource> var1);

        public Builder remoteResources(MonitorRemoteResource ... var1);

        public Builder remoteResources(Consumer<MonitorRemoteResource.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

