/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkflowmonitor.model.NetworkFlowMonitorResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.ScopeSummary;
import software.amazon.awssdk.services.networkflowmonitor.model.ScopeSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListScopesResponse
extends NetworkFlowMonitorResponse
implements ToCopyableBuilder<Builder, ListScopesResponse> {
    private static final SdkField<List<ScopeSummary>> SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scopes").getter(ListScopesResponse.getter(ListScopesResponse::scopes)).setter(ListScopesResponse.setter(Builder::scopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScopeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListScopesResponse.getter(ListScopesResponse::nextToken)).setter(ListScopesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("scopes", SCOPES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ScopeSummary> scopes;
    private final String nextToken;

    private ListScopesResponse(BuilderImpl builder) {
        super(builder);
        this.scopes = builder.scopes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasScopes() {
        return this.scopes != null && !(this.scopes instanceof SdkAutoConstructList);
    }

    public final List<ScopeSummary> scopes() {
        return this.scopes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScopes() ? this.scopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScopesResponse)) {
            return false;
        }
        ListScopesResponse other = (ListScopesResponse)((Object)obj);
        return this.hasScopes() == other.hasScopes() && Objects.equals(this.scopes(), other.scopes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListScopesResponse").add("Scopes", this.hasScopes() ? this.scopes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scopes": {
                return Optional.ofNullable(clazz.cast(this.scopes()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListScopesResponse, T> g) {
        return obj -> g.apply((ListScopesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFlowMonitorResponse.BuilderImpl
    implements Builder {
        private List<ScopeSummary> scopes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListScopesResponse model) {
            super(model);
            this.scopes(model.scopes);
            this.nextToken(model.nextToken);
        }

        public final List<ScopeSummary.Builder> getScopes() {
            List<ScopeSummary.Builder> result = ScopeSummaryListCopier.copyToBuilder(this.scopes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScopes(Collection<ScopeSummary.BuilderImpl> scopes) {
            this.scopes = ScopeSummaryListCopier.copyFromBuilder(scopes);
        }

        @Override
        public final Builder scopes(Collection<ScopeSummary> scopes) {
            this.scopes = ScopeSummaryListCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(ScopeSummary ... scopes) {
            this.scopes(Arrays.asList(scopes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(Consumer<ScopeSummary.Builder> ... scopes) {
            this.scopes(Stream.of(scopes).map(c -> (ScopeSummary)((ScopeSummary.Builder)ScopeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListScopesResponse build() {
            return new ListScopesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkFlowMonitorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListScopesResponse> {
        public Builder scopes(Collection<ScopeSummary> var1);

        public Builder scopes(ScopeSummary ... var1);

        public Builder scopes(Consumer<ScopeSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

