/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KubernetesMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KubernetesMetadata> {
    private static final SdkField<String> LOCAL_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localServiceName").getter(KubernetesMetadata.getter(KubernetesMetadata::localServiceName)).setter(KubernetesMetadata.setter(Builder::localServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localServiceName").build()}).build();
    private static final SdkField<String> LOCAL_POD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localPodName").getter(KubernetesMetadata.getter(KubernetesMetadata::localPodName)).setter(KubernetesMetadata.setter(Builder::localPodName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localPodName").build()}).build();
    private static final SdkField<String> LOCAL_POD_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localPodNamespace").getter(KubernetesMetadata.getter(KubernetesMetadata::localPodNamespace)).setter(KubernetesMetadata.setter(Builder::localPodNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localPodNamespace").build()}).build();
    private static final SdkField<String> REMOTE_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remoteServiceName").getter(KubernetesMetadata.getter(KubernetesMetadata::remoteServiceName)).setter(KubernetesMetadata.setter(Builder::remoteServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteServiceName").build()}).build();
    private static final SdkField<String> REMOTE_POD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remotePodName").getter(KubernetesMetadata.getter(KubernetesMetadata::remotePodName)).setter(KubernetesMetadata.setter(Builder::remotePodName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remotePodName").build()}).build();
    private static final SdkField<String> REMOTE_POD_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remotePodNamespace").getter(KubernetesMetadata.getter(KubernetesMetadata::remotePodNamespace)).setter(KubernetesMetadata.setter(Builder::remotePodNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remotePodNamespace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_SERVICE_NAME_FIELD, LOCAL_POD_NAME_FIELD, LOCAL_POD_NAMESPACE_FIELD, REMOTE_SERVICE_NAME_FIELD, REMOTE_POD_NAME_FIELD, REMOTE_POD_NAMESPACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("localServiceName", LOCAL_SERVICE_NAME_FIELD);
            this.put("localPodName", LOCAL_POD_NAME_FIELD);
            this.put("localPodNamespace", LOCAL_POD_NAMESPACE_FIELD);
            this.put("remoteServiceName", REMOTE_SERVICE_NAME_FIELD);
            this.put("remotePodName", REMOTE_POD_NAME_FIELD);
            this.put("remotePodNamespace", REMOTE_POD_NAMESPACE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String localServiceName;
    private final String localPodName;
    private final String localPodNamespace;
    private final String remoteServiceName;
    private final String remotePodName;
    private final String remotePodNamespace;

    private KubernetesMetadata(BuilderImpl builder) {
        this.localServiceName = builder.localServiceName;
        this.localPodName = builder.localPodName;
        this.localPodNamespace = builder.localPodNamespace;
        this.remoteServiceName = builder.remoteServiceName;
        this.remotePodName = builder.remotePodName;
        this.remotePodNamespace = builder.remotePodNamespace;
    }

    public final String localServiceName() {
        return this.localServiceName;
    }

    public final String localPodName() {
        return this.localPodName;
    }

    public final String localPodNamespace() {
        return this.localPodNamespace;
    }

    public final String remoteServiceName() {
        return this.remoteServiceName;
    }

    public final String remotePodName() {
        return this.remotePodName;
    }

    public final String remotePodNamespace() {
        return this.remotePodNamespace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.localPodName());
        hashCode = 31 * hashCode + Objects.hashCode(this.localPodNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.remotePodName());
        hashCode = 31 * hashCode + Objects.hashCode(this.remotePodNamespace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesMetadata)) {
            return false;
        }
        KubernetesMetadata other = (KubernetesMetadata)obj;
        return Objects.equals(this.localServiceName(), other.localServiceName()) && Objects.equals(this.localPodName(), other.localPodName()) && Objects.equals(this.localPodNamespace(), other.localPodNamespace()) && Objects.equals(this.remoteServiceName(), other.remoteServiceName()) && Objects.equals(this.remotePodName(), other.remotePodName()) && Objects.equals(this.remotePodNamespace(), other.remotePodNamespace());
    }

    public final String toString() {
        return ToString.builder((String)"KubernetesMetadata").add("LocalServiceName", (Object)this.localServiceName()).add("LocalPodName", (Object)this.localPodName()).add("LocalPodNamespace", (Object)this.localPodNamespace()).add("RemoteServiceName", (Object)this.remoteServiceName()).add("RemotePodName", (Object)this.remotePodName()).add("RemotePodNamespace", (Object)this.remotePodNamespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "localServiceName": {
                return Optional.ofNullable(clazz.cast(this.localServiceName()));
            }
            case "localPodName": {
                return Optional.ofNullable(clazz.cast(this.localPodName()));
            }
            case "localPodNamespace": {
                return Optional.ofNullable(clazz.cast(this.localPodNamespace()));
            }
            case "remoteServiceName": {
                return Optional.ofNullable(clazz.cast(this.remoteServiceName()));
            }
            case "remotePodName": {
                return Optional.ofNullable(clazz.cast(this.remotePodName()));
            }
            case "remotePodNamespace": {
                return Optional.ofNullable(clazz.cast(this.remotePodNamespace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KubernetesMetadata, T> g) {
        return obj -> g.apply((KubernetesMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String localServiceName;
        private String localPodName;
        private String localPodNamespace;
        private String remoteServiceName;
        private String remotePodName;
        private String remotePodNamespace;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesMetadata model) {
            this.localServiceName(model.localServiceName);
            this.localPodName(model.localPodName);
            this.localPodNamespace(model.localPodNamespace);
            this.remoteServiceName(model.remoteServiceName);
            this.remotePodName(model.remotePodName);
            this.remotePodNamespace(model.remotePodNamespace);
        }

        public final String getLocalServiceName() {
            return this.localServiceName;
        }

        public final void setLocalServiceName(String localServiceName) {
            this.localServiceName = localServiceName;
        }

        @Override
        public final Builder localServiceName(String localServiceName) {
            this.localServiceName = localServiceName;
            return this;
        }

        public final String getLocalPodName() {
            return this.localPodName;
        }

        public final void setLocalPodName(String localPodName) {
            this.localPodName = localPodName;
        }

        @Override
        public final Builder localPodName(String localPodName) {
            this.localPodName = localPodName;
            return this;
        }

        public final String getLocalPodNamespace() {
            return this.localPodNamespace;
        }

        public final void setLocalPodNamespace(String localPodNamespace) {
            this.localPodNamespace = localPodNamespace;
        }

        @Override
        public final Builder localPodNamespace(String localPodNamespace) {
            this.localPodNamespace = localPodNamespace;
            return this;
        }

        public final String getRemoteServiceName() {
            return this.remoteServiceName;
        }

        public final void setRemoteServiceName(String remoteServiceName) {
            this.remoteServiceName = remoteServiceName;
        }

        @Override
        public final Builder remoteServiceName(String remoteServiceName) {
            this.remoteServiceName = remoteServiceName;
            return this;
        }

        public final String getRemotePodName() {
            return this.remotePodName;
        }

        public final void setRemotePodName(String remotePodName) {
            this.remotePodName = remotePodName;
        }

        @Override
        public final Builder remotePodName(String remotePodName) {
            this.remotePodName = remotePodName;
            return this;
        }

        public final String getRemotePodNamespace() {
            return this.remotePodNamespace;
        }

        public final void setRemotePodNamespace(String remotePodNamespace) {
            this.remotePodNamespace = remotePodNamespace;
        }

        @Override
        public final Builder remotePodNamespace(String remotePodNamespace) {
            this.remotePodNamespace = remotePodNamespace;
            return this;
        }

        public KubernetesMetadata build() {
            return new KubernetesMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KubernetesMetadata> {
        public Builder localServiceName(String var1);

        public Builder localPodName(String var1);

        public Builder localPodNamespace(String var1);

        public Builder remoteServiceName(String var1);

        public Builder remotePodName(String var1);

        public Builder remotePodNamespace(String var1);
    }
}

