/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkflowmonitor.model.MetricUnit;
import software.amazon.awssdk.services.networkflowmonitor.model.MonitorTopContributorsRow;
import software.amazon.awssdk.services.networkflowmonitor.model.MonitorTopContributorsRowListCopier;
import software.amazon.awssdk.services.networkflowmonitor.model.NetworkFlowMonitorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQueryResultsMonitorTopContributorsResponse
extends NetworkFlowMonitorResponse
implements ToCopyableBuilder<Builder, GetQueryResultsMonitorTopContributorsResponse> {
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(GetQueryResultsMonitorTopContributorsResponse.getter(GetQueryResultsMonitorTopContributorsResponse::unitAsString)).setter(GetQueryResultsMonitorTopContributorsResponse.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<List<MonitorTopContributorsRow>> TOP_CONTRIBUTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("topContributors").getter(GetQueryResultsMonitorTopContributorsResponse.getter(GetQueryResultsMonitorTopContributorsResponse::topContributors)).setter(GetQueryResultsMonitorTopContributorsResponse.setter(Builder::topContributors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topContributors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonitorTopContributorsRow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetQueryResultsMonitorTopContributorsResponse.getter(GetQueryResultsMonitorTopContributorsResponse::nextToken)).setter(GetQueryResultsMonitorTopContributorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNIT_FIELD, TOP_CONTRIBUTORS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("unit", UNIT_FIELD);
            this.put("topContributors", TOP_CONTRIBUTORS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String unit;
    private final List<MonitorTopContributorsRow> topContributors;
    private final String nextToken;

    private GetQueryResultsMonitorTopContributorsResponse(BuilderImpl builder) {
        super(builder);
        this.unit = builder.unit;
        this.topContributors = builder.topContributors;
        this.nextToken = builder.nextToken;
    }

    public final MetricUnit unit() {
        return MetricUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public final boolean hasTopContributors() {
        return this.topContributors != null && !(this.topContributors instanceof SdkAutoConstructList);
    }

    public final List<MonitorTopContributorsRow> topContributors() {
        return this.topContributors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopContributors() ? this.topContributors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryResultsMonitorTopContributorsResponse)) {
            return false;
        }
        GetQueryResultsMonitorTopContributorsResponse other = (GetQueryResultsMonitorTopContributorsResponse)((Object)obj);
        return Objects.equals(this.unitAsString(), other.unitAsString()) && this.hasTopContributors() == other.hasTopContributors() && Objects.equals(this.topContributors(), other.topContributors()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetQueryResultsMonitorTopContributorsResponse").add("Unit", (Object)this.unitAsString()).add("TopContributors", this.hasTopContributors() ? this.topContributors() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "topContributors": {
                return Optional.ofNullable(clazz.cast(this.topContributors()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetQueryResultsMonitorTopContributorsResponse, T> g) {
        return obj -> g.apply((GetQueryResultsMonitorTopContributorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFlowMonitorResponse.BuilderImpl
    implements Builder {
        private String unit;
        private List<MonitorTopContributorsRow> topContributors = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryResultsMonitorTopContributorsResponse model) {
            super(model);
            this.unit(model.unit);
            this.topContributors(model.topContributors);
            this.nextToken(model.nextToken);
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(MetricUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final List<MonitorTopContributorsRow.Builder> getTopContributors() {
            List<MonitorTopContributorsRow.Builder> result = MonitorTopContributorsRowListCopier.copyToBuilder(this.topContributors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopContributors(Collection<MonitorTopContributorsRow.BuilderImpl> topContributors) {
            this.topContributors = MonitorTopContributorsRowListCopier.copyFromBuilder(topContributors);
        }

        @Override
        public final Builder topContributors(Collection<MonitorTopContributorsRow> topContributors) {
            this.topContributors = MonitorTopContributorsRowListCopier.copy(topContributors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topContributors(MonitorTopContributorsRow ... topContributors) {
            this.topContributors(Arrays.asList(topContributors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topContributors(Consumer<MonitorTopContributorsRow.Builder> ... topContributors) {
            this.topContributors(Stream.of(topContributors).map(c -> (MonitorTopContributorsRow)((MonitorTopContributorsRow.Builder)MonitorTopContributorsRow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetQueryResultsMonitorTopContributorsResponse build() {
            return new GetQueryResultsMonitorTopContributorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkFlowMonitorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQueryResultsMonitorTopContributorsResponse> {
        public Builder unit(String var1);

        public Builder unit(MetricUnit var1);

        public Builder topContributors(Collection<MonitorTopContributorsRow> var1);

        public Builder topContributors(MonitorTopContributorsRow ... var1);

        public Builder topContributors(Consumer<MonitorTopContributorsRow.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

