/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkflowmonitor.model.ScopeStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScopeSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScopeSummary> {
    private static final SdkField<String> SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scopeId").getter(ScopeSummary.getter(ScopeSummary::scopeId)).setter(ScopeSummary.setter(Builder::scopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopeId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ScopeSummary.getter(ScopeSummary::statusAsString)).setter(ScopeSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> SCOPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scopeArn").getter(ScopeSummary.getter(ScopeSummary::scopeArn)).setter(ScopeSummary.setter(Builder::scopeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopeArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_ID_FIELD, STATUS_FIELD, SCOPE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("scopeId", SCOPE_ID_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("scopeArn", SCOPE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String scopeId;
    private final String status;
    private final String scopeArn;

    private ScopeSummary(BuilderImpl builder) {
        this.scopeId = builder.scopeId;
        this.status = builder.status;
        this.scopeArn = builder.scopeArn;
    }

    public final String scopeId() {
        return this.scopeId;
    }

    public final ScopeStatus status() {
        return ScopeStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String scopeArn() {
        return this.scopeArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScopeSummary)) {
            return false;
        }
        ScopeSummary other = (ScopeSummary)obj;
        return Objects.equals(this.scopeId(), other.scopeId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.scopeArn(), other.scopeArn());
    }

    public final String toString() {
        return ToString.builder((String)"ScopeSummary").add("ScopeId", (Object)this.scopeId()).add("Status", (Object)this.statusAsString()).add("ScopeArn", (Object)this.scopeArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scopeId": {
                return Optional.ofNullable(clazz.cast(this.scopeId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "scopeArn": {
                return Optional.ofNullable(clazz.cast(this.scopeArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ScopeSummary, T> g) {
        return obj -> g.apply((ScopeSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scopeId;
        private String status;
        private String scopeArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ScopeSummary model) {
            this.scopeId(model.scopeId);
            this.status(model.status);
            this.scopeArn(model.scopeArn);
        }

        public final String getScopeId() {
            return this.scopeId;
        }

        public final void setScopeId(String scopeId) {
            this.scopeId = scopeId;
        }

        @Override
        public final Builder scopeId(String scopeId) {
            this.scopeId = scopeId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ScopeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getScopeArn() {
            return this.scopeArn;
        }

        public final void setScopeArn(String scopeArn) {
            this.scopeArn = scopeArn;
        }

        @Override
        public final Builder scopeArn(String scopeArn) {
            this.scopeArn = scopeArn;
            return this;
        }

        public ScopeSummary build() {
            return new ScopeSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScopeSummary> {
        public Builder scopeId(String var1);

        public Builder status(String var1);

        public Builder status(ScopeStatus var1);

        public Builder scopeArn(String var1);
    }
}

