/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkflowmonitor.model.MetricUnit;
import software.amazon.awssdk.services.networkflowmonitor.model.NetworkFlowMonitorResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.WorkloadInsightsTopContributorsDataPoint;
import software.amazon.awssdk.services.networkflowmonitor.model.WorkloadInsightsTopContributorsDataPointsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQueryResultsWorkloadInsightsTopContributorsDataResponse
extends NetworkFlowMonitorResponse
implements ToCopyableBuilder<Builder, GetQueryResultsWorkloadInsightsTopContributorsDataResponse> {
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(GetQueryResultsWorkloadInsightsTopContributorsDataResponse.getter(GetQueryResultsWorkloadInsightsTopContributorsDataResponse::unitAsString)).setter(GetQueryResultsWorkloadInsightsTopContributorsDataResponse.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<List<WorkloadInsightsTopContributorsDataPoint>> DATAPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("datapoints").getter(GetQueryResultsWorkloadInsightsTopContributorsDataResponse.getter(GetQueryResultsWorkloadInsightsTopContributorsDataResponse::datapoints)).setter(GetQueryResultsWorkloadInsightsTopContributorsDataResponse.setter(Builder::datapoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datapoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkloadInsightsTopContributorsDataPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetQueryResultsWorkloadInsightsTopContributorsDataResponse.getter(GetQueryResultsWorkloadInsightsTopContributorsDataResponse::nextToken)).setter(GetQueryResultsWorkloadInsightsTopContributorsDataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNIT_FIELD, DATAPOINTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("unit", UNIT_FIELD);
            this.put("datapoints", DATAPOINTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String unit;
    private final List<WorkloadInsightsTopContributorsDataPoint> datapoints;
    private final String nextToken;

    private GetQueryResultsWorkloadInsightsTopContributorsDataResponse(BuilderImpl builder) {
        super(builder);
        this.unit = builder.unit;
        this.datapoints = builder.datapoints;
        this.nextToken = builder.nextToken;
    }

    public final MetricUnit unit() {
        return MetricUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public final boolean hasDatapoints() {
        return this.datapoints != null && !(this.datapoints instanceof SdkAutoConstructList);
    }

    public final List<WorkloadInsightsTopContributorsDataPoint> datapoints() {
        return this.datapoints;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatapoints() ? this.datapoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryResultsWorkloadInsightsTopContributorsDataResponse)) {
            return false;
        }
        GetQueryResultsWorkloadInsightsTopContributorsDataResponse other = (GetQueryResultsWorkloadInsightsTopContributorsDataResponse)((Object)obj);
        return Objects.equals(this.unitAsString(), other.unitAsString()) && this.hasDatapoints() == other.hasDatapoints() && Objects.equals(this.datapoints(), other.datapoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetQueryResultsWorkloadInsightsTopContributorsDataResponse").add("Unit", (Object)this.unitAsString()).add("Datapoints", this.hasDatapoints() ? this.datapoints() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "datapoints": {
                return Optional.ofNullable(clazz.cast(this.datapoints()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetQueryResultsWorkloadInsightsTopContributorsDataResponse, T> g) {
        return obj -> g.apply((GetQueryResultsWorkloadInsightsTopContributorsDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFlowMonitorResponse.BuilderImpl
    implements Builder {
        private String unit;
        private List<WorkloadInsightsTopContributorsDataPoint> datapoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryResultsWorkloadInsightsTopContributorsDataResponse model) {
            super(model);
            this.unit(model.unit);
            this.datapoints(model.datapoints);
            this.nextToken(model.nextToken);
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(MetricUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final List<WorkloadInsightsTopContributorsDataPoint.Builder> getDatapoints() {
            List<WorkloadInsightsTopContributorsDataPoint.Builder> result = WorkloadInsightsTopContributorsDataPointsCopier.copyToBuilder(this.datapoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatapoints(Collection<WorkloadInsightsTopContributorsDataPoint.BuilderImpl> datapoints) {
            this.datapoints = WorkloadInsightsTopContributorsDataPointsCopier.copyFromBuilder(datapoints);
        }

        @Override
        public final Builder datapoints(Collection<WorkloadInsightsTopContributorsDataPoint> datapoints) {
            this.datapoints = WorkloadInsightsTopContributorsDataPointsCopier.copy(datapoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datapoints(WorkloadInsightsTopContributorsDataPoint ... datapoints) {
            this.datapoints(Arrays.asList(datapoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datapoints(Consumer<WorkloadInsightsTopContributorsDataPoint.Builder> ... datapoints) {
            this.datapoints(Stream.of(datapoints).map(c -> (WorkloadInsightsTopContributorsDataPoint)((WorkloadInsightsTopContributorsDataPoint.Builder)WorkloadInsightsTopContributorsDataPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetQueryResultsWorkloadInsightsTopContributorsDataResponse build() {
            return new GetQueryResultsWorkloadInsightsTopContributorsDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkFlowMonitorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQueryResultsWorkloadInsightsTopContributorsDataResponse> {
        public Builder unit(String var1);

        public Builder unit(MetricUnit var1);

        public Builder datapoints(Collection<WorkloadInsightsTopContributorsDataPoint> var1);

        public Builder datapoints(WorkloadInsightsTopContributorsDataPoint ... var1);

        public Builder datapoints(Consumer<WorkloadInsightsTopContributorsDataPoint.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

